/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.jsflibraryconfig;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryConfigModel;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryConfiglModelSource;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryInternalReference;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistry;
import org.eclipse.jst.jsf.core.internal.project.facet.IJSFFacetInstallDataModelProperties;
import org.eclipse.jst.jsf.ui.internal.JSFUiPlugin;
import org.eclipse.jst.jsf.ui.internal.Messages;
import org.eclipse.jst.jsf.ui.internal.classpath.JSFLibraryWizard;
import org.eclipse.jst.jsf.ui.internal.jsflibraryconfig.IJSFImplLibraryCreationListener;
import org.eclipse.jst.jsf.ui.internal.jsflibraryconfig.JSFImplLibraryCreationEvent;
import org.eclipse.jst.jsf.ui.internal.jsflibraryconfig.JSFLibraryConfigControlChangeEvent;
import org.eclipse.jst.jsf.ui.internal.jsflibraryconfig.JSFLibraryConfigControlChangeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelSynchHelper;

public class JSFLibraryConfigControl
extends Composite {
    private static final int COLUMN_DEPLOY = 0;
    private static final int COLUMN_LIB_NAME = 1;
    private JSFLibraryConfigModel workingCopyModel = null;
    private Button btnServerSupplied;
    private Button btnUserSupplied;
    private ComboViewer cvImplLib;
    private CheckboxTableViewer ctvSelCompLib;
    private Button btnDeployJars;
    private TreeViewer tvCompLib;
    private TreeViewerAdapter tvAdapter;
    private TreeLabelProvider tvLabelProvider;
    private Combo comboImplLib;
    private Button btnAddAll;
    private Button btnRemoveAll;
    private Vector newJSFLibCreatedListeners = new Vector();
    private Set _changeListeners;
    private boolean _initing = true;
    private IDataModel model;

    public void addOkClickedListener(IJSFImplLibraryCreationListener listener) {
        this.newJSFLibCreatedListeners.addElement(listener);
    }

    public void removeOkClickedListener(IJSFImplLibraryCreationListener listener) {
        this.newJSFLibCreatedListeners.removeElement(listener);
    }

    public void addChangeListener(JSFLibraryConfigControlChangeListener listener) {
        this.getChangeListeners().add(listener);
    }

    public void removeChangeListener(JSFLibraryConfigControlChangeListener listener) {
        if (this.getChangeListeners().contains(listener)) {
            this.getChangeListeners().remove(listener);
        }
    }

    private Set getChangeListeners() {
        if (this._changeListeners == null) {
            this._changeListeners = new HashSet();
        }
        return this._changeListeners;
    }

    private void fireChangedEvent(final EventObject e) {
        if (this._initing) {
            return;
        }
        SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                JSFUiPlugin.log(4, exception.getLocalizedMessage());
            }

            public void run() throws Exception {
                Iterator it = JSFLibraryConfigControl.this.getChangeListeners().iterator();
                while (it.hasNext()) {
                    ((JSFLibraryConfigControlChangeListener)it.next()).changed(new JSFLibraryConfigControlChangeEvent(e));
                }
            }
        });
    }

    public JSFLibraryConfigControl(Composite parent, int style) {
        super(parent, style);
        this.createControls();
    }

    public void loadControlValuesFromModel(JSFLibraryConfiglModelSource source) {
        if (source != null) {
            this.workingCopyModel = JSFLibraryConfigModel.JSFLibraryConfigModelFactory.createInstance((JSFLibraryConfiglModelSource)source);
            this.initializeControlValues();
            this._initing = false;
        } else {
            JSFUiPlugin.log(4, Messages.JSFLibraryConfigControl_NullProject);
        }
    }

    public void dispose() {
        super.dispose();
    }

    public JSFLibraryInternalReference getSelectedJSFLibImplementation() {
        return this.workingCopyModel.getCurrentJSFImplementationLibrarySelection();
    }

    public List getSelectedJSFLibComponents() {
        return this.workingCopyModel.getCurrentJSFComponentLibrarySelection();
    }

    public JSFLibraryConfigModel getWorkingModel() {
        return this.workingCopyModel;
    }

    private void initializeControlValues() {
        this.loadJSFImplList();
        this.btnDeployJars.setSelection(false);
        JSFLibraryInternalReference savedImplLib = this.workingCopyModel.getSavedJSFImplementationLibrary();
        if (savedImplLib != null) {
            JSFLibraryInternalReference selected = JSFLibraryRegistryUtil.getInstance().getJSFLibraryReferencebyID(savedImplLib.getID());
            if (selected != null) {
                this.btnDeployJars.setSelection(selected.isCheckedToBeDeployed());
                this.cvImplLib.setSelection((ISelection)new StructuredSelection((Object)selected), true);
            }
        } else {
            JSFLibraryInternalReference dftJSFImplLib = JSFLibraryRegistryUtil.getInstance().getDefaultJSFImplementationLibrary();
            if (dftJSFImplLib != null) {
                this.btnDeployJars.setSelection(dftJSFImplLib.isCheckedToBeDeployed());
                this.cvImplLib.setSelection((ISelection)new StructuredSelection((Object)dftJSFImplLib), true);
            } else {
                this.btnDeployJars.setEnabled(false);
            }
        }
        this.loadJSFCompList();
        JSFLibraryInternalReference savedCompLib2 = null;
        JSFLibraryInternalReference selected = null;
        for (JSFLibraryInternalReference savedCompLib2 : this.workingCopyModel.getJSFComponentLibraries()) {
            selected = JSFLibraryRegistryUtil.getInstance().getJSFLibraryReferencebyID(savedCompLib2.getID());
            if (selected == null) continue;
            this.ctvSelCompLib.setChecked((Object)selected, selected.isCheckedToBeDeployed());
        }
        this.setCompListModelProperty();
        this.initializeImplementationType();
        this.redraw();
    }

    private void initializeImplementationType() {
        IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE implType = this.workingCopyModel.getImplementationType();
        if (implType == IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.SERVER_SUPPLIED) {
            this.btnServerSupplied.setSelection(true);
            this.btnUserSupplied.setSelection(false);
            this.enableUserSupplied(false);
        } else if (implType == IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.USER_SPECIFIED) {
            this.btnServerSupplied.setSelection(false);
            this.btnUserSupplied.setSelection(true);
            this.enableUserSupplied(true);
        } else {
            this.enableUserSupplied(false);
        }
        this.model.setProperty("IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE_PROPERTY_NAME", (Object)implType);
    }

    private void loadJSFImplList() {
        this.cvImplLib.setInput((Object)this.workingCopyModel.getJSFImplementationLibraries());
    }

    private void loadJSFCompList() {
        this.tvCompLib.setInput((Object)this.workingCopyModel.getJSFComponentLibraries());
        this.ctvSelCompLib.setInput((Object)this.workingCopyModel.getJSFComponentLibraries());
    }

    private JSFLibraryInternalReference getCurrentSelectedJSFImplLib() {
        JSFLibraryInternalReference selJSFImpl = null;
        StructuredSelection objs = (StructuredSelection)this.cvImplLib.getSelection();
        if (objs != null && objs.getFirstElement() instanceof JSFLibraryInternalReference) {
            selJSFImpl = (JSFLibraryInternalReference)objs.getFirstElement();
        }
        return selJSFImpl;
    }

    private void createImplLibControls(Composite parent) {
        Composite cmpImpls = new Composite(parent, 0);
        GridLayout gridLayoutImpls = new GridLayout();
        gridLayoutImpls.numColumns = 4;
        gridLayoutImpls.marginLeft = 0;
        gridLayoutImpls.marginTop = 0;
        gridLayoutImpls.marginBottom = 0;
        cmpImpls.setLayout((Layout)gridLayoutImpls);
        GridData gdCmpImpls = new GridData();
        gdCmpImpls.horizontalAlignment = 4;
        gdCmpImpls.grabExcessHorizontalSpace = true;
        cmpImpls.setLayoutData((Object)gdCmpImpls);
        this.btnServerSupplied = new Button(cmpImpls, 16);
        this.btnServerSupplied.setToolTipText(Messages.JSFLibraryConfigControl_ServerSuppliedButtonTooltip);
        GridData gdSS = new GridData();
        gdSS.horizontalAlignment = 1;
        this.btnServerSupplied.setLayoutData((Object)gdSS);
        this.btnServerSupplied.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSFLibraryConfigControl.this.setServerSuppliedLibrarySelection((EventObject)e);
            }
        });
        Label lblServerSupplied = new Label(cmpImpls, 0);
        lblServerSupplied.setText(Messages.JSFLibraryConfigControl_ServerSuppliedButtonLabel);
        GridData lblSS = new GridData();
        lblSS.grabExcessHorizontalSpace = true;
        lblServerSupplied.setLayoutData((Object)lblSS);
        lblServerSupplied.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                JSFLibraryConfigControl.this.btnServerSupplied.setSelection(true);
                JSFLibraryConfigControl.this.setServerSuppliedLibrarySelection((EventObject)e);
            }
        });
        Label lblSpacer1 = new Label(cmpImpls, 0);
        GridData gdSpc1 = new GridData();
        gdSpc1.horizontalAlignment = 0x1000008;
        gdSpc1.horizontalSpan = 2;
        lblSpacer1.setLayoutData((Object)gdSpc1);
        this.btnUserSupplied = new Button(cmpImpls, 16);
        this.btnUserSupplied.setLayoutData((Object)new GridData());
        this.btnUserSupplied.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSFLibraryConfigControl.this.setUserSuppliedLibrarySelection((EventObject)e);
            }
        });
        this.addOkClickedListener(new IJSFImplLibraryCreationListener(){

            public void okClicked(JSFImplLibraryCreationEvent event) {
                if (!JSFLibraryConfigControl.this.btnUserSupplied.getSelection() && event.isLibraryCreated()) {
                    JSFLibraryConfigControl.this.btnServerSupplied.setSelection(false);
                    JSFLibraryConfigControl.this.setUserSuppliedLibrarySelection(event);
                }
            }
        });
        this.cvImplLib = new ComboViewer(cmpImpls, 8);
        this.cvImplLib.setLabelProvider((IBaseLabelProvider)new ImplLibCVListLabelProvider());
        this.cvImplLib.setContentProvider((IContentProvider)new ImplLibCVContentProvider());
        this.comboImplLib = this.cvImplLib.getCombo();
        GridData gd_cvImplLib = new GridData();
        gd_cvImplLib.horizontalAlignment = 4;
        gd_cvImplLib.grabExcessHorizontalSpace = true;
        this.comboImplLib.setLayoutData((Object)gd_cvImplLib);
        this.cvImplLib.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection ss = (StructuredSelection)event.getSelection();
                JSFLibraryInternalReference crtSelImplLib = (JSFLibraryInternalReference)ss.getFirstElement();
                if (crtSelImplLib != null) {
                    JSFLibraryConfigControl.this.btnDeployJars.setEnabled(true);
                    crtSelImplLib.setToBeDeployed(JSFLibraryConfigControl.this.btnDeployJars.getSelection());
                }
                JSFLibraryConfigControl.this.workingCopyModel.setCurrentJSFImplementationLibrarySelection(crtSelImplLib);
                JSFLibraryConfigControl.this.model.setProperty("IJSFFacetInstallDataModelProperties.IMPLEMENTATION", (Object)crtSelImplLib);
                JSFLibraryConfigControl.this.fireChangedEvent((EventObject)event);
            }
        });
        this.btnDeployJars = new Button(cmpImpls, 32);
        GridData gdDeploy = new GridData();
        this.btnDeployJars.setLayoutData((Object)gdDeploy);
        this.btnDeployJars.setText(Messages.JSFLibraryConfigControl_DeployButtonLabel);
        this.btnDeployJars.setToolTipText(Messages.JSFLibraryConfigControl_DeployJAR);
        this.btnDeployJars.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!JSFLibraryConfigControl.this._initing) {
                    JSFLibraryInternalReference jsflib = JSFLibraryConfigControl.this.getCurrentSelectedJSFImplLib();
                    if (jsflib != null) {
                        jsflib.setToBeDeployed(JSFLibraryConfigControl.this.btnDeployJars.getSelection());
                    }
                    JSFLibraryConfigControl.this.workingCopyModel.setCurrentJSFImplementationLibrarySelection(jsflib);
                    JSFLibraryConfigControl.this.fireChangedEvent((EventObject)e);
                }
            }
        });
        Button btnNewImpl = new Button(cmpImpls, 0);
        GridData gdNew = new GridData();
        gdNew.horizontalAlignment = 0x1000008;
        btnNewImpl.setLayoutData((Object)gdNew);
        btnNewImpl.setText(Messages.JSFLibraryConfigControl_NewImplementationLibrary);
        btnNewImpl.setToolTipText(Messages.JSFLibraryConfigControl_NewImplButtonTooltip);
        btnNewImpl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSFLibraryWizard wizard = new JSFLibraryWizard(1);
                IWorkbench wb = PlatformUI.getWorkbench();
                wizard.init(wb, null);
                WizardDialog dialog = new WizardDialog(wb.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                int ret = dialog.open();
                if (ret == 0) {
                    JSFLibraryInternalReference lib = new JSFLibraryInternalReference(wizard.getJSFLibrary(), true, true);
                    JSFLibraryRegistryUtil.getInstance().addJSFLibrary(lib);
                    JSFLibraryConfigControl.this.workingCopyModel.getJSFImplementationLibraries().add(lib);
                    JSFLibraryConfigControl.this.workingCopyModel.setCurrentJSFImplementationLibrarySelection(lib);
                    JSFLibraryConfigControl.this.loadJSFImplList();
                    JSFLibraryConfigControl.this.btnDeployJars.setSelection(true);
                    JSFLibraryConfigControl.this.cvImplLib.setSelection((ISelection)new StructuredSelection((Object)lib), true);
                }
                JSFImplLibraryCreationEvent event = new JSFImplLibraryCreationEvent((Object)this, ret == 0);
                int size = JSFLibraryConfigControl.this.newJSFLibCreatedListeners.size();
                int i = 0;
                while (i < size) {
                    IJSFImplLibraryCreationListener listener = (IJSFImplLibraryCreationListener)JSFLibraryConfigControl.this.newJSFLibCreatedListeners.elementAt(i);
                    listener.okClicked(event);
                    ++i;
                }
            }
        });
    }

    private void setServerSuppliedLibrarySelection(EventObject e) {
        this.btnUserSupplied.setSelection(false);
        this.model.setProperty("IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE_PROPERTY_NAME", (Object)IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.SERVER_SUPPLIED);
        this.enableUserSupplied(false);
        this.fireChangedEvent(e);
    }

    private void setUserSuppliedLibrarySelection(EventObject e) {
        this.btnUserSupplied.setSelection(true);
        this.model.setProperty("IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE_PROPERTY_NAME", (Object)IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.USER_SPECIFIED);
        this.enableUserSupplied(true);
        this.fireChangedEvent(e);
    }

    private void enableUserSupplied(boolean enabled) {
        this.cvImplLib.getCombo().setEnabled(enabled);
        this.btnDeployJars.setEnabled(enabled);
    }

    private void createCompLibControls(Composite parent) {
        Composite cmpCompLibs = new Composite(parent, 0);
        GridLayout gridLayoutCompLibs = new GridLayout();
        gridLayoutCompLibs.numColumns = 4;
        gridLayoutCompLibs.marginLeft = 0;
        gridLayoutCompLibs.marginRight = 0;
        gridLayoutCompLibs.marginWidth = 0;
        cmpCompLibs.setLayout((Layout)gridLayoutCompLibs);
        GridData gdComp = new GridData();
        gdComp.horizontalAlignment = 4;
        gdComp.grabExcessHorizontalSpace = true;
        cmpCompLibs.setLayoutData((Object)gdComp);
        Label lblCompLib = new Label(cmpCompLibs, 0);
        GridData gd_lbl_complib = new GridData(4, 2, false, false, 4, 1);
        lblCompLib.setLayoutData((Object)gd_lbl_complib);
        lblCompLib.setText(Messages.JSFLibraryConfigControl_ComponentLibrary);
        this.tvCompLib = new TreeViewer(cmpCompLibs, 2816);
        this.tvAdapter = new TreeViewerAdapter();
        this.tvLabelProvider = new TreeLabelProvider();
        this.tvCompLib.setContentProvider((IContentProvider)this.tvAdapter);
        this.tvCompLib.setLabelProvider((IBaseLabelProvider)this.tvLabelProvider);
        this.tvCompLib.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                JSFLibraryConfigControl.this.resetComponentLibSelection((StructuredSelection)event.getSelection(), JSFLibraryConfigControl.this.tvCompLib, JSFLibraryConfigControl.this.ctvSelCompLib, true);
                JSFLibraryConfigControl.this.fireChangedEvent((EventObject)event);
            }
        });
        this.tvCompLib.getTree().setLayoutData((Object)new GridData(1808));
        this.tvCompLib.addFilter((ViewerFilter)new TreeViewerFilter());
        Composite composite_buttons = new Composite(cmpCompLibs, 0);
        composite_buttons.setLayoutData((Object)new GridData(4, 4, false, false));
        composite_buttons.setLayout((Layout)new GridLayout());
        Composite composite_Single = new Composite(composite_buttons, 0);
        composite_Single.setLayoutData((Object)new GridData(768));
        GridLayout gl_Single = new GridLayout();
        gl_Single.marginHeight = 4;
        composite_Single.setLayout((Layout)gl_Single);
        final Button btnAdd = new Button(composite_Single, 0);
        btnAdd.setLayoutData((Object)new GridData(4, 2, true, false));
        btnAdd.setText(Messages.JSFLibraryConfigControl_Add);
        btnAdd.setEnabled(false);
        final Button btnRemove = new Button(composite_Single, 0);
        btnRemove.setLayoutData((Object)new GridData(4, 2, true, false));
        btnRemove.setText(Messages.JSFLibraryConfigControl_Remove);
        btnRemove.setEnabled(false);
        Composite composite_All = new Composite(composite_buttons, 0);
        composite_All.setLayoutData((Object)new GridData(768));
        GridLayout gl_All = new GridLayout();
        gl_Single.marginHeight = 4;
        composite_All.setLayout((Layout)gl_All);
        this.btnAddAll = new Button(composite_All, 0);
        this.btnAddAll.setLayoutData((Object)new GridData(4, 2, true, false));
        this.btnAddAll.setText(Messages.JSFLibraryConfigControl_AddAll);
        this.btnRemoveAll = new Button(composite_All, 0);
        this.btnRemoveAll.setLayoutData((Object)new GridData(4, 2, true, false));
        this.btnRemoveAll.setText(Messages.JSFLibraryConfigControl_RemoveAll);
        Composite composite_New = new Composite(composite_buttons, 0);
        composite_New.setLayoutData((Object)new GridData(768));
        GridLayout gl_New = new GridLayout();
        gl_Single.marginHeight = 4;
        composite_New.setLayout((Layout)gl_New);
        Button btnNewCompLib = new Button(composite_New, 0);
        btnNewCompLib.setLayoutData((Object)new GridData(4, 2, false, false));
        btnNewCompLib.setText(Messages.JSFLibraryConfigControl_NewComponentLibrary);
        btnNewCompLib.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSFLibraryWizard wizard = new JSFLibraryWizard(2);
                IWorkbench wb = PlatformUI.getWorkbench();
                wizard.init(wb, null);
                WizardDialog dialog = new WizardDialog(wb.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                int ret = dialog.open();
                if (ret == 0) {
                    JSFLibraryInternalReference lib = new JSFLibraryInternalReference(wizard.getJSFLibrary(), true, true);
                    JSFLibraryRegistryUtil.getInstance().addJSFLibrary(lib);
                    JSFLibraryConfigControl.this.workingCopyModel.getJSFComponentLibraries().add(lib);
                    JSFLibraryConfigControl.this.loadJSFCompList();
                    JSFLibraryConfigControl.this.setCompListModelProperty();
                    JSFLibraryConfigControl.this.ctvSelCompLib.setChecked((Object)lib, true);
                }
            }
        });
        this.ctvSelCompLib = CheckboxTableViewer.newCheckList((Composite)cmpCompLibs, (int)67586);
        this.ctvSelCompLib.addFilter((ViewerFilter)new CheckedTableViewerFilter());
        Table table = this.ctvSelCompLib.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(true);
        TableColumn tcDeploy = new TableColumn(table, 16384);
        tcDeploy.setWidth(50);
        tcDeploy.setText(Messages.JSFLibraryConfigControl_TH_Deploy);
        tcDeploy.setToolTipText(Messages.JSFLibraryConfigControl_DeployJAR);
        TableColumn tcLibName = new TableColumn(table, 16384);
        tcLibName.setWidth(150);
        tcLibName.setText(Messages.JSFLibraryConfigControl_TH_LibraryName);
        this.ctvSelCompLib.setSorter((ViewerSorter)new SelectedCompLibCTVSorter());
        this.ctvSelCompLib.setLabelProvider((IBaseLabelProvider)new SelectedCompLibCTVLabelProvider());
        this.ctvSelCompLib.setContentProvider((IContentProvider)new CompLibCTVContentProvider());
        this.ctvSelCompLib.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                JSFLibraryConfigControl.this.resetComponentLibSelection((StructuredSelection)event.getSelection(), JSFLibraryConfigControl.this.tvCompLib, JSFLibraryConfigControl.this.ctvSelCompLib, false);
                JSFLibraryConfigControl.this.fireChangedEvent((EventObject)event);
            }
        });
        this.ctvSelCompLib.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                JSFLibraryInternalReference changedItem = (JSFLibraryInternalReference)event.getElement();
                boolean isChecked4Deploy = event.getChecked();
                List list = JSFLibraryConfigControl.this.workingCopyModel.getJSFComponentLibraries();
                Iterator it = list.iterator();
                JSFLibraryInternalReference crtjsflib = null;
                while (it.hasNext()) {
                    crtjsflib = (JSFLibraryInternalReference)it.next();
                    if (!crtjsflib.getID().equals(changedItem.getID())) continue;
                    crtjsflib.setToBeDeployed(isChecked4Deploy);
                    JSFLibraryConfigControl.this.fireChangedEvent((EventObject)event);
                    break;
                }
            }
        });
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSFLibraryConfigControl.this.resetComponentLibSelection((StructuredSelection)JSFLibraryConfigControl.this.tvCompLib.getSelection(), JSFLibraryConfigControl.this.tvCompLib, JSFLibraryConfigControl.this.ctvSelCompLib, true);
                JSFLibraryConfigControl.this.fireChangedEvent((EventObject)e);
            }
        });
        this.btnAddAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSFLibraryConfigControl.this.resetCompontLibSelectionAll(JSFLibraryConfigControl.this.tvCompLib, JSFLibraryConfigControl.this.ctvSelCompLib, true);
                JSFLibraryConfigControl.this.fireChangedEvent((EventObject)e);
            }
        });
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSFLibraryConfigControl.this.resetComponentLibSelection((StructuredSelection)JSFLibraryConfigControl.this.ctvSelCompLib.getSelection(), JSFLibraryConfigControl.this.tvCompLib, JSFLibraryConfigControl.this.ctvSelCompLib, false);
                JSFLibraryConfigControl.this.fireChangedEvent((EventObject)e);
            }
        });
        this.btnRemoveAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSFLibraryConfigControl.this.resetCompontLibSelectionAll(JSFLibraryConfigControl.this.tvCompLib, JSFLibraryConfigControl.this.ctvSelCompLib, false);
                JSFLibraryConfigControl.this.fireChangedEvent((EventObject)e);
            }
        });
        this.tvCompLib.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection sel = (StructuredSelection)event.getSelection();
                btnAdd.setEnabled(!sel.isEmpty() && sel.getFirstElement() instanceof JSFLibraryInternalReference);
                JSFLibraryConfigControl.this.btnAddAll.setEnabled(JSFLibraryConfigControl.this.tvCompLib.getTree().getItemCount() > 0);
            }
        });
        this.ctvSelCompLib.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection sel = (StructuredSelection)event.getSelection();
                btnRemove.setEnabled(!sel.isEmpty());
                JSFLibraryConfigControl.this.btnRemoveAll.setEnabled(JSFLibraryConfigControl.this.ctvSelCompLib.getTable().getItemCount() > 0);
            }
        });
    }

    private void createControls() {
        this.setRedraw(true);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 0;
        this.setLayout((Layout)gridLayout);
        this.createImplLibControls(this);
        this.createSeparator(this);
        this.createCompLibControls(this);
    }

    private void createSeparator(Composite parent) {
        Label lblSeparator = new Label(parent, 258);
        GridData gd_lbl_spacer = new GridData();
        gd_lbl_spacer.horizontalAlignment = 4;
        lblSeparator.setLayoutData((Object)gd_lbl_spacer);
        lblSeparator.setAlignment(0x1000000);
    }

    private void resetComponentLibSelection(StructuredSelection item, TreeViewer srcViewer, CheckboxTableViewer destViewer, boolean state) {
        if (item != null && !item.isEmpty()) {
            ArrayList<JSFLibraryInternalReference> selected = new ArrayList<JSFLibraryInternalReference>(item.size());
            for (JSFLibraryInternalReference jsfLibDctr : item) {
                selected.add(jsfLibDctr);
                List list = this.workingCopyModel.getJSFComponentLibraries();
                Iterator it = list.iterator();
                JSFLibraryInternalReference crtjsfLibDctr = null;
                while (it.hasNext()) {
                    crtjsfLibDctr = (JSFLibraryInternalReference)it.next();
                    if (!crtjsfLibDctr.getID().equals(jsfLibDctr.getID())) continue;
                    crtjsfLibDctr.setToBeDeployed(state);
                    crtjsfLibDctr.setSelected(state);
                }
            }
            this.loadJSFCompList();
            srcViewer.refresh();
            destViewer.refresh();
            Iterator it = selected.iterator();
            while (it.hasNext()) {
                destViewer.setChecked(it.next(), state);
            }
            this.setCompListModelProperty();
        }
    }

    private void resetCompontLibSelectionAll(TreeViewer srcViewer, CheckboxTableViewer destViewer, boolean state) {
        List list = this.workingCopyModel.getJSFComponentLibraries();
        for (JSFLibraryInternalReference jsfLibDctr : list) {
            jsfLibDctr.setSelected(state);
            jsfLibDctr.setToBeDeployed(state);
        }
        this.loadJSFCompList();
        srcViewer.refresh();
        destViewer.refresh();
        destViewer.setAllChecked(state);
        this.btnAddAll.setEnabled(!state);
        this.btnRemoveAll.setEnabled(state);
        this.setCompListModelProperty();
    }

    private void setCompListModelProperty() {
        TableItem[] tableItems = this.ctvSelCompLib.getTable().getItems();
        ArrayList<Object> compLibs = new ArrayList<Object>(tableItems.length);
        int i = 0;
        while (i < tableItems.length) {
            compLibs.add(tableItems[i].getData());
            ++i;
        }
        JSFLibraryInternalReference[] libs = compLibs.toArray(new JSFLibraryInternalReference[0]);
        this.model.setProperty("IJSFFacetInstallDataModelProperties.COMPONENT_LIBRARIES", (Object)libs);
    }

    public void setSynchHelper(DataModelSynchHelper synchHelper) {
        this.model = synchHelper.getDataModel();
        synchHelper.synchCombo(this.cvImplLib.getCombo(), "IJSFFacetInstallDataModelProperties.IMPLEMENTATION_LIBRARIES", null);
        synchHelper.synchCheckbox(this.btnDeployJars, "IJSFFacetInstallDataModelProperties.DEPLOY_IMPLEMENTATION", null);
    }

    private static class CheckedTableViewerFilter
    extends ViewerFilter {
        private CheckedTableViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof JSFLibraryInternalReference) {
                return ((JSFLibraryInternalReference)element).isSelected();
            }
            return false;
        }
    }

    private static class CompLibCTVContentProvider
    implements IStructuredContentProvider {
        private List jsfComplLibs = new ArrayList(0);

        private CompLibCTVContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.jsfComplLibs.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.jsfComplLibs = newInput == null ? Collections.EMPTY_LIST : (List)newInput;
        }
    }

    private static class ImplLibCVContentProvider
    implements IStructuredContentProvider {
        private List jsfImplLibs = new ArrayList(0);

        private ImplLibCVContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.jsfImplLibs.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.jsfImplLibs = newInput == null ? Collections.EMPTY_LIST : (List)newInput;
        }
    }

    private static class ImplLibCVListLabelProvider
    extends LabelProvider {
        private JSFLibrary defaultImpl = null;

        private ImplLibCVListLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof JSFLibraryInternalReference) {
                StringBuffer labelBuf = new StringBuffer(((JSFLibraryInternalReference)element).getLabel());
                JSFLibrary lib = ((JSFLibraryInternalReference)element).getLibrary();
                if (this.getDefaultImpl() != null && lib != null && lib.getID().equals(this.getDefaultImpl().getID())) {
                    labelBuf.append(" ").append(JSFLibraryRegistry.DEFAULT_IMPL_LABEL);
                }
                return labelBuf.toString();
            }
            return null;
        }

        private JSFLibrary getDefaultImpl() {
            if (this.defaultImpl == null) {
                JSFLibraryRegistry jsflibreg = JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry();
                this.defaultImpl = jsflibreg.getDefaultImplementation();
            }
            return this.defaultImpl;
        }

        public Image getImage(Object element) {
            return null;
        }
    }

    private static class SelectedCompLibCTVLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private SelectedCompLibCTVLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof JSFLibraryInternalReference) {
                switch (columnIndex) {
                    case 0: {
                        return " ";
                    }
                    case 1: {
                        return ((JSFLibraryInternalReference)element).getLabel();
                    }
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    private static class SelectedCompLibCTVSorter
    extends ViewerSorter {
        private SelectedCompLibCTVSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof JSFLibraryInternalReference && e2 instanceof JSFLibraryInternalReference) {
                JSFLibraryInternalReference item1 = (JSFLibraryInternalReference)e1;
                JSFLibraryInternalReference item2 = (JSFLibraryInternalReference)e2;
                return item1.getLabel().compareToIgnoreCase(item2.getLabel());
            }
            return 0;
        }
    }

    private static class TreeLabelProvider
    implements ILabelProvider {
        private final Image libImg;
        private final Image jarImg;

        TreeLabelProvider() {
            ImageDescriptor jarImgDesc = JSFUiPlugin.getImageDescriptor("obj16/jar_obj.gif");
            this.jarImg = jarImgDesc.createImage();
            ImageDescriptor libImgDesc = JSFUiPlugin.getImageDescriptor("obj16/library_obj.gif");
            this.libImg = libImgDesc.createImage();
        }

        public Image getImage(Object element) {
            if (element instanceof JSFLibraryInternalReference) {
                return this.libImg;
            }
            return this.jarImg;
        }

        public String getText(Object element) {
            StringBuffer labelBuf = new StringBuffer();
            if (element instanceof JSFLibraryInternalReference) {
                JSFLibraryInternalReference libWrapper = (JSFLibraryInternalReference)element;
                JSFLibrary lib = libWrapper.getLibrary();
                labelBuf.append(lib.getLabel());
                if (lib.isImplementation()) {
                    labelBuf.append(" ");
                    if (lib == JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().getDefaultImplementation()) {
                        labelBuf.append(Messages.JSFLibrariesPreferencePage_DEFAULT_IMPL_DESC);
                    } else {
                        labelBuf.append(Messages.JSFLibrariesPreferencePage_IMPL_DESC);
                    }
                }
            }
            if (element instanceof ArchiveFile) {
                ArchiveFile jar = (ArchiveFile)element;
                labelBuf.append(jar.getName());
                if (!jar.exists()) {
                    labelBuf.append(Messages.JSFLibrariesPreferencePage_MISSING_DESC);
                }
                labelBuf.append(" - ").append(((ArchiveFile)element).getSourceLocation());
            }
            return labelBuf.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            if (this.libImg != null) {
                this.libImg.dispose();
            }
            if (this.jarImg != null) {
                this.jarImg.dispose();
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class TreeViewerAdapter
    implements ITreeContentProvider {
        private final Object[] NO_ELEMENTS = new Object[0];

        private TreeViewerAdapter() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object obj) {
            return JSFLibraryConfigControl.this.workingCopyModel.getJSFComponentLibraries().toArray();
        }

        public Object[] getChildren(Object element) {
            if (element instanceof JSFLibraryInternalReference) {
                return ((JSFLibraryInternalReference)element).getArchiveFiles().toArray();
            }
            return this.NO_ELEMENTS;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof JSFLibraryInternalReference;
        }
    }

    private static class TreeViewerFilter
    extends ViewerFilter {
        private TreeViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof JSFLibraryInternalReference) {
                return !((JSFLibraryInternalReference)element).isSelected();
            }
            return true;
        }
    }
}

