/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.jspeditor;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.context.symbol.IBeanInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IBeanMethodSymbol;
import org.eclipse.jst.jsf.context.symbol.IBeanPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.core.internal.contentassist.el.SymbolInfo;
import org.eclipse.jst.jsf.ui.internal.jspeditor.BeanSuffixHyperlink;
import org.eclipse.jst.jsf.ui.internal.jspeditor.JSPSourceUtil;
import org.eclipse.jst.jsf.ui.internal.jspeditor.JavaElementHyperlink;

public class ELHyperlinkDetector
extends AbstractHyperlinkDetector {
    public final IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext(textViewer, region.getOffset());
        return this.detectHyperlinks(context, region);
    }

    protected IHyperlink[] detectHyperlinks(IStructuredDocumentContext context, IRegion region) {
        SymbolInfo symbolInfo;
        Region elRegion = JSPSourceUtil.findELRegion(context);
        if (elRegion != null && (symbolInfo = JSPSourceUtil.determineSymbolInfo(context, elRegion, region.getOffset())) != null) {
            IHyperlink link = null;
            Region linkRegion = new Region(symbolInfo.getRelativeRegion().getOffset() + elRegion.getOffset(), symbolInfo.getRelativeRegion().getLength());
            ISymbol symbol = symbolInfo.getSymbol();
            if (symbol instanceof IBeanInstanceSymbol) {
                link = this.createBeanInstanceLink(linkRegion, (IBeanInstanceSymbol)symbol);
            } else if (symbol instanceof IBeanPropertySymbol) {
                link = this.createBeanPropertyLink(linkRegion, (IBeanPropertySymbol)symbol);
            } else if (symbol instanceof IBeanMethodSymbol) {
                link = this.createMethodLink(linkRegion, (IBeanMethodSymbol)symbol);
            }
            if (link != null) {
                return new IHyperlink[]{link};
            }
        }
        return null;
    }

    private IHyperlink createBeanInstanceLink(Region region, IBeanInstanceSymbol symbol) {
        if (symbol.isTypeResolved()) {
            IType type = symbol.getJavaTypeDescriptor().getType();
            return new JavaElementHyperlink((IRegion)region, (IJavaElement)type);
        }
        return null;
    }

    private IHyperlink createBeanPropertyLink(Region region, IBeanPropertySymbol symbol) {
        return new BeanSuffixHyperlink((IRegion)region, (ISymbol)symbol);
    }

    private IHyperlink createMethodLink(Region region, IBeanMethodSymbol symbol) {
        return new BeanSuffixHyperlink((IRegion)region, (ISymbol)symbol);
    }
}

