/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.preferences;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jst.jsf.common.internal.policy.OrderedListProvider;
import org.eclipse.jst.jsf.common.ui.internal.preferences.StrategyOrderingPanel;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.registry.TLDRegistryPreferences;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JSPTagRegistryPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final TLDRegistryPreferences _tldRegistryPreferences = new TLDRegistryPreferences(this.getPreferenceStore());
    private StrategyOrderingPanel _panel;
    private OrderedListProvider _provider;

    public JSPTagRegistryPreferencePage() {
        this._tldRegistryPreferences.load();
    }

    protected Control createContents(Composite parent) {
        this._provider = this._tldRegistryPreferences.getOrderedListProvider();
        this._panel = new StrategyOrderingPanel(this._provider, (ITableLabelProvider)new MyLabelProvider(), "Set the order in which tag resolvers are consulted when constructing the JSP tag registry");
        Control contents = this._panel.createContents(parent);
        this._panel.refresh();
        return contents;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        if (this._tldRegistryPreferences.isDirty()) {
            this._tldRegistryPreferences.commit(this.getPreferenceStore());
        }
    }

    protected void performDefaults() {
        this._tldRegistryPreferences.setDefaults();
        this._panel.refresh();
        super.performDefaults();
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return JSFCorePlugin.getDefault().getPreferenceStore();
    }

    private static class MyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private MyLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (!(element instanceof OrderedListProvider.OrderableObject)) break;
                    return ((TLDRegistryPreferences.StrategyIdentifier)((OrderedListProvider.OrderableObject)element).getObject()).getDisplayName();
                }
            }
            Assert.isTrue((boolean)false);
            return null;
        }
    }
}

