/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.tagregistry;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

abstract class AbstractDetailsForm {
    private Form _form;
    private XMLTextSection _textSection;
    private FormToolkit _toolkit;

    AbstractDetailsForm() {
    }

    public void createContents(Composite parent) {
        this._textSection = new XMLTextSection(this._toolkit, parent, this.getTitle());
        this._textSection._section.setExpanded(true);
    }

    public Control getControl() {
        return this.getTextSection().getControl();
    }

    protected XMLTextSection getTextSection() {
        return this._textSection;
    }

    protected final FormToolkit getToolkit() {
        return this._toolkit;
    }

    protected abstract String getTitle();

    public final void selectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object selectionObj = ((IStructuredSelection)selection).getFirstElement();
            this.doUpdateSelection(selectionObj);
        }
    }

    protected abstract void doUpdateSelection(Object var1);

    public void commit(boolean onSave) {
    }

    public void dispose() {
    }

    public final void initialize(FormToolkit toolkit) {
        this._toolkit = toolkit;
    }

    protected final Form getForm() {
        return this._form;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isStale() {
        return true;
    }

    public void refresh() {
    }

    public void setFocus() {
        if (this._textSection != null) {
            this._textSection._formText.setFocus();
        }
    }

    public boolean setFormInput(Object input) {
        return false;
    }

    protected static class XMLTextSection {
        private Section _section;
        private FormText _formText;
        private Composite _detailSubForm;

        public XMLTextSection(FormToolkit toolkit, Composite parent, String title) {
            this._detailSubForm = toolkit.createComposite(parent);
            this._detailSubForm.setLayout((Layout)new GridLayout(1, false));
            this._section = toolkit.createSection(this._detailSubForm, 20);
            this._section.setLayout((Layout)new GridLayout(1, true));
            this._section.setText(title);
            this._formText = toolkit.createFormText((Composite)this._section, true);
            this._formText.setText("", false, false);
            this._section.setClient((Control)this._formText);
        }

        public void setText(String text, boolean parseTags, boolean expandURLs) {
            this._formText.setText(text, parseTags, expandURLs);
        }

        public Control getControl() {
            return this._detailSubForm;
        }

        public void refresh() {
            this._detailSubForm.layout();
            this._detailSubForm.redraw();
            this._detailSubForm.update();
        }
    }
}

