/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.tagregistry;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IComponentTagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IConverterTagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IValidatorTagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.ui.internal.tagregistry.ProjectTracker;
import org.eclipse.jst.jsf.ui.internal.tagregistry.SetInputRunnable;
import org.eclipse.jst.jsf.ui.internal.tagregistry.TaglibContentProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.internal.forms.widgets.FormsResources;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class TagRegistryMasterForm {
    private TreeViewer _registryTreeViewer;
    private Action _refreshAction;
    private final FormToolkit _toolkit;
    private ISelectionChangedListener _listener;
    private final ProjectTracker _projectTracker;
    private final ProjectTracker.ProjectAdvisor _advisor;
    private ToolBarManager _toolBarManager;

    public TagRegistryMasterForm(FormToolkit toolkit) {
        this._toolkit = toolkit;
        this._advisor = new ProjectTracker.ProjectAdvisor(){

            public boolean shouldTrack(IProject project) {
                return JSFAppConfigUtils.isValidJSFProject((IProject)project);
            }
        };
        this._projectTracker = new ProjectTracker(ResourcesPlugin.getWorkspace().getRoot(), this._advisor);
    }

    public Control createContents(Composite parent) {
        Tree tree = this._toolkit.createTree(parent, 772);
        GridData gridData = new GridData(4, 0x1000000, true, true);
        tree.setLayoutData((Object)gridData);
        this._registryTreeViewer = new TreeViewer(tree);
        this._registryTreeViewer.setContentProvider((IContentProvider)new TaglibContentProvider());
        this._registryTreeViewer.setLabelProvider((IBaseLabelProvider)new CommonLabelProvider());
        this._registryTreeViewer.setSorter((ViewerSorter)new NameSorter());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this._registryTreeViewer.getControl(), "ViewHandlerPrototype.viewer");
        this._projectTracker.addListener(new ProjectTracker.ProjectTrackingListener(){

            protected void projectsChanged(IProject project, ProjectTracker.ProjectTrackingListener.Reason reason) {
                switch (reason) {
                    case ADDED: 
                    case REMOVED: {
                        if (!project.equals(TagRegistryMasterForm.this._registryTreeViewer.getInput())) break;
                        TagRegistryMasterForm.this.updateProjects();
                    }
                }
            }
        });
        this._registryTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TagRegistryMasterForm.this._listener.selectionChanged(event);
            }
        });
        this.makeActions();
        return tree;
    }

    public void dispose() {
        this._projectTracker.dispose();
    }

    private void updateProjects() {
        Set<IProject> projects = this._projectTracker.getProjects();
        Iterator<IProject> iterator = projects.iterator();
        if (iterator.hasNext()) {
            IProject project = iterator.next();
            new SetInputRunnable(project, (Viewer)this._registryTreeViewer).run();
        }
    }

    public void contributeActions(IToolBarManager manager) {
        this._toolBarManager.add((IAction)this._refreshAction);
        this._toolBarManager.update(false);
    }

    public void contributeToHead(Form form) {
        Composite head = form.getHead();
        Composite container = this._toolkit.createComposite(head);
        container.setLayout((Layout)new RowLayout());
        Label label = new Label(container, 0);
        label.setText("Project: ");
        final ComboViewer combo = new ComboViewer(container, 0x800008);
        this._toolkit.adapt(combo.getControl(), true, false);
        combo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IProject selectedProject = (IProject)selection.getFirstElement();
                TagRegistryMasterForm.this._registryTreeViewer.setInput((Object)selectedProject);
            }
        });
        combo.setLabelProvider((IBaseLabelProvider)new CommonLabelProvider());
        combo.setContentProvider((IContentProvider)new ProjectContentProvider());
        combo.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        combo.setInput((Object)this._projectTracker);
        this._projectTracker.addListener(new ProjectTracker.ProjectTrackingListener(){

            protected void projectsChanged(IProject project, ProjectTracker.ProjectTrackingListener.Reason reason) {
                combo.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        combo.refresh();
                    }
                });
            }
        });
        this._toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = this._toolBarManager.createControl(container);
        toolbar.setBackground(form.getHead().getBackground());
        toolbar.setForeground(form.getHead().getForeground());
        toolbar.setCursor(FormsResources.getHandCursor());
        container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TagRegistryMasterForm.this._toolBarManager != null) {
                    TagRegistryMasterForm.this._toolBarManager.dispose();
                    TagRegistryMasterForm.this._toolBarManager = null;
                }
            }
        });
        form.setHeadClient((Control)container);
    }

    public void initialize(ISelectionChangedListener listener) {
        this._listener = listener;
        this._projectTracker.startTracking();
    }

    private void makeActions() {
        this._refreshAction = new Action(){

            public void run() {
                Object input = TagRegistryMasterForm.this._registryTreeViewer.getInput();
                if (input instanceof IProject) {
                    TagRegistryMasterForm.this._registryTreeViewer.setInput(input);
                }
            }
        };
        this._refreshAction.setText("Refresh Registry");
        this._refreshAction.setToolTipText("Refresh Registry");
        this._refreshAction.setImageDescriptor(JSFUICommonPlugin.getDefault().getImageDescriptor("refresh_nav_16.gif"));
    }

    private static class CommonLabelProvider
    extends LabelProvider {
        private CommonLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof TaglibContentProvider.TagRegistryInstance) {
                return ((TaglibContentProvider.TagRegistryInstance)obj).getInfo().getDescription();
            }
            if (obj instanceof Namespace) {
                if (((Namespace)obj).getDisplayName() != null) {
                    return ((Namespace)obj).getDisplayName();
                }
                return ((Namespace)obj).getNSUri();
            }
            if (obj instanceof ITagElement) {
                return ((ITagElement)obj).getName();
            }
            if (obj instanceof TaglibContentProvider.TreePlaceholder) {
                return ((TaglibContentProvider.TreePlaceholder)obj).getText();
            }
            if (obj instanceof IProject) {
                return ((IProject)obj).getName();
            }
            return obj.toString();
        }

        public Image getImage(Object obj) {
            if (obj instanceof Namespace) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            if (obj instanceof ITagElement) {
                if (obj instanceof IComponentTagElement) {
                    return JSFUICommonPlugin.getDefault().getImage("object.gif");
                }
                if (obj instanceof IConverterTagElement) {
                    return JSFUICommonPlugin.getDefault().getImage("jsf_converter.gif");
                }
                if (obj instanceof IValidatorTagElement) {
                    return JSFUICommonPlugin.getDefault().getImage("jsf_validator.gif");
                }
                return JSFUICommonPlugin.getDefault().getImage("PD_Palette_Default.gif");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    private static class ProjectContentProvider
    extends BaseWorkbenchContentProvider {
        private ProjectContentProvider() {
        }

        protected IWorkbenchAdapter getAdapter(Object element) {
            return new WorkbenchAdapter(){

                public Object[] getChildren(Object object) {
                    if (object instanceof ProjectTracker) {
                        return ((ProjectTracker)object).getProjects().toArray();
                    }
                    return new Object[0];
                }
            };
        }
    }
}

