/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.ui.internal;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jst.server.generic.ui.internal.GenericServerUIMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SWTUtil {
    private static FontMetrics fontMetrics;

    protected static void initializeDialogUnits(Control testControl) {
        GC gc = new GC((Drawable)testControl);
        gc.setFont(JFaceResources.getDialogFont());
        fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    protected static int getButtonWidthHint(Button button) {
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static Button createButton(Composite comp, String label) {
        Button b = new Button(comp, 8);
        b.setText(label);
        if (fontMetrics == null) {
            SWTUtil.initializeDialogUnits((Control)comp);
        }
        GridData data = new GridData(258);
        data.widthHint = SWTUtil.getButtonWidthHint(b);
        b.setLayoutData((Object)data);
        return b;
    }

    public static int convertHorizontalDLUsToPixels(Composite comp, int x) {
        if (fontMetrics == null) {
            SWTUtil.initializeDialogUnits((Control)comp);
        }
        return Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)x);
    }

    public static int convertVerticalDLUsToPixels(Composite comp, int y) {
        if (fontMetrics == null) {
            SWTUtil.initializeDialogUnits((Control)comp);
        }
        return Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)y);
    }

    public static Text createLabeledPath(String title, String value, Composite parent) {
        return SWTUtil.createLabeledPath(title, value, parent, null);
    }

    public static Text createLabeledPath(String title, String value, final Composite parent, FormToolkit toolkit) {
        Label label = null;
        Text cText = null;
        Button button = null;
        if (toolkit == null) {
            label = new Label(parent, 64);
            label.setText(title);
            cText = new Text(parent, 2052);
            button = SWTUtil.createButton(parent, GenericServerUIMessages.serverTypeGroup_label_browse);
        } else {
            SWTUtil.createFormLabel(title, parent, toolkit);
            cText = toolkit.createText(parent, value);
            button = toolkit.createButton(parent, GenericServerUIMessages.serverTypeGroup_label_browse, 8);
        }
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        final Text text = cText;
        text.setLayoutData((Object)gridData);
        text.setText(value);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dlg = new DirectoryDialog(parent.getShell());
                dlg.setFilterPath(text.getText().replace('\\', '/'));
                String res = dlg.open();
                if (res != null) {
                    text.setText(res.replace('\\', '/'));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return text;
    }

    public static Text createLabeledFile(String title, String value, Composite parent) {
        return SWTUtil.createLabeledFile(title, value, parent, null);
    }

    public static Text createLabeledFile(String title, String value, final Composite parent, FormToolkit toolkit) {
        Button button;
        Text cText;
        if (toolkit == null) {
            Label label = new Label(parent, 64);
            label.setText(title);
            cText = new Text(parent, 2052);
            button = SWTUtil.createButton(parent, GenericServerUIMessages.serverTypeGroup_label_browse);
        } else {
            SWTUtil.createFormLabel(title, parent, toolkit);
            cText = toolkit.createText(parent, value);
            button = toolkit.createButton(parent, GenericServerUIMessages.serverTypeGroup_label_browse, 8);
        }
        final Text text = cText;
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        text.setLayoutData((Object)gridData);
        text.setText(value);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(parent.getShell());
                dlg.setFileName(text.getText().replace('\\', '/'));
                String res = dlg.open();
                if (res != null) {
                    text.setText(res.replace('\\', '/'));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return text;
    }

    public static Text createLabeledText(String title, String value, Composite parent) {
        return SWTUtil.createLabeledText(title, value, parent, null);
    }

    public static Text createLabeledText(String title, String value, Composite parent, FormToolkit toolkit) {
        Text text;
        if (toolkit == null) {
            Label label = new Label(parent, 64);
            label.setText(title);
            text = new Text(parent, 2052);
        } else {
            SWTUtil.createFormLabel(title, parent, toolkit);
            text = toolkit.createText(parent, value);
        }
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        text.setLayoutData((Object)gridData);
        text.setText(value);
        return text;
    }

    public static Button createLabeledCheck(String title, boolean value, Composite parent) {
        return SWTUtil.createLabeledCheck(title, value, parent, null);
    }

    public static Button createLabeledCheck(String title, boolean value, Composite parent, FormToolkit toolkit) {
        Button button;
        if (toolkit == null) {
            Label label = new Label(parent, 64);
            label.setText(title);
            button = new Button(parent, 32);
        } else {
            SWTUtil.createFormLabel(title, parent, toolkit);
            button = toolkit.createButton(parent, null, 32);
        }
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        button.setLayoutData((Object)gridData);
        button.setSelection(value);
        return button;
    }

    public static Combo createLabeledCombo(String title, String[] values, Composite parent) {
        return SWTUtil.createLabeledCombo(title, values, parent, null);
    }

    public static Combo createLabeledCombo(String title, String[] values, Composite parent, FormToolkit toolkit) {
        if (toolkit == null) {
            Label label = new Label(parent, 64);
            label.setText(title);
        } else {
            SWTUtil.createFormLabel(title, parent, toolkit);
        }
        Combo combo = new Combo(parent, 8);
        if (toolkit != null) {
            toolkit.adapt((Control)combo, true, true);
        }
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        combo.setLayoutData((Object)gridData);
        int i = 0;
        while (i < values.length) {
            combo.add(values[i]);
            ++i;
        }
        if (combo.getItemCount() > 0) {
            combo.select(0);
        }
        return combo;
    }

    public static Combo createLabeledEditableCombo(String title, String[] values, String value, Composite parent) {
        return SWTUtil.createLabeledEditableCombo(title, values, value, parent, null);
    }

    public static Combo createLabeledEditableCombo(String title, String[] values, String value, Composite parent, FormToolkit toolkit) {
        if (toolkit == null) {
            Label label = new Label(parent, 64);
            label.setText(title);
        } else {
            SWTUtil.createFormLabel(title, parent, toolkit);
        }
        Combo combo = new Combo(parent, 2052);
        if (toolkit != null) {
            toolkit.adapt((Control)combo, true, true);
        }
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        combo.setLayoutData((Object)gridData);
        int i = 0;
        while (i < values.length) {
            combo.add(values[i]);
            ++i;
        }
        if (combo.getItemCount() > 0) {
            combo.select(0);
        }
        combo.setText(value);
        return combo;
    }

    private static Label createFormLabel(String title, Composite parent, FormToolkit toolkit) {
        Label label = toolkit.createLabel(parent, title);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        return label;
    }
}

