/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.util.EventListenerRegistry;
import org.eclipse.wst.common.project.facet.core.util.IEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFacetInstallConfig {
    private static final String PROD_PROP_SOURCE_FOLDER = "defaultJavaSourceFolder";
    private static final String PROD_PROP_SOURCE_FOLDER_LEGACY = "defaultSource";
    private static final String DEFAULT_SOURCE_FOLDER = "src";
    private static final String PROD_PROP_OUTPUT_FOLDER = "defaultJavaOutputFolder";
    private static final String PROD_PROP_OUTPUT_FOLDER_LEGACY = "outputFolder";
    private static final String DEFAULT_OUTPUT_FOLDER = "build/classes";
    private EventListenerRegistry<ChangeEvent.Type, ChangeEvent> listeners = new EventListenerRegistry(ChangeEvent.Type.class);
    private List<IPath> sourceFolders = new CopyOnWriteArrayList<IPath>();
    private List<IPath> sourceFoldersReadOnly = Collections.unmodifiableList(this.sourceFolders);
    private IPath defaultOutputFolder = null;

    public JavaFacetInstallConfig() {
        String sourceFolder = JavaFacetInstallConfig.getProductProperty(PROD_PROP_SOURCE_FOLDER);
        if (sourceFolder == null) {
            sourceFolder = JavaFacetInstallConfig.getProductProperty(PROD_PROP_SOURCE_FOLDER_LEGACY);
        }
        if (sourceFolder == null) {
            sourceFolder = DEFAULT_SOURCE_FOLDER;
        }
        this.sourceFolders.add((IPath)new Path(sourceFolder));
        String outputFolder = JavaFacetInstallConfig.getProductProperty(PROD_PROP_OUTPUT_FOLDER);
        if (outputFolder == null) {
            outputFolder = JavaFacetInstallConfig.getProductProperty(PROD_PROP_OUTPUT_FOLDER_LEGACY);
        }
        if (outputFolder == null) {
            outputFolder = DEFAULT_OUTPUT_FOLDER;
        }
        this.defaultOutputFolder = new Path(outputFolder);
    }

    public List<IPath> getSourceFolders() {
        return this.sourceFoldersReadOnly;
    }

    public void setSourceFolders(List<IPath> paths) {
        if (!this.sourceFolders.equals(paths)) {
            this.sourceFolders.clear();
            this.sourceFolders.addAll(paths);
            ChangeEvent event = new ChangeEvent(ChangeEvent.Type.SOURCE_FOLDERS_CHANGED, this);
            this.listeners.notifyListeners((Enum)ChangeEvent.Type.SOURCE_FOLDERS_CHANGED, (Object)event);
        }
    }

    public void setSourceFolder(IPath path) {
        List<Object> newSourceFolders = path == null ? Collections.emptyList() : Collections.singletonList(path);
        this.setSourceFolders(newSourceFolders);
    }

    public void addSourceFolder(IPath path) {
        ArrayList<IPath> newSourceFolders = new ArrayList<IPath>(this.getSourceFolders());
        newSourceFolders.add(path);
        this.setSourceFolders(newSourceFolders);
    }

    public void removeSourceFolder(IPath path) {
        ArrayList<IPath> newSourceFolders = new ArrayList<IPath>(this.getSourceFolders());
        newSourceFolders.remove(path);
        this.setSourceFolders(newSourceFolders);
    }

    public IPath getDefaultOutputFolder() {
        return this.defaultOutputFolder;
    }

    public void setDefaultOutputFolder(IPath defaultOutputFolder) {
        if (!JavaFacetInstallConfig.equal(this.defaultOutputFolder, defaultOutputFolder)) {
            this.defaultOutputFolder = defaultOutputFolder;
            ChangeEvent event = new ChangeEvent(ChangeEvent.Type.DEFAULT_OUTPUT_FOLDER_CHANGED, this);
            this.listeners.notifyListeners((Enum)ChangeEvent.Type.DEFAULT_OUTPUT_FOLDER_CHANGED, (Object)event);
        }
    }

    public void addListener(IEventListener<ChangeEvent> listener, ChangeEvent.Type ... types) {
        this.listeners.addListener(listener, (Enum[])types);
    }

    public void removeListener(IEventListener<ChangeEvent> listener) {
        this.listeners.removeListener(listener);
    }

    private static boolean equal(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    private static String getProductProperty(String propName) {
        String value = null;
        if (Platform.getProduct() != null) {
            value = Platform.getProduct().getProperty(propName);
        }
        return value;
    }

    public static class ChangeEvent {
        private final Type type;
        private final JavaFacetInstallConfig installConfig;

        ChangeEvent(Type type, JavaFacetInstallConfig installConfig) {
            this.type = type;
            this.installConfig = installConfig;
        }

        public final Type getType() {
            return this.type;
        }

        public final JavaFacetInstallConfig getJavaFacetInstallConfig() {
            return this.installConfig;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            SOURCE_FOLDERS_CHANGED,
            DEFAULT_OUTPUT_FOLDER_CHANGED;

        }
    }
}

