/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.commands;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.internal.generator.BindingGenerator;
import org.eclipse.wst.wsdl.internal.generator.ContentGenerator;
import org.eclipse.wst.wsdl.internal.generator.PortGenerator;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11TopLevelElementCommand;
import org.eclipse.wst.wsdl.ui.internal.asd.Messages;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.IASDAddCommand;
import org.eclipse.wst.wsdl.ui.internal.asd.contentgenerator.ui.extension.ContentGeneratorUIExtension;
import org.eclipse.wst.wsdl.ui.internal.asd.contentgenerator.ui.extension.ContentGeneratorUIExtensionRegistry;
import org.eclipse.wst.wsdl.ui.internal.commands.AddServiceCommand;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;
import org.eclipse.wst.wsdl.ui.internal.util.ServicePolicyHelper;

public class W11AddServiceCommand
extends W11TopLevelElementCommand
implements IASDAddCommand {
    private Service service;

    public W11AddServiceCommand(Definition definition) {
        super(Messages._UI_ACTION_ADD_SERVICE, definition);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        try {
            List protocols;
            ContentGeneratorUIExtensionRegistry registry;
            ContentGeneratorUIExtension ext;
            this.beginRecording(this.definition.getElement());
            super.execute();
            String newName = NameUtil.buildUniqueServiceName(this.definition);
            AddServiceCommand command = new AddServiceCommand(this.definition, newName, false);
            command.run();
            this.service = (Service)command.getWSDLElement();
            PortGenerator portGenerator = new PortGenerator(this.service);
            ContentGenerator contentGenerator = null;
            IProject project = this.getProject(this.definition);
            String protocol = ServicePolicyHelper.getDefaultBinding(project);
            if (protocol != null && (ext = (registry = WSDLEditorPlugin.getInstance().getContentGeneratorUIExtensionRegistry()).getExtensionForNamespace(protocol)) != null) {
                contentGenerator = BindingGenerator.getContentGenerator((String)ext.getNamespace());
            }
            if (contentGenerator == null && (protocols = WSDLEditorPlugin.getInstance().getContentGeneratorUIExtensionRegistry().getBindingExtensionNames()).size() >= 1) {
                protocol = (String)protocols.get(0);
                ext = WSDLEditorPlugin.getInstance().getContentGeneratorUIExtensionRegistry().getExtensionForName(protocol);
                if (ext != null) {
                    contentGenerator = BindingGenerator.getContentGenerator((String)ext.getNamespace());
                }
            }
            portGenerator.setContentGenerator(contentGenerator);
            portGenerator.setName(NameUtil.buildUniquePortName(this.service, "NewPort"));
            portGenerator.generatePort();
            this.formatChild(this.service.getElement());
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.endRecording(this.definition.getElement());
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        this.endRecording(this.definition.getElement());
    }

    public Object getNewlyAddedComponent() {
        return this.service;
    }

    private IProject getProject(Definition definition) {
        IProject project = null;
        String location = definition.getLocation();
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        if (url != null) {
            URL fileURL = null;
            try {
                fileURL = FileLocator.toFileURL((URL)url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (fileURL != null) {
                Path path = new Path(fileURL.getPath());
                IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path);
                IFile file = null;
                if (files.length > 0) {
                    file = files[0];
                }
                project = file.getProject();
            }
        }
        return project;
    }
}

