/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.editparts;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wst.wsdl.ui.internal.asd.design.DesignViewGraphicsConstants;
import org.eclipse.wst.wsdl.ui.internal.asd.design.directedit.LabelCellEditorLocator;
import org.eclipse.wst.wsdl.ui.internal.asd.design.directedit.LabelEditManager;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.BaseEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.INamedEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDLabelDirectEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDSelectionEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.figures.ListFigure;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IOperation;
import org.eclipse.wst.wsdl.ui.internal.asd.outline.ITreeElement;

public class OperationEditPart
extends BaseEditPart
implements INamedEditPart {
    protected Figure contentPane;
    protected Label label;
    private Color unselectedColor;
    private Figure labelHolder;
    private DirectEditManager manager;

    protected IFigure createFigure() {
        Figure figure = new Figure();
        figure.setBackgroundColor(DesignViewGraphicsConstants.tableOperationHeadingColor);
        ToolbarLayout toolbarLayout = new ToolbarLayout(false);
        toolbarLayout.setStretchMinorAxis(true);
        toolbarLayout.setMinorAlignment(1);
        figure.setLayoutManager((LayoutManager)toolbarLayout);
        this.labelHolder = new Panel();
        this.labelHolder.setBackgroundColor(DesignViewGraphicsConstants.tableOperationHeadingColor);
        this.labelHolder.setLayoutManager((LayoutManager)new ToolbarLayout(true));
        figure.add((IFigure)this.labelHolder);
        this.label = new Label("Operation");
        this.label.setBorder((Border)new MarginBorder(2, 2, 2, 2));
        this.label.setTextAlignment(1);
        this.labelHolder.add((IFigure)this.label);
        this.contentPane = new ListFigure();
        ToolbarLayout toolbarLayout2 = new ToolbarLayout(false);
        toolbarLayout2.setStretchMinorAxis(true);
        this.contentPane.setLayoutManager((LayoutManager)toolbarLayout2);
        figure.add((IFigure)this.contentPane);
        if (this.isReadOnly()) {
            this.label.setForegroundColor(DesignViewGraphicsConstants.readOnlyLabelColor);
            figure.setBackgroundColor(DesignViewGraphicsConstants.readOnlyTableOperationHeadingColor);
            this.labelHolder.setBackgroundColor(DesignViewGraphicsConstants.readOnlyTableOperationHeadingColor);
        } else {
            this.label.setForegroundColor(ColorConstants.black);
            figure.setBackgroundColor(DesignViewGraphicsConstants.tableOperationHeadingColor);
            this.labelHolder.setBackgroundColor(DesignViewGraphicsConstants.tableOperationHeadingColor);
        }
        return figure;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ASDLabelDirectEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ASDSelectionEditPolicy());
    }

    public void performDirectEdit(Point cursorLocation) {
        Rectangle textArea = this.getLabelFigure().getBounds();
        textArea.width = this.getFigure().getBounds().width;
        if (!this.isFileReadOnly() && (cursorLocation == null || this.hitTest(textArea, cursorLocation) && !this.isReadOnly())) {
            this.manager = new LabelEditManager((GraphicalEditPart)this, new LabelCellEditorLocator(this, cursorLocation));
            this.manager.show();
        } else if (this.getFigure() instanceof Figure && this.hitTestFigure((Figure)this.getFigure(), cursorLocation) && this.isReadOnly()) {
            this.doOpenNewEditor();
        }
    }

    public void performRequest(Request req) {
        if (req.getType().equals("direct edit")) {
            this.performDirectEdit(null);
        }
    }

    public Label getLabelFigure() {
        return this.label;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        IOperation operation = (IOperation)this.getModel();
        this.label.setText(operation.getName());
        if (operation instanceof ITreeElement) {
            this.label.setIcon(((ITreeElement)((Object)operation)).getImage());
        }
    }

    public IFigure getContentPane() {
        return this.contentPane;
    }

    protected List getModelChildren() {
        IOperation theOperation = (IOperation)this.getModel();
        return theOperation.getMessages();
    }

    public void addFeedback() {
        this.unselectedColor = this.labelHolder.getBackgroundColor();
        this.labelHolder.setBackgroundColor(DesignViewGraphicsConstants.tableCellSelectionColor);
    }

    public void removeFeedback() {
        if (this.unselectedColor != null) {
            this.labelHolder.setBackgroundColor(this.unselectedColor);
        }
    }
}

