/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.properties.sections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.wsdl.ui.internal.asd.design.DesignViewGraphicsConstants;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IASDObject;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IASDObjectListener;

public class ASDAbstractSection
implements ISection,
IASDObjectListener,
Listener,
SelectionListener {
    private TabbedPropertySheetWidgetFactory factory;
    private Object elementModel;
    protected boolean isReadOnly = false;
    protected Composite composite;
    protected int rightMarginSpace;
    protected int tableMinimumWidth = 50;
    protected CustomListener customListener = new CustomListener();
    protected List listeners = new ArrayList();
    boolean listenerEnabled = true;
    protected DelayedEvent delayedTask;
    protected boolean isInDoHandle;
    static /* synthetic */ Class class$0;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createControls(parent, tabbedPropertySheetPage.getWidgetFactory());
    }

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory aFactory) {
        this.factory = aFactory;
        GC gc = new GC((Drawable)parent);
        Point extent = gc.textExtent("  ...  ");
        this.rightMarginSpace = extent.x;
        gc.dispose();
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        IEditorInput editorInput;
        Object input;
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        this.elementModel = input = ((IStructuredSelection)selection).getFirstElement();
        this.attachListener(this.elementModel);
        if (input instanceof IASDObject) {
            this.isReadOnly = ((IASDObject)input).isReadOnly();
        }
        IEditorPart owningEditor = null;
        if (part != null) {
            if (part instanceof IEditorPart) {
                owningEditor = (IEditorPart)part;
            } else {
                IWorkbenchPage page;
                IWorkbenchWindow window;
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
                    owningEditor = page.getActiveEditor();
                }
            }
        }
        if (owningEditor != null && !((editorInput = owningEditor.getEditorInput()) instanceof IFileEditorInput) && !(editorInput instanceof FileStoreEditorInput)) {
            this.isReadOnly = true;
        }
        this.refresh();
    }

    public void aboutToBeShown() {
        this.refresh();
    }

    public void aboutToBeHidden() {
    }

    public void dispose() {
        this.unattachAllListeners();
    }

    public int getMinimumHeight() {
        return -1;
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void refresh() {
        if (!this.composite.isDisposed()) {
            if (this.isReadOnly) {
                this.composite.setEnabled(false);
            } else {
                this.composite.setEnabled(true);
            }
        }
    }

    public TabbedPropertySheetWidgetFactory getWidgetFactory() {
        return this.factory;
    }

    public void propertyChanged(Object object, String property) {
        this.refresh();
    }

    public void doWidgetDefaultSelected(SelectionEvent e) {
    }

    public void doWidgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (this.isListenerEnabled() && !this.isInDoHandle) {
            this.isInDoHandle = true;
            this.doWidgetDefaultSelected(e);
            this.isInDoHandle = false;
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.isListenerEnabled() && !this.isInDoHandle) {
            this.isInDoHandle = true;
            this.doWidgetSelected(e);
            this.isInDoHandle = false;
        }
    }

    public boolean isListenerEnabled() {
        return this.listenerEnabled;
    }

    public void applyTextListeners(Control control) {
        control.addListener(16, (Listener)this.customListener);
        control.addListener(1, (Listener)this.customListener);
    }

    public void removeListeners(Control control) {
        control.removeListener(16, (Listener)this.customListener);
        control.removeListener(1, (Listener)this.customListener);
    }

    public void setListenerEnabled(boolean v) {
        this.listenerEnabled = v;
    }

    public void handleEvent(Event event) {
        if (this.isListenerEnabled() && !this.isInDoHandle) {
            this.isInDoHandle = true;
            this.doHandleEvent(event);
            this.isInDoHandle = false;
        }
    }

    public void doHandleEvent(Event event) {
    }

    protected void startDelayedEvent(Event e) {
        if (this.delayedTask == null || this.delayedTask.getEvent() == null) {
            this.delayedTask = new DelayedEvent();
            this.delayedTask.setEvent(e);
            Display.getDefault().timerExec(500, (Runnable)this.delayedTask);
        } else {
            Event delayedEvent = this.delayedTask.getEvent();
            if (e.widget == delayedEvent.widget && e.type == delayedEvent.type) {
                this.delayedTask.setEvent(null);
            }
            this.delayedTask = new DelayedEvent();
            this.delayedTask.setEvent(e);
            Display.getDefault().timerExec(500, (Runnable)this.delayedTask);
        }
    }

    public boolean isInDoHandle() {
        return this.isInDoHandle;
    }

    protected static IStatusLineManager getStatusLineManager(IEditorPart editorPart) {
        IStatusLineManager result = null;
        try {
            EditorActionBarContributor contributor = (EditorActionBarContributor)editorPart.getEditorSite().getActionBarContributor();
            result = contributor.getActionBars().getStatusLineManager();
        }
        catch (Exception exception) {}
        return result;
    }

    public Object getModel() {
        return this.elementModel;
    }

    protected void attachListener(Object object) {
        if (object instanceof IASDObject && !this.listeners.contains(object)) {
            ((IASDObject)object).registerListener(this);
            this.listeners.add(object);
        }
    }

    protected void unattachAllListeners() {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            ((IASDObject)item).unregisterListener(this);
        }
    }

    protected void setControlForegroundColor(Control control) {
        if (control != null) {
            if (this.isReadOnly) {
                control.setForeground(DesignViewGraphicsConstants.readOnlyLabelColor);
            } else {
                control.setForeground(DesignViewGraphicsConstants.labelColor);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeCommand(Command command) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page.getActiveEditor() != null) {
            IEditorPart iEditorPart = page.getActiveEditor();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gef.commands.CommandStack");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (iEditorPart.getAdapter((Class)clazz) != null) {
                IEditorPart iEditorPart2 = page.getActiveEditor();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.gef.commands.CommandStack");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                CommandStack stack = (CommandStack)iEditorPart2.getAdapter((Class)clazz2);
                stack.execute(command);
                return;
            }
        }
        command.execute();
    }

    class CustomListener
    implements Listener {
        boolean isHandlingEvent = false;

        CustomListener() {
        }

        public void handleEvent(Event event) {
            if (ASDAbstractSection.this.isListenerEnabled() && !ASDAbstractSection.this.isReadOnly) {
                switch (event.type) {
                    case 1: {
                        if (event.character != '\r' || this.isHandlingEvent) break;
                        this.isHandlingEvent = true;
                        ASDAbstractSection.this.doHandleEvent(event);
                        this.isHandlingEvent = false;
                        break;
                    }
                    case 16: {
                        if (this.isHandlingEvent) break;
                        this.isHandlingEvent = true;
                        ASDAbstractSection.this.doHandleEvent(event);
                        this.isHandlingEvent = false;
                    }
                }
            }
        }
    }

    class DelayedEvent
    implements Runnable {
        protected Event event;

        DelayedEvent() {
        }

        public void run() {
            if (this.event != null) {
                ASDAbstractSection.this.isInDoHandle = true;
                ASDAbstractSection.this.doHandleEvent(this.event);
                ASDAbstractSection.this.isInDoHandle = false;
                this.event = null;
            }
        }

        public Event getEvent() {
            return this.event;
        }

        public void setEvent(Event event) {
            this.event = event;
        }
    }
}

