/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.util.CompilationUnitSorter;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.MembersOrderPreferenceCache;

public class SortMembersOperation
implements IWorkspaceRunnable {
    private ICompilationUnit fCompilationUnit;
    private int[] fPositions;
    private final boolean fDoNotSortFields;

    public SortMembersOperation(ICompilationUnit cu, int[] positions, boolean doNotSortFields) {
        this.fCompilationUnit = cu;
        this.fPositions = positions;
        this.fDoNotSortFields = doNotSortFields;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        CompilationUnitSorter.sort((int)3, (ICompilationUnit)this.fCompilationUnit, (int[])this.fPositions, (Comparator)new DefaultJavaElementComparator(this.fDoNotSortFields), (int)0, (IProgressMonitor)monitor);
    }

    public ISchedulingRule getScheduleRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static class DefaultJavaElementComparator
    implements Comparator {
        private final Collator fCollator;
        private final MembersOrderPreferenceCache fMemberOrderCache;
        private final boolean fDoNotSortFields;

        public DefaultJavaElementComparator(boolean doNotSortFields) {
            this.fDoNotSortFields = doNotSortFields;
            this.fCollator = Collator.getInstance();
            this.fMemberOrderCache = JavaPlugin.getDefault().getMemberOrderPreferenceCache();
        }

        private int category(BodyDeclaration bodyDeclaration) {
            switch (bodyDeclaration.getNodeType()) {
                case 31: {
                    MethodDeclaration method = (MethodDeclaration)bodyDeclaration;
                    if (method.isConstructor()) {
                        return this.getMemberCategory(1);
                    }
                    int flags = method.getModifiers();
                    if (Modifier.isStatic((int)flags)) {
                        return this.getMemberCategory(7);
                    }
                    return this.getMemberCategory(2);
                }
                case 23: {
                    int flags = ((FieldDeclaration)bodyDeclaration).getModifiers();
                    if (Modifier.isStatic((int)flags)) {
                        return this.getMemberCategory(5);
                    }
                    return this.getMemberCategory(3);
                }
                case 28: {
                    int flags = ((Initializer)bodyDeclaration).getModifiers();
                    if (Modifier.isStatic((int)flags)) {
                        return this.getMemberCategory(6);
                    }
                    return this.getMemberCategory(4);
                }
                case 55: 
                case 71: 
                case 81: {
                    return this.getMemberCategory(0);
                }
                case 72: {
                    return this.getMemberCategory(8);
                }
                case 82: {
                    return this.getMemberCategory(2);
                }
            }
            return 0;
        }

        private int getMemberCategory(int kind) {
            return this.fMemberOrderCache.getCategoryIndex(kind);
        }

        public int compare(Object e1, Object e2) {
            int vis;
            int cat2;
            BodyDeclaration bodyDeclaration1 = (BodyDeclaration)e1;
            BodyDeclaration bodyDeclaration2 = (BodyDeclaration)e2;
            int cat1 = this.category(bodyDeclaration1);
            if (cat1 != (cat2 = this.category(bodyDeclaration2))) {
                return cat1 - cat2;
            }
            if (this.fMemberOrderCache.isSortByVisibility()) {
                int flags1 = JdtFlags.getVisibilityCode(bodyDeclaration1);
                int flags2 = JdtFlags.getVisibilityCode(bodyDeclaration2);
                vis = this.fMemberOrderCache.getVisibilityIndex(flags1) - this.fMemberOrderCache.getVisibilityIndex(flags2);
                if (vis != 0) {
                    return vis;
                }
            }
            switch (bodyDeclaration1.getNodeType()) {
                case 31: {
                    String name2;
                    MethodDeclaration method1 = (MethodDeclaration)bodyDeclaration1;
                    MethodDeclaration method2 = (MethodDeclaration)bodyDeclaration2;
                    if (this.fMemberOrderCache.isSortByVisibility() && (vis = this.fMemberOrderCache.getVisibilityIndex(method1.getModifiers()) - this.fMemberOrderCache.getVisibilityIndex(method2.getModifiers())) != 0) {
                        return vis;
                    }
                    String name1 = method1.getName().getIdentifier();
                    int cmp = this.fCollator.compare(name1, name2 = method2.getName().getIdentifier());
                    if (cmp != 0) {
                        return cmp;
                    }
                    List parameters1 = method1.parameters();
                    List parameters2 = method2.parameters();
                    int length1 = parameters1.size();
                    int length2 = parameters2.size();
                    int len = Math.min(length1, length2);
                    int i = 0;
                    while (i < len) {
                        SingleVariableDeclaration param1 = (SingleVariableDeclaration)parameters1.get(i);
                        SingleVariableDeclaration param2 = (SingleVariableDeclaration)parameters2.get(i);
                        cmp = this.fCollator.compare(this.buildSignature(param1.getType()), this.buildSignature(param2.getType()));
                        if (cmp != 0) {
                            return cmp;
                        }
                        ++i;
                    }
                    if (length1 != length2) {
                        return length1 - length2;
                    }
                    return this.preserveRelativeOrder(bodyDeclaration1, bodyDeclaration2);
                }
                case 23: {
                    if (!this.fDoNotSortFields) {
                        FieldDeclaration field1 = (FieldDeclaration)bodyDeclaration1;
                        FieldDeclaration field2 = (FieldDeclaration)bodyDeclaration2;
                        String name1 = ((VariableDeclarationFragment)field1.fragments().get(0)).getName().getIdentifier();
                        String name2 = ((VariableDeclarationFragment)field2.fragments().get(0)).getName().getIdentifier();
                        return this.compareNames(bodyDeclaration1, bodyDeclaration2, name1, name2);
                    }
                    return this.preserveRelativeOrder(bodyDeclaration1, bodyDeclaration2);
                }
                case 28: {
                    return this.preserveRelativeOrder(bodyDeclaration1, bodyDeclaration2);
                }
                case 55: 
                case 71: 
                case 81: {
                    AbstractTypeDeclaration type1 = (AbstractTypeDeclaration)bodyDeclaration1;
                    AbstractTypeDeclaration type2 = (AbstractTypeDeclaration)bodyDeclaration2;
                    String name1 = type1.getName().getIdentifier();
                    String name2 = type2.getName().getIdentifier();
                    return this.compareNames(bodyDeclaration1, bodyDeclaration2, name1, name2);
                }
                case 72: {
                    if (!this.fDoNotSortFields) {
                        EnumConstantDeclaration decl1 = (EnumConstantDeclaration)bodyDeclaration1;
                        EnumConstantDeclaration decl2 = (EnumConstantDeclaration)bodyDeclaration2;
                        String name1 = decl1.getName().getIdentifier();
                        String name2 = decl2.getName().getIdentifier();
                        return this.compareNames(bodyDeclaration1, bodyDeclaration2, name1, name2);
                    }
                    return this.preserveRelativeOrder(bodyDeclaration1, bodyDeclaration2);
                }
                case 82: {
                    AnnotationTypeMemberDeclaration decl1 = (AnnotationTypeMemberDeclaration)bodyDeclaration1;
                    AnnotationTypeMemberDeclaration decl2 = (AnnotationTypeMemberDeclaration)bodyDeclaration2;
                    String name1 = decl1.getName().getIdentifier();
                    String name2 = decl2.getName().getIdentifier();
                    return this.compareNames(bodyDeclaration1, bodyDeclaration2, name1, name2);
                }
            }
            return 0;
        }

        private int preserveRelativeOrder(BodyDeclaration bodyDeclaration1, BodyDeclaration bodyDeclaration2) {
            int value1 = (Integer)bodyDeclaration1.getProperty("relativeOrder");
            int value2 = (Integer)bodyDeclaration2.getProperty("relativeOrder");
            return value1 - value2;
        }

        private int compareNames(BodyDeclaration bodyDeclaration1, BodyDeclaration bodyDeclaration2, String name1, String name2) {
            int cmp = this.fCollator.compare(name1, name2);
            if (cmp != 0) {
                return cmp;
            }
            return this.preserveRelativeOrder(bodyDeclaration1, bodyDeclaration2);
        }

        private String buildSignature(Type type) {
            return ASTNodes.asString((ASTNode)type);
        }
    }
}

