/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;

public class CodeScopeBuilder
extends ASTVisitor {
    private IBinding fIgnoreBinding;
    private Selection fIgnoreRange;
    private Scope fScope;
    private List fScopes;

    public static Scope perform(BodyDeclaration node, IBinding ignore) {
        CodeScopeBuilder collector = new CodeScopeBuilder((ASTNode)node, ignore);
        node.accept((ASTVisitor)collector);
        return collector.fScope;
    }

    public static Scope perform(BodyDeclaration node, Selection ignore) {
        CodeScopeBuilder collector = new CodeScopeBuilder((ASTNode)node, ignore);
        node.accept((ASTVisitor)collector);
        return collector.fScope;
    }

    private CodeScopeBuilder(ASTNode node, IBinding ignore) {
        this.fScope = new Scope(null, node.getStartPosition(), node.getLength());
        this.fScopes = new ArrayList();
        this.fIgnoreBinding = ignore;
    }

    private CodeScopeBuilder(ASTNode node, Selection ignore) {
        this.fScope = new Scope(null, node.getStartPosition(), node.getLength());
        this.fScopes = new ArrayList();
        this.fIgnoreRange = ignore;
    }

    public boolean visit(CatchClause node) {
        this.fScopes.add(this.fScope);
        this.fScope = new Scope(this.fScope, node.getStartPosition(), node.getLength());
        return true;
    }

    public void endVisit(CatchClause node) {
        this.fScope = (Scope)this.fScopes.remove(this.fScopes.size() - 1);
    }

    public boolean visit(SimpleName node) {
        if (this.fIgnoreBinding != null && Bindings.equals(this.fIgnoreBinding, node.resolveBinding())) {
            return false;
        }
        if (this.fIgnoreRange != null && this.fIgnoreRange.covers((ASTNode)node)) {
            return false;
        }
        this.fScope.addName(node.getIdentifier());
        return false;
    }

    public boolean visit(QualifiedName node) {
        node.getQualifier().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(MethodInvocation node) {
        Expression receiver = node.getExpression();
        if (receiver == null) {
            SimpleName name = node.getName();
            if (this.fIgnoreBinding == null || name != null && !Bindings.equals(this.fIgnoreBinding, name.resolveBinding())) {
                node.getName().accept((ASTVisitor)this);
            }
        } else {
            receiver.accept((ASTVisitor)this);
        }
        this.accept(node.arguments());
        return false;
    }

    public boolean visit(TypeDeclarationStatement node) {
        if (node.getAST().apiLevel() == 2) {
            this.fScope.addName(node.getTypeDeclaration().getName().getIdentifier());
        } else {
            this.fScope.addName(node.getDeclaration().getName().getIdentifier());
        }
        return false;
    }

    public boolean visit(Block node) {
        this.fScopes.add(this.fScope);
        this.fScope = new Scope(this.fScope, node.getStartPosition(), node.getLength());
        return true;
    }

    public void endVisit(Block node) {
        this.fScope = (Scope)this.fScopes.remove(this.fScopes.size() - 1);
    }

    public boolean visit(ForStatement node) {
        this.fScopes.add(this.fScope);
        this.fScope = new Scope(this.fScope, node.getStartPosition(), node.getLength());
        return true;
    }

    public void endVisit(ForStatement node) {
        this.fScope = (Scope)this.fScopes.remove(this.fScopes.size() - 1);
    }

    private void accept(List list) {
        int size;
        if (list == null || (size = list.size()) == 0) {
            return;
        }
        int i = 0;
        while (i < size) {
            ((ASTNode)list.get(i)).accept((ASTVisitor)this);
            ++i;
        }
    }

    public boolean visit(ForInStatement node) {
        this.fScopes.add(this.fScope);
        this.fScope = new Scope(this.fScope, node.getStartPosition(), node.getLength());
        return true;
    }

    public void endVisit(ForInStatement node) {
        this.fScope = (Scope)this.fScopes.remove(this.fScopes.size() - 1);
    }

    public static class Scope {
        private Scope fParent;
        private int fStart;
        private int fLength;
        private List fNames;
        private List fChildren;
        private int fCursorOffset;

        Scope(Scope parent, int start, int length) {
            this.fParent = parent;
            this.fStart = start;
            this.fLength = length;
            if (this.fParent != null) {
                this.fParent.addChild(this);
            }
        }

        public void setCursor(int offset) {
            this.fCursorOffset = offset;
        }

        private void addChild(Scope child) {
            if (this.fChildren == null) {
                this.fChildren = new ArrayList(2);
            }
            this.fChildren.add(child);
        }

        private void addName(String name) {
            if (this.fNames == null) {
                this.fNames = new ArrayList(2);
            }
            this.fNames.add(name);
        }

        public Scope findScope(int start, int length) {
            if (this.fStart <= start && start + length <= this.fStart + this.fLength) {
                if (this.fChildren == null) {
                    return this;
                }
                Iterator iter = this.fChildren.iterator();
                while (iter.hasNext()) {
                    Scope scope = ((Scope)iter.next()).findScope(start, length);
                    if (scope == null) continue;
                    return scope;
                }
                return this;
            }
            return null;
        }

        public String createName(String candidate, boolean add) {
            int i = 1;
            String result = candidate;
            while (this.isInUse(result)) {
                result = String.valueOf(candidate) + i++;
            }
            if (add) {
                this.addName(result);
            }
            return result;
        }

        public boolean isInUse(String name) {
            if (this.internalIsInUse(name)) {
                return true;
            }
            if (this.fChildren != null) {
                Iterator iter = this.fChildren.iterator();
                while (iter.hasNext()) {
                    Scope child = (Scope)iter.next();
                    if (this.fCursorOffset >= child.fStart || !child.isInUseDown(name)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean internalIsInUse(String name) {
            if (this.fNames != null && this.fNames.contains(name)) {
                return true;
            }
            if (this.fParent != null) {
                return this.fParent.internalIsInUse(name);
            }
            return false;
        }

        private boolean isInUseDown(String name) {
            if (this.fNames != null && this.fNames.contains(name)) {
                return true;
            }
            if (this.fChildren == null) {
                return false;
            }
            Iterator iter = this.fChildren.iterator();
            while (iter.hasNext()) {
                Scope scope = (Scope)iter.next();
                if (!scope.isInUseDown(name)) continue;
                return true;
            }
            return false;
        }
    }
}

