/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import java.util.List;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;

public class ModifierRewrite {
    public static final int VISIBILITY_MODIFIERS = 7;
    private ListRewrite fModifierRewrite;

    public static ModifierRewrite create(ASTRewrite rewrite, ASTNode declNode) {
        return new ModifierRewrite(rewrite, declNode);
    }

    private ModifierRewrite(ASTRewrite rewrite, ASTNode declNode) {
        this.fModifierRewrite = this.evaluateListRewrite(rewrite, declNode);
    }

    private ListRewrite evaluateListRewrite(ASTRewrite rewrite, ASTNode declNode) {
        switch (declNode.getNodeType()) {
            case 31: {
                return rewrite.getListRewrite(declNode, MethodDeclaration.MODIFIERS2_PROPERTY);
            }
            case 23: {
                return rewrite.getListRewrite(declNode, FieldDeclaration.MODIFIERS2_PROPERTY);
            }
            case 58: {
                return rewrite.getListRewrite(declNode, VariableDeclarationExpression.MODIFIERS2_PROPERTY);
            }
            case 60: {
                return rewrite.getListRewrite(declNode, VariableDeclarationStatement.MODIFIERS2_PROPERTY);
            }
            case 44: {
                return rewrite.getListRewrite(declNode, SingleVariableDeclaration.MODIFIERS2_PROPERTY);
            }
            case 55: {
                return rewrite.getListRewrite(declNode, TypeDeclaration.MODIFIERS2_PROPERTY);
            }
            case 71: {
                return rewrite.getListRewrite(declNode, EnumDeclaration.MODIFIERS2_PROPERTY);
            }
            case 81: {
                return rewrite.getListRewrite(declNode, AnnotationTypeDeclaration.MODIFIERS2_PROPERTY);
            }
            case 72: {
                return rewrite.getListRewrite(declNode, EnumConstantDeclaration.MODIFIERS2_PROPERTY);
            }
            case 82: {
                return rewrite.getListRewrite(declNode, AnnotationTypeMemberDeclaration.MODIFIERS2_PROPERTY);
            }
        }
        throw new IllegalArgumentException("node has no modifiers: " + declNode.getClass().getName());
    }

    public ListRewrite getModifierRewrite() {
        return this.fModifierRewrite;
    }

    public void setModifiers(int modfiers, TextEditGroup editGroup) {
        this.internalSetModifiers(modfiers, -1, editGroup);
    }

    public void setModifiers(int included, int excluded, TextEditGroup editGroup) {
        this.internalSetModifiers(included, included | excluded, editGroup);
    }

    public void setVisibility(int visibilityFlags, TextEditGroup editGroup) {
        this.internalSetModifiers(visibilityFlags, 7, editGroup);
    }

    public void copyAllModifiers(ASTNode otherDecl, TextEditGroup editGroup) {
        ListRewrite modifierList = this.evaluateListRewrite(this.fModifierRewrite.getASTRewrite(), otherDecl);
        List originalList = modifierList.getOriginalList();
        if (originalList.isEmpty()) {
            return;
        }
        ASTNode copy = modifierList.createCopyTarget((ASTNode)originalList.get(0), (ASTNode)originalList.get(originalList.size() - 1));
        if (copy != null) {
            this.fModifierRewrite.insertLast(copy, editGroup);
        }
    }

    private void internalSetModifiers(int modfiers, int consideredFlags, TextEditGroup editGroup) {
    }
}

