/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.UndoEdit;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.CleanUpPreferenceUtil;
import org.eclipse.wst.jsdt.internal.corext.fix.CleanUpRefactoring;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.fix.ICleanUp;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.saveparticipant.IPostSaveListener;

public class CleanUpPostSaveListener
implements IPostSaveListener {
    public static final String POSTSAVELISTENER_ID = "org.eclipse.wst.jsdt.ui.postsavelistener.cleanup";
    private static final String WARNING_VALUE = "warning";
    private static final String ERROR_VALUE = "error";

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saved(ICompilationUnit unit, IProgressMonitor monitor) throws CoreException {
        block28: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(this.getName(), -1);
            try {
                block27: {
                    if (!ActionUtil.isOnBuildPath((IJavaElement)unit)) {
                    } else {
                        project = unit.getJavaProject().getProject();
                        settings = CleanUpPreferenceUtil.loadSaveParticipantOptions((IScopeContext)new ProjectScope(project));
                        if (settings == null) {
                            contextNode = new InstanceScope().getNode("org.eclipse.wst.jsdt.ui");
                            id = contextNode.get("cleanup.on_save_profile_id", null);
                            if (id != null) throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", Messages.format(FixMessages.CleanUpPostSaveListener_unknown_profile_error_message, id)));
                            id = new DefaultScope().getNode("org.eclipse.wst.jsdt.ui").get("cleanup.on_save_profile_id", "org.eclipse.wst.jsdt.ui.default.save_participant_clean_up_profile");
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", Messages.format(FixMessages.CleanUpPostSaveListener_unknown_profile_error_message, id)));
                        }
                        if ("true".equals(settings.get("cleanup.on_save_use_additional_actions"))) {
                            cleanUps = CleanUpRefactoring.createCleanUps(settings);
                        } else {
                            filteredSettins = new HashMap<String, V>();
                            filteredSettins.put("cleanup.format_source_code", settings.get("cleanup.format_source_code"));
                            filteredSettins.put("cleanup.organize_imports", settings.get("cleanup.organize_imports"));
                            cleanUps = CleanUpRefactoring.createCleanUps(filteredSettins);
                        }
                        oldFileValue = unit.getResource().getModificationStamp();
                        oldDocValue = this.getDocumentStamp((IFile)unit.getResource(), (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                        result = new CompositeChange(FixMessages.CleanUpPostSaveListener_SaveAction_ChangeName);
                        undoEdits = new LinkedList<UndoEdit>();
                        manager = RefactoringCore.getUndoManager();
                        try {
                            manager.aboutToPerformChange((Change)result);
                            do {
                                block26: {
                                    preCondition = new RefactoringStatus();
                                    i = 0;
                                    while (true) {
                                        if (i >= cleanUps.length) {
                                            if (this.showStatus(preCondition) != 0) {
                                                break;
                                            }
                                            break block26;
                                        }
                                        conditions = cleanUps[i].checkPreConditions(unit.getJavaProject(), new ICompilationUnit[]{unit}, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                                        preCondition.merge(conditions);
                                        ++i;
                                    }
lbl45:
                                    // 2 sources

                                    while (true) {
                                        var21_28 = null;
                                        break block27;
                                        break;
                                    }
                                }
                                options = new HashMap<K, V>();
                                i = 0;
                                while (true) {
                                    if (i >= cleanUps.length) {
                                        ast = null;
                                        if (this.requiresAST(cleanUps, unit)) {
                                            ast = this.createAst(unit, options, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                                        }
                                        break;
                                    }
                                    map = cleanUps[i].getRequiredOptions();
                                    if (map != null) {
                                        options.putAll(map);
                                    }
                                    ++i;
                                }
                                undoneCleanUps = new ArrayList<E>();
                                change = CleanUpRefactoring.calculateChange(ast, unit, cleanUps, undoneCleanUps);
                                postCondition = new RefactoringStatus();
                                i = 0;
                                while (true) {
                                    if (i >= cleanUps.length) {
                                        if (this.showStatus(postCondition) == 0) break;
                                        ** continue;
                                    }
                                    conditions = cleanUps[i].checkPostConditions((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    postCondition.merge(conditions);
                                    ++i;
                                }
                                if (change == null) continue;
                                result.add((Change)change);
                                change.setSaveMode(4);
                                change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                                performChangeOperation = RefactoringUI.createUIAwareChangeOperation((Change)change);
                                performChangeOperation.setSchedulingRule(unit.getSchedulingRule());
                                performChangeOperation.run((IProgressMonitor)new SubProgressMonitor(monitor, 5));
                                performChangeOperation.getUndoChange();
                                undoEdits.addFirst(change.getUndoEdit());
                            } while ((cleanUps = undoneCleanUps.toArray(new ICleanUp[undoneCleanUps.size()])).length > 0);
                        }
                        catch (Throwable var22_31) {
                            var21_29 = null;
                            manager.changePerformed((Change)result, true);
                            throw var22_31;
                        }
                    }
lbl92:
                    // 2 sources

                    while (true) {
                        var23_3 = null;
                        break block28;
                        break;
                    }
                }
                manager.changePerformed((Change)result, true);
                ** continue;
                var21_30 = null;
                manager.changePerformed((Change)result, true);
                if (undoEdits.size() > 0) {
                    undoEditArray = undoEdits.toArray(new UndoEdit[undoEdits.size()]);
                    undo = new CleanUpSaveUndo(result.getName(), (IFile)unit.getResource(), undoEditArray, oldDocValue, oldFileValue);
                    undo.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                    manager.addUndo(result.getName(), (Change)undo);
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var24_32) {
                var23_4 = null;
                monitor.done();
                throw var24_32;
            }
        }
        monitor.done();
        return;
lbl-1000:
        // 1 sources

        {
            var23_5 = null;
        }
        monitor.done();
    }

    private int showStatus(RefactoringStatus status) {
        if (!status.hasError()) {
            return 0;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        Dialog dialog = RefactoringUI.createRefactoringStatusDialog((RefactoringStatus)status, (Shell)shell, (String)"", (boolean)false);
        return dialog.open();
    }

    private long getDocumentStamp(IFile file, IProgressMonitor monitor) throws CoreException {
        long l;
        block6: {
            ITextFileBuffer buffer;
            IPath path;
            ITextFileBufferManager manager;
            block4: {
                long l2;
                block5: {
                    manager = FileBuffers.getTextFileBufferManager();
                    path = file.getFullPath();
                    monitor.beginTask("", 2);
                    buffer = null;
                    try {
                        manager.connect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        buffer = manager.getTextFileBuffer(path, LocationKind.IFILE);
                        IDocument document = buffer.getDocument();
                        if (!(document instanceof IDocumentExtension4)) break block4;
                        l2 = ((IDocumentExtension4)document).getModificationStamp();
                        Object var7_9 = null;
                        if (buffer == null) break block5;
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        if (buffer != null) {
                            manager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        monitor.done();
                        throw throwable;
                    }
                    manager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                monitor.done();
                return l2;
            }
            l = file.getModificationStamp();
            Object var7_10 = null;
            if (buffer == null) break block6;
            manager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        monitor.done();
        return l;
    }

    private boolean requiresAST(ICleanUp[] cleanUps, ICompilationUnit unit) throws CoreException {
        int i = 0;
        while (i < cleanUps.length) {
            if (cleanUps[i].requireAST(unit)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private CompilationUnit createAst(ICompilationUnit unit, Map cleanUpOptions, IProgressMonitor monitor) {
        CompilationUnit ast;
        IJavaProject project = unit.getJavaProject();
        if (this.compatibleOptions(project, cleanUpOptions) && (ast = ASTProvider.getASTProvider().getAST((IJavaElement)unit, ASTProvider.WAIT_NO, monitor)) != null) {
            return ast;
        }
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setProject(project);
        parser.setSource(unit);
        Map compilerOptions = RefactoringASTParser.getCompilerOptions((IJavaElement)unit.getJavaProject());
        compilerOptions.putAll(cleanUpOptions);
        parser.setCompilerOptions(compilerOptions);
        return (CompilationUnit)parser.createAST(monitor);
    }

    private boolean compatibleOptions(IJavaProject project, Map cleanUpOptions) {
        if (cleanUpOptions.size() == 0) {
            return true;
        }
        Map projectOptions = project.getOptions(true);
        Iterator iterator = cleanUpOptions.keySet().iterator();
        while (iterator.hasNext()) {
            String cleanUpOption;
            String key = (String)iterator.next();
            String projectOption = (String)projectOptions.get(key);
            if (this.strongerEquals(projectOption, cleanUpOption = (String)cleanUpOptions.get(key))) continue;
            return false;
        }
        return true;
    }

    private boolean strongerEquals(String projectOption, String cleanUpOption) {
        if (projectOption == null) {
            return false;
        }
        if (ERROR_VALUE.equals(cleanUpOption)) {
            return ERROR_VALUE.equals(projectOption);
        }
        if (WARNING_VALUE.equals(cleanUpOption)) {
            return ERROR_VALUE.equals(projectOption) || WARNING_VALUE.equals(projectOption);
        }
        return false;
    }

    public String getName() {
        return FixMessages.CleanUpPostSaveListener_name;
    }

    public String getId() {
        return POSTSAVELISTENER_ID;
    }

    private static class CleanUpSaveUndo
    extends TextFileChange {
        private final IFile fFile;
        private final UndoEdit[] fUndos;
        private final long fDocumentStamp;
        private final long fFileStamp;

        public CleanUpSaveUndo(String name, IFile file, UndoEdit[] undos, long documentStamp, long fileStamp) {
            super(name, file);
            Assert.isNotNull((Object)undos);
            this.fDocumentStamp = documentStamp;
            this.fFileStamp = fileStamp;
            this.fFile = file;
            this.fUndos = undos;
        }

        public final boolean needsSaving() {
            return true;
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            CleanUpSaveUndo cleanUpSaveUndo;
            block13: {
                if (this.isValid(pm).hasFatalError()) {
                    return new NullChange();
                }
                if (pm == null) {
                    pm = new NullProgressMonitor();
                }
                ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                pm.beginTask("", 2);
                ITextFileBuffer buffer = null;
                try {
                    manager.connect(this.fFile.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    buffer = manager.getTextFileBuffer(this.fFile.getFullPath(), LocationKind.IFILE);
                    IDocument document = buffer.getDocument();
                    long oldFileValue = this.fFile.getModificationStamp();
                    long oldDocValue = document instanceof IDocumentExtension4 ? ((IDocumentExtension4)document).getModificationStamp() : oldFileValue;
                    LinkedList<UndoEdit> list = new LinkedList<UndoEdit>();
                    int index = 0;
                    while (index < this.fUndos.length) {
                        UndoEdit edit = this.fUndos[index];
                        UndoEdit redo = edit.apply(document, 1);
                        list.addFirst(redo);
                        ++index;
                    }
                    boolean stampSetted = false;
                    if (document instanceof IDocumentExtension4 && this.fDocumentStamp != -1L) {
                        try {
                            ((IDocumentExtension4)document).replace(0, 0, "", this.fDocumentStamp);
                            stampSetted = true;
                        }
                        catch (BadLocationException e) {
                            String message = e.getMessage();
                            if (message == null) {
                                message = "BadLocationException";
                            }
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 10001, message, (Throwable)e));
                        }
                    }
                    buffer.commit(pm, false);
                    if (!stampSetted) {
                        this.fFile.revertModificationStamp(this.fFileStamp);
                    }
                    cleanUpSaveUndo = new CleanUpSaveUndo(this.getName(), this.fFile, list.toArray(new UndoEdit[list.size()]), oldDocValue, oldFileValue);
                    Object var13_15 = null;
                    if (buffer == null) break block13;
                }
                catch (BadLocationException e) {
                    try {
                        String message = e.getMessage();
                        if (message == null) {
                            message = "BadLocationException";
                        }
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 10001, message, (Throwable)e));
                    }
                    catch (Throwable throwable) {
                        block14: {
                            Object var13_16 = null;
                            if (buffer == null) break block14;
                            manager.disconnect(this.fFile.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                        }
                        throw throwable;
                    }
                }
                manager.disconnect(this.fFile.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            return cleanUpSaveUndo;
        }
    }
}

