/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.fix.ConvertForLoopOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.ConvertIterableLoopOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.ConvertLoopOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.ILinkedFixRewriteOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedFix;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;

public class ConvertLoopFix
extends LinkedFix {
    public static IFix createCleanUp(CompilationUnit compilationUnit, boolean convertForLoops, boolean convertIterableForLoops, boolean makeFinal) {
        if (!JavaModelUtil.is50OrHigher(compilationUnit.getJavaElement().getJavaProject())) {
            return null;
        }
        if (!convertForLoops && !convertIterableForLoops) {
            return null;
        }
        ArrayList operations = new ArrayList();
        ControlStatementFinder finder = new ControlStatementFinder(convertForLoops, convertIterableForLoops, makeFinal, operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        IFixRewriteOperation[] ops = operations.toArray(new IFixRewriteOperation[operations.size()]);
        return new ConvertLoopFix(FixMessages.ControlStatementsFix_change_name, compilationUnit, ops);
    }

    public static IFix createConvertForLoopToEnhancedFix(CompilationUnit compilationUnit, ForStatement loop) {
        ConvertForLoopOperation convertForLoopOperation = new ConvertForLoopOperation(loop);
        if (!((ConvertLoopOperation)convertForLoopOperation).satisfiesPreconditions().isOK()) {
            return null;
        }
        return new ConvertLoopFix(FixMessages.Java50Fix_ConvertToEnhancedForLoop_description, compilationUnit, new ILinkedFixRewriteOperation[]{convertForLoopOperation});
    }

    public static IFix createConvertIterableLoopToEnhancedFix(CompilationUnit compilationUnit, ForStatement loop) {
        ConvertIterableLoopOperation loopConverter = new ConvertIterableLoopOperation(loop);
        IStatus status = loopConverter.satisfiesPreconditions();
        if (status.getSeverity() == 4) {
            return null;
        }
        ConvertLoopFix result = new ConvertLoopFix(FixMessages.Java50Fix_ConvertToEnhancedForLoop_description, compilationUnit, new ILinkedFixRewriteOperation[]{loopConverter});
        result.setStatus(status);
        return result;
    }

    protected ConvertLoopFix(String name, CompilationUnit compilationUnit, IFixRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    private static final class ControlStatementFinder
    extends GenericVisitor {
        private final List fResult;
        private final Hashtable fUsedNames;
        private final boolean fFindForLoopsToConvert;
        private final boolean fConvertIterableForLoops;
        private final boolean fMakeFinal;

        public ControlStatementFinder(boolean findForLoopsToConvert, boolean convertIterableForLoops, boolean makeFinal, List resultingCollection) {
            this.fFindForLoopsToConvert = findForLoopsToConvert;
            this.fConvertIterableForLoops = convertIterableForLoops;
            this.fMakeFinal = makeFinal;
            this.fResult = resultingCollection;
            this.fUsedNames = new Hashtable();
        }

        public boolean visit(ForStatement node) {
            if (this.fFindForLoopsToConvert || this.fConvertIterableForLoops) {
                ForStatement current = node;
                ConvertLoopOperation operation = this.getConvertOperation(current);
                ConvertLoopOperation oldOperation = null;
                while (operation != null) {
                    if (oldOperation == null) {
                        this.fResult.add(operation);
                    } else {
                        oldOperation.setBodyConverter(operation);
                    }
                    if (current.getBody() instanceof ForStatement) {
                        current = (ForStatement)current.getBody();
                        oldOperation = operation;
                        operation = this.getConvertOperation(current);
                        continue;
                    }
                    operation = null;
                }
                current.getBody().accept((ASTVisitor)this);
                return false;
            }
            return super.visit(node);
        }

        private ConvertLoopOperation getConvertOperation(ForStatement node) {
            ConvertIterableLoopOperation iterableConverter;
            Collection usedNamesCollection = this.fUsedNames.values();
            String[] usedNames = usedNamesCollection.toArray(new String[usedNamesCollection.size()]);
            ConvertForLoopOperation convertForLoopOperation = new ConvertForLoopOperation(node, usedNames, this.fMakeFinal);
            if (((ConvertLoopOperation)convertForLoopOperation).satisfiesPreconditions().isOK()) {
                if (this.fFindForLoopsToConvert) {
                    this.fUsedNames.put(node, ((ConvertLoopOperation)convertForLoopOperation).getIntroducedVariableName());
                    return convertForLoopOperation;
                }
            } else if (this.fConvertIterableForLoops && ((ConvertLoopOperation)(iterableConverter = new ConvertIterableLoopOperation(node, usedNames, this.fMakeFinal))).satisfiesPreconditions().isOK()) {
                this.fUsedNames.put(node, ((ConvertLoopOperation)iterableConverter).getIntroducedVariableName());
                return iterableConverter;
            }
            return null;
        }

        public void endVisit(ForStatement node) {
            if (this.fFindForLoopsToConvert || this.fConvertIterableForLoops) {
                this.fUsedNames.remove(node);
            }
            super.endVisit(node);
        }
    }
}

