/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.wst.jsdt.internal.corext.util.JavaElementResourceMapping;

abstract class CompilationUnitReorgChange
extends JDTChange {
    private String fCuHandle;
    private String fOldPackageHandle;
    private String fNewPackageHandle;
    private INewNameQuery fNewNameQuery;
    static /* synthetic */ Class class$0;

    CompilationUnitReorgChange(ICompilationUnit cu, IPackageFragment dest, INewNameQuery newNameQuery) {
        this.fCuHandle = cu.getHandleIdentifier();
        this.fNewPackageHandle = dest.getHandleIdentifier();
        this.fNewNameQuery = newNameQuery;
        this.fOldPackageHandle = cu.getParent().getHandleIdentifier();
    }

    CompilationUnitReorgChange(ICompilationUnit cu, IPackageFragment dest) {
        this(cu, dest, null);
    }

    CompilationUnitReorgChange(String oldPackageHandle, String newPackageHandle, String cuHandle) {
        this.fOldPackageHandle = oldPackageHandle;
        this.fNewPackageHandle = newPackageHandle;
        this.fCuHandle = cuHandle;
    }

    public final Change perform(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        Change change;
        pm.beginTask(this.getName(), 1);
        try {
            ICompilationUnit unit = this.getCu();
            ResourceMapping mapping = JavaElementResourceMapping.create(unit);
            Change result = this.doPerformReorg((IProgressMonitor)new SubProgressMonitor(pm, 1));
            this.markAsExecuted(unit, mapping);
            change = result;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return change;
    }

    abstract Change doPerformReorg(IProgressMonitor var1) throws CoreException, OperationCanceledException;

    public Object getModifiedElement() {
        return this.getCu();
    }

    ICompilationUnit getCu() {
        return (ICompilationUnit)JavaCore.create((String)this.fCuHandle);
    }

    IPackageFragment getOldPackage() {
        return (IPackageFragment)JavaCore.create((String)this.fOldPackageHandle);
    }

    IPackageFragment getDestinationPackage() {
        return (IPackageFragment)JavaCore.create((String)this.fNewPackageHandle);
    }

    String getNewName() throws OperationCanceledException {
        if (this.fNewNameQuery == null) {
            return null;
        }
        return this.fNewNameQuery.getNewName();
    }

    static String getPackageName(IPackageFragment pack) {
        if (pack.isDefaultPackage()) {
            return RefactoringCoreMessages.MoveCompilationUnitChange_default_package;
        }
        return pack.getElementName();
    }

    private void markAsExecuted(ICompilationUnit unit, ResourceMapping mapping) {
        ReorgExecutionLog log;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((log = (ReorgExecutionLog)this.getAdapter(clazz)) != null) {
            log.markAsProcessed((Object)unit);
            log.markAsProcessed((Object)mapping);
        }
    }
}

