/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.AssertStatement;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.ListExpression;
import org.eclipse.wst.jsdt.core.dom.MarkerAnnotation;
import org.eclipse.wst.jsdt.core.dom.MemberValuePair;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NormalAnnotation;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleMemberAnnotation;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WildcardType;
import org.eclipse.wst.jsdt.core.dom.WithStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.BlockFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.BranchFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.ConditionalFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.DoWhileFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.EnhancedForFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.ForFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.GenericSequentialFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.IfFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.LocalFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.MessageSendFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.ReturnFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.SwitchFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.ThrowFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.TryFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.TypeVariableFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.WhileFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.WithFlowInfo;

abstract class FlowAnalyzer
extends GenericVisitor {
    private HashMap fData = new HashMap(100);
    FlowContext fFlowContext = null;

    public FlowAnalyzer(FlowContext context) {
        this.fFlowContext = context;
    }

    protected abstract boolean createReturnFlowInfo(ReturnStatement var1);

    protected abstract boolean traverseNode(ASTNode var1);

    protected boolean skipNode(ASTNode node) {
        return !this.traverseNode(node);
    }

    protected final boolean visitNode(ASTNode node) {
        return this.traverseNode(node);
    }

    protected ReturnFlowInfo createReturn(ReturnStatement statement) {
        return new ReturnFlowInfo(statement);
    }

    protected ThrowFlowInfo createThrow() {
        return new ThrowFlowInfo();
    }

    protected BranchFlowInfo createBranch(SimpleName label) {
        return new BranchFlowInfo(label, this.fFlowContext);
    }

    protected GenericSequentialFlowInfo createSequential() {
        return new GenericSequentialFlowInfo();
    }

    protected ConditionalFlowInfo createConditional() {
        return new ConditionalFlowInfo();
    }

    protected EnhancedForFlowInfo createEnhancedFor() {
        return new EnhancedForFlowInfo();
    }

    protected ForFlowInfo createFor() {
        return new ForFlowInfo();
    }

    protected TryFlowInfo createTry() {
        return new TryFlowInfo();
    }

    protected WhileFlowInfo createWhile() {
        return new WhileFlowInfo();
    }

    protected WithFlowInfo createWith() {
        return new WithFlowInfo();
    }

    protected IfFlowInfo createIf() {
        return new IfFlowInfo();
    }

    protected DoWhileFlowInfo createDoWhile() {
        return new DoWhileFlowInfo();
    }

    protected SwitchFlowInfo createSwitch() {
        return new SwitchFlowInfo();
    }

    protected BlockFlowInfo createBlock() {
        return new BlockFlowInfo();
    }

    protected MessageSendFlowInfo createMessageSendFlowInfo() {
        return new MessageSendFlowInfo();
    }

    protected FlowContext getFlowContext() {
        return this.fFlowContext;
    }

    protected FlowInfo getFlowInfo(ASTNode node) {
        return (FlowInfo)this.fData.remove(node);
    }

    protected void setFlowInfo(ASTNode node, FlowInfo info) {
        this.fData.put(node, info);
    }

    protected FlowInfo assignFlowInfo(ASTNode target, ASTNode source) {
        FlowInfo result = this.getFlowInfo(source);
        this.setFlowInfo(target, result);
        return result;
    }

    protected FlowInfo accessFlowInfo(ASTNode node) {
        return (FlowInfo)this.fData.get(node);
    }

    protected GenericSequentialFlowInfo processSequential(ASTNode parent, List nodes) {
        GenericSequentialFlowInfo result = this.createSequential(parent);
        this.process(result, nodes);
        return result;
    }

    protected GenericSequentialFlowInfo processSequential(ASTNode parent, ASTNode node1) {
        GenericSequentialFlowInfo result = this.createSequential(parent);
        if (node1 != null) {
            result.merge(this.getFlowInfo(node1), this.fFlowContext);
        }
        return result;
    }

    protected GenericSequentialFlowInfo processSequential(ASTNode parent, ASTNode node1, ASTNode node2) {
        GenericSequentialFlowInfo result = this.createSequential(parent);
        if (node1 != null) {
            result.merge(this.getFlowInfo(node1), this.fFlowContext);
        }
        if (node2 != null) {
            result.merge(this.getFlowInfo(node2), this.fFlowContext);
        }
        return result;
    }

    protected GenericSequentialFlowInfo createSequential(ASTNode parent) {
        GenericSequentialFlowInfo result = this.createSequential();
        this.setFlowInfo(parent, result);
        return result;
    }

    protected GenericSequentialFlowInfo createSequential(List nodes) {
        GenericSequentialFlowInfo result = this.createSequential();
        this.process(result, nodes);
        return result;
    }

    protected void process(GenericSequentialFlowInfo info, List nodes) {
        if (nodes == null) {
            return;
        }
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            info.merge(this.getFlowInfo((ASTNode)iter.next()), this.fFlowContext);
        }
    }

    protected void process(GenericSequentialFlowInfo info, ASTNode node) {
        if (node != null) {
            info.merge(this.getFlowInfo(node), this.fFlowContext);
        }
    }

    protected void process(GenericSequentialFlowInfo info, ASTNode node1, ASTNode node2) {
        if (node1 != null) {
            info.merge(this.getFlowInfo(node1), this.fFlowContext);
        }
        if (node2 != null) {
            info.merge(this.getFlowInfo(node2), this.fFlowContext);
        }
    }

    public boolean visit(EmptyStatement node) {
        return false;
    }

    public boolean visit(TryStatement node) {
        if (this.traverseNode((ASTNode)node)) {
            this.fFlowContext.pushExcptions(node);
            node.getBody().accept((ASTVisitor)this);
            this.fFlowContext.popExceptions();
            List catchClauses = node.catchClauses();
            Iterator iter = catchClauses.iterator();
            while (iter.hasNext()) {
                ((CatchClause)iter.next()).accept((ASTVisitor)this);
            }
            Block finallyBlock = node.getFinally();
            if (finallyBlock != null) {
                finallyBlock.accept((ASTVisitor)this);
            }
        }
        return false;
    }

    protected SwitchData createSwitchData(SwitchStatement node) {
        SwitchData result = new SwitchData();
        List statements = node.statements();
        if (statements.isEmpty()) {
            return result;
        }
        int start = -1;
        int end = -1;
        GenericSequentialFlowInfo info = null;
        Iterator iter = statements.iterator();
        while (iter.hasNext()) {
            Statement statement = (Statement)iter.next();
            if (statement instanceof SwitchCase) {
                SwitchCase switchCase = (SwitchCase)statement;
                if (switchCase.isDefault()) {
                    result.setHasDefaultCase();
                }
                if (info == null) {
                    info = this.createSequential();
                    start = statement.getStartPosition();
                } else if (info.isReturn() || info.isPartialReturn() || info.branches()) {
                    result.add((IRegion)new Region(start, end - start + 1), info);
                    info = this.createSequential();
                    start = statement.getStartPosition();
                }
            } else {
                info.merge(this.getFlowInfo((ASTNode)statement), this.fFlowContext);
            }
            end = statement.getStartPosition() + statement.getLength() - 1;
        }
        result.add((IRegion)new Region(start, end - start + 1), info);
        return result;
    }

    protected void endVisit(SwitchStatement node, SwitchData data) {
        SwitchFlowInfo switchFlowInfo = this.createSwitch();
        this.setFlowInfo((ASTNode)node, switchFlowInfo);
        switchFlowInfo.mergeTest(this.getFlowInfo((ASTNode)node.getExpression()), this.fFlowContext);
        FlowInfo[] cases = data.getInfos();
        int i = 0;
        while (i < cases.length) {
            switchFlowInfo.mergeCase(cases[i], this.fFlowContext);
            ++i;
        }
        switchFlowInfo.mergeDefault(data.hasDefaultCase(), this.fFlowContext);
        switchFlowInfo.removeLabel(null);
    }

    public void endVisit(AnnotationTypeDeclaration node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.bodyDeclarations());
        info.setNoReturn();
    }

    public void endVisit(AnnotationTypeMemberDeclaration node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)node.getType(), (ASTNode)node.getDefault());
        info.setNoReturn();
    }

    public void endVisit(AnonymousClassDeclaration node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.bodyDeclarations());
        info.setNoReturn();
    }

    public void endVisit(ArrayAccess node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getArray(), (ASTNode)node.getIndex());
    }

    public void endVisit(ArrayCreation node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)node.getType());
        this.process(info, node.dimensions());
        this.process(info, (ASTNode)node.getInitializer());
    }

    public void endVisit(ArrayInitializer node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, node.expressions());
    }

    public void endVisit(ArrayType node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getElementType());
    }

    public void endVisit(AssertStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        IfFlowInfo info = new IfFlowInfo();
        this.setFlowInfo((ASTNode)node, info);
        info.mergeCondition(this.getFlowInfo((ASTNode)node.getExpression()), this.fFlowContext);
        info.merge(this.getFlowInfo((ASTNode)node.getMessage()), null, this.fFlowContext);
    }

    public void endVisit(Assignment node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        FlowInfo lhs = this.getFlowInfo((ASTNode)node.getLeftHandSide());
        FlowInfo rhs = this.getFlowInfo((ASTNode)node.getRightHandSide());
        if (lhs instanceof LocalFlowInfo) {
            LocalFlowInfo llhs = (LocalFlowInfo)lhs;
            llhs.setWriteAccess(this.fFlowContext);
            if (node.getOperator() != Assignment.Operator.ASSIGN) {
                GenericSequentialFlowInfo tmp = this.createSequential();
                tmp.merge(new LocalFlowInfo(llhs, 2, this.fFlowContext), this.fFlowContext);
                tmp.merge(rhs, this.fFlowContext);
                rhs = tmp;
            }
        }
        GenericSequentialFlowInfo info = this.createSequential((ASTNode)node);
        info.merge(rhs, this.fFlowContext);
        info.merge(lhs, this.fFlowContext);
    }

    public void endVisit(Block node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        BlockFlowInfo info = this.createBlock();
        this.setFlowInfo((ASTNode)node, info);
        this.process((GenericSequentialFlowInfo)info, node.statements());
    }

    public void endVisit(BooleanLiteral node) {
    }

    public void endVisit(BreakStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.setFlowInfo((ASTNode)node, this.createBranch(node.getLabel()));
    }

    public void endVisit(CastExpression node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getType(), (ASTNode)node.getExpression());
    }

    public void endVisit(CatchClause node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getException(), (ASTNode)node.getBody());
    }

    public void endVisit(CharacterLiteral node) {
    }

    public void endVisit(ClassInstanceCreation node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)node.getExpression());
        this.process(info, (ASTNode)node.getType());
        this.process(info, node.arguments());
        this.process(info, (ASTNode)node.getMember());
        this.process(info, (ASTNode)node.getAnonymousClassDeclaration());
    }

    public void endVisit(CompilationUnit node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.imports());
        this.process(info, node.types());
    }

    public void endVisit(ConditionalExpression node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        ConditionalFlowInfo info = this.createConditional();
        this.setFlowInfo((ASTNode)node, info);
        info.mergeCondition(this.getFlowInfo((ASTNode)node.getExpression()), this.fFlowContext);
        info.merge(this.getFlowInfo((ASTNode)node.getThenExpression()), this.getFlowInfo((ASTNode)node.getElseExpression()), this.fFlowContext);
    }

    public void endVisit(ConstructorInvocation node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, node.arguments());
    }

    public void endVisit(ContinueStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.setFlowInfo((ASTNode)node, this.createBranch(node.getLabel()));
    }

    public void endVisit(DoStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        DoWhileFlowInfo info = this.createDoWhile();
        this.setFlowInfo((ASTNode)node, info);
        info.mergeAction(this.getFlowInfo((ASTNode)node.getBody()), this.fFlowContext);
        info.mergeCondition(this.getFlowInfo((ASTNode)node.getExpression()), this.fFlowContext);
        info.removeLabel(null);
    }

    public void endVisit(EmptyStatement node) {
    }

    public void endVisit(EnhancedForStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        EnhancedForFlowInfo forInfo = this.createEnhancedFor();
        this.setFlowInfo((ASTNode)node, forInfo);
        forInfo.mergeParameter(this.getFlowInfo((ASTNode)node.getParameter()), this.fFlowContext);
        forInfo.mergeExpression(this.getFlowInfo((ASTNode)node.getExpression()), this.fFlowContext);
        forInfo.mergeAction(this.getFlowInfo((ASTNode)node.getBody()), this.fFlowContext);
        forInfo.removeLabel(null);
    }

    public void endVisit(EnumConstantDeclaration node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.arguments());
        this.process(info, (ASTNode)node.getAnonymousClassDeclaration());
    }

    public void endVisit(EnumDeclaration node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, node.superInterfaceTypes());
        this.process(info, node.enumConstants());
        this.process(info, node.bodyDeclarations());
        info.setNoReturn();
    }

    public void endVisit(ExpressionStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.assignFlowInfo((ASTNode)node, (ASTNode)node.getExpression());
    }

    public void endVisit(FieldAccess node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getExpression(), (ASTNode)node.getName());
    }

    public void endVisit(FieldDeclaration node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)node.getType());
        this.process(info, node.fragments());
    }

    public void endVisit(ForStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        ForFlowInfo forInfo = this.createFor();
        this.setFlowInfo((ASTNode)node, forInfo);
        forInfo.mergeInitializer(this.createSequential(node.initializers()), this.fFlowContext);
        forInfo.mergeCondition(this.getFlowInfo((ASTNode)node.getExpression()), this.fFlowContext);
        forInfo.mergeAction(this.getFlowInfo((ASTNode)node.getBody()), this.fFlowContext);
        forInfo.mergeIncrement(this.createSequential(node.updaters()), this.fFlowContext);
        forInfo.removeLabel(null);
    }

    public void endVisit(ForInStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        EnhancedForFlowInfo forInfo = this.createEnhancedFor();
        this.setFlowInfo((ASTNode)node, forInfo);
        forInfo.mergeParameter(this.getFlowInfo((ASTNode)node.getIterationVariable()), this.fFlowContext);
        forInfo.mergeExpression(this.getFlowInfo((ASTNode)node.getCollection()), this.fFlowContext);
        forInfo.mergeAction(this.getFlowInfo((ASTNode)node.getBody()), this.fFlowContext);
        forInfo.removeLabel(null);
    }

    public void endVisit(IfStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        IfFlowInfo info = this.createIf();
        this.setFlowInfo((ASTNode)node, info);
        info.mergeCondition(this.getFlowInfo((ASTNode)node.getExpression()), this.fFlowContext);
        info.merge(this.getFlowInfo((ASTNode)node.getThenStatement()), this.getFlowInfo((ASTNode)node.getElseStatement()), this.fFlowContext);
    }

    public void endVisit(ImportDeclaration node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.assignFlowInfo((ASTNode)node, (ASTNode)node.getName());
    }

    public void endVisit(InfixExpression node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)node.getLeftOperand(), (ASTNode)node.getRightOperand());
        this.process(info, node.extendedOperands());
    }

    public void endVisit(InstanceofExpression node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getLeftOperand(), (ASTNode)node.getRightOperand());
    }

    public void endVisit(Initializer node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.assignFlowInfo((ASTNode)node, (ASTNode)node.getBody());
    }

    public void endVisit(Javadoc node) {
    }

    public void endVisit(LabeledStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        FlowInfo info = this.assignFlowInfo((ASTNode)node, (ASTNode)node.getBody());
        if (info != null) {
            info.removeLabel(node.getLabel());
        }
    }

    public void endVisit(ListExpression node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, node.expressions());
    }

    public void endVisit(MarkerAnnotation node) {
    }

    public void endVisit(MemberValuePair node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        FlowInfo name = this.getFlowInfo((ASTNode)node.getName());
        FlowInfo value = this.getFlowInfo((ASTNode)node.getValue());
        if (name instanceof LocalFlowInfo) {
            LocalFlowInfo llhs = (LocalFlowInfo)name;
            llhs.setWriteAccess(this.fFlowContext);
        }
        GenericSequentialFlowInfo info = this.createSequential((ASTNode)node);
        info.merge(value, this.fFlowContext);
        info.merge(name, this.fFlowContext);
    }

    public void endVisit(MethodDeclaration node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)node.getReturnType2());
        this.process(info, node.parameters());
        this.process(info, node.thrownExceptions());
        this.process(info, (ASTNode)node.getBody());
    }

    public void endVisit(MethodInvocation node) {
        this.endVisitMethodInvocation((ASTNode)node, (ASTNode)node.getExpression(), node.arguments(), this.getMethodBinding((Name)node.getName()));
    }

    public void endVisit(NormalAnnotation node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)node.getTypeName());
        this.process(info, node.values());
    }

    public void endVisit(NullLiteral node) {
    }

    public void endVisit(NumberLiteral node) {
    }

    public void endVisit(PackageDeclaration node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.assignFlowInfo((ASTNode)node, (ASTNode)node.getName());
    }

    public void endVisit(ParameterizedType node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)node.getType());
        this.process(info, node.typeArguments());
    }

    public void endVisit(ParenthesizedExpression node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.assignFlowInfo((ASTNode)node, (ASTNode)node.getExpression());
    }

    public void endVisit(PostfixExpression node) {
        this.endVisitIncDecOperation((Expression)node, node.getOperand());
    }

    public void endVisit(PrefixExpression node) {
        PrefixExpression.Operator op = node.getOperator();
        if (PrefixExpression.Operator.INCREMENT.equals(op) || PrefixExpression.Operator.DECREMENT.equals(op)) {
            this.endVisitIncDecOperation((Expression)node, node.getOperand());
        } else {
            this.assignFlowInfo((ASTNode)node, (ASTNode)node.getOperand());
        }
    }

    public void endVisit(PrimitiveType node) {
    }

    public void endVisit(QualifiedName node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getQualifier(), (ASTNode)node.getName());
    }

    public void endVisit(QualifiedType node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getQualifier(), (ASTNode)node.getName());
    }

    public void endVisit(ReturnStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        if (this.createReturnFlowInfo(node)) {
            ReturnFlowInfo info = this.createReturn(node);
            this.setFlowInfo((ASTNode)node, info);
            info.merge(this.getFlowInfo((ASTNode)node.getExpression()), this.fFlowContext);
        } else {
            this.assignFlowInfo((ASTNode)node, (ASTNode)node.getExpression());
        }
    }

    public void endVisit(SimpleName node) {
        ITypeBinding type;
        if (this.skipNode((ASTNode)node) || node.isDeclaration()) {
            return;
        }
        IBinding binding = node.resolveBinding();
        if (binding instanceof IVariableBinding) {
            IVariableBinding variable = (IVariableBinding)binding;
            if (!variable.isField() && !variable.isGlobal()) {
                this.setFlowInfo((ASTNode)node, new LocalFlowInfo(variable, 2, this.fFlowContext));
            }
        } else if (binding instanceof ITypeBinding && (type = (ITypeBinding)binding).isTypeVariable()) {
            this.setFlowInfo((ASTNode)node, new TypeVariableFlowInfo(type, this.fFlowContext));
        }
    }

    public void endVisit(SimpleType node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.assignFlowInfo((ASTNode)node, (ASTNode)node.getName());
    }

    public void endVisit(SingleMemberAnnotation node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.assignFlowInfo((ASTNode)node, (ASTNode)node.getValue());
    }

    public void endVisit(SingleVariableDeclaration node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        IVariableBinding binding = node.resolveBinding();
        LocalFlowInfo nameInfo = null;
        Expression initializer = node.getInitializer();
        if (binding != null && !binding.isField() && initializer != null) {
            nameInfo = new LocalFlowInfo(binding, 8, this.fFlowContext);
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)node.getType(), (ASTNode)initializer);
        info.merge(nameInfo, this.fFlowContext);
    }

    public void endVisit(StringLiteral node) {
    }

    public void endVisit(SuperConstructorInvocation node) {
        this.endVisitMethodInvocation((ASTNode)node, (ASTNode)node.getExpression(), node.arguments(), node.resolveConstructorBinding());
    }

    public void endVisit(SuperFieldAccess node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.processSequential((ASTNode)node, (ASTNode)node.getQualifier(), (ASTNode)node.getName());
    }

    public void endVisit(SuperMethodInvocation node) {
        this.endVisitMethodInvocation((ASTNode)node, (ASTNode)node.getQualifier(), node.arguments(), this.getMethodBinding((Name)node.getName()));
    }

    public void endVisit(SwitchCase node) {
        this.endVisitNode((ASTNode)node);
    }

    public void endVisit(SwitchStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.endVisit(node, this.createSwitchData(node));
    }

    public void endVisit(ThisExpression node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.assignFlowInfo((ASTNode)node, (ASTNode)node.getQualifier());
    }

    public void endVisit(ThrowStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        ThrowFlowInfo info = this.createThrow();
        this.setFlowInfo((ASTNode)node, info);
        Expression expression = node.getExpression();
        info.merge(this.getFlowInfo((ASTNode)expression), this.fFlowContext);
        info.mergeException(expression.resolveTypeBinding(), this.fFlowContext);
    }

    public void endVisit(TryStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        TryFlowInfo info = this.createTry();
        this.setFlowInfo((ASTNode)node, info);
        info.mergeTry(this.getFlowInfo((ASTNode)node.getBody()), this.fFlowContext);
        info.removeExceptions(node);
        Iterator iter = node.catchClauses().iterator();
        while (iter.hasNext()) {
            CatchClause element = (CatchClause)iter.next();
            info.mergeCatch(this.getFlowInfo((ASTNode)element), this.fFlowContext);
        }
        info.mergeFinally(this.getFlowInfo((ASTNode)node.getFinally()), this.fFlowContext);
    }

    public void endVisit(TypeDeclaration node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)node.getSuperclassType());
        this.process(info, node.superInterfaceTypes());
        this.process(info, node.bodyDeclarations());
        info.setNoReturn();
    }

    public void endVisit(TypeDeclarationStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.assignFlowInfo((ASTNode)node, (ASTNode)node.getDeclaration());
    }

    public void endVisit(TypeLiteral node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.assignFlowInfo((ASTNode)node, (ASTNode)node.getType());
    }

    public void endVisit(TypeParameter node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)node.getName());
        this.process(info, node.typeBounds());
    }

    public void endVisit(VariableDeclarationExpression node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)node.getType());
        this.process(info, node.fragments());
    }

    public void endVisit(VariableDeclarationStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)node.getType());
        this.process(info, node.fragments());
    }

    public void endVisit(VariableDeclarationFragment node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        IVariableBinding binding = node.resolveBinding();
        LocalFlowInfo nameInfo = null;
        Expression initializer = node.getInitializer();
        if (binding != null && !binding.isField() && initializer != null) {
            nameInfo = new LocalFlowInfo(binding, 8, this.fFlowContext);
        }
        GenericSequentialFlowInfo info = this.processSequential((ASTNode)node, (ASTNode)initializer);
        info.merge(nameInfo, this.fFlowContext);
    }

    public void endVisit(WhileStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        WhileFlowInfo info = this.createWhile();
        this.setFlowInfo((ASTNode)node, info);
        info.mergeCondition(this.getFlowInfo((ASTNode)node.getExpression()), this.fFlowContext);
        info.mergeAction(this.getFlowInfo((ASTNode)node.getBody()), this.fFlowContext);
        info.removeLabel(null);
    }

    public void endVisit(WithStatement node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        WithFlowInfo info = this.createWith();
        this.setFlowInfo((ASTNode)node, info);
        info.mergeCondition(this.getFlowInfo((ASTNode)node.getExpression()), this.fFlowContext);
        info.mergeAction(this.getFlowInfo((ASTNode)node.getBody()), this.fFlowContext);
        info.removeLabel(null);
    }

    public void endVisit(WildcardType node) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        this.assignFlowInfo((ASTNode)node, (ASTNode)node.getBound());
    }

    private void endVisitMethodInvocation(ASTNode node, ASTNode receiver, List arguments, IMethodBinding binding) {
        if (this.skipNode(node)) {
            return;
        }
        MessageSendFlowInfo info = this.createMessageSendFlowInfo();
        this.setFlowInfo(node, info);
        Iterator iter = arguments.iterator();
        while (iter.hasNext()) {
            Expression arg = (Expression)iter.next();
            info.mergeArgument(this.getFlowInfo((ASTNode)arg), this.fFlowContext);
        }
        info.mergeReceiver(this.getFlowInfo(receiver), this.fFlowContext);
        info.mergeExceptions(binding, this.fFlowContext);
    }

    private void endVisitIncDecOperation(Expression node, Expression operand) {
        if (this.skipNode((ASTNode)node)) {
            return;
        }
        FlowInfo info = this.getFlowInfo((ASTNode)operand);
        if (info instanceof LocalFlowInfo) {
            GenericSequentialFlowInfo result = this.createSequential((ASTNode)node);
            result.merge(info, this.fFlowContext);
            result.merge(new LocalFlowInfo((LocalFlowInfo)info, 8, this.fFlowContext), this.fFlowContext);
        } else {
            this.setFlowInfo((ASTNode)node, info);
        }
    }

    private IMethodBinding getMethodBinding(Name name) {
        if (name == null) {
            return null;
        }
        IBinding binding = name.resolveBinding();
        if (binding instanceof IMethodBinding) {
            return (IMethodBinding)binding;
        }
        return null;
    }

    protected static class SwitchData {
        private boolean fHasDefaultCase;
        private List fRanges = new ArrayList(4);
        private List fInfos = new ArrayList(4);

        protected SwitchData() {
        }

        public void setHasDefaultCase() {
            this.fHasDefaultCase = true;
        }

        public boolean hasDefaultCase() {
            return this.fHasDefaultCase;
        }

        public void add(IRegion range, FlowInfo info) {
            this.fRanges.add(range);
            this.fInfos.add(info);
        }

        public IRegion[] getRanges() {
            return this.fRanges.toArray(new IRegion[this.fRanges.size()]);
        }

        public FlowInfo[] getInfos() {
            return this.fInfos.toArray(new FlowInfo[this.fInfos.size()]);
        }

        public FlowInfo getInfo(int index) {
            return (FlowInfo)this.fInfos.get(index);
        }
    }
}

