/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.nls;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class SimpleLineReader {
    private IDocument fInput;
    private int fCurrLine;

    public SimpleLineReader(IDocument input) {
        this.fInput = input;
        this.fCurrLine = 0;
    }

    public String readLine() {
        int end;
        int start;
        block6: {
            int nLines = this.fInput.getNumberOfLines();
            if (this.fCurrLine >= nLines) {
                return null;
            }
            try {
                IRegion region = this.fInput.getLineInformation(this.fCurrLine++);
                String content = this.fInput.get(region.getOffset(), region.getLength());
                start = region.getOffset();
                boolean continuesOnNext = content.endsWith("\\") && !SimpleLineReader.isCommentOrWhiteSpace(content);
                while (continuesOnNext && this.fCurrLine < nLines) {
                    boolean bl = continuesOnNext = (content = this.fInput.get((region = this.fInput.getLineInformation(this.fCurrLine++)).getOffset(), region.getLength())).endsWith("\\") && !SimpleLineReader.isCommentOrWhiteSpace(content);
                }
                if (this.fCurrLine < nLines) {
                    end = this.fInput.getLineOffset(this.fCurrLine);
                    break block6;
                }
                end = this.fInput.getLength();
                if (end != start) break block6;
                return null;
            }
            catch (BadLocationException e) {
                JavaPlugin.log(e);
                return null;
            }
        }
        return this.fInput.get(start, end - start);
    }

    public static boolean isCommentOrWhiteSpace(String line) {
        return (line = line.trim()).length() == 0 || line.charAt(0) == '!' || line.charAt(0) == '#';
    }
}

