/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.ISourceManipulation;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DeleteFileChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DeleteFolderChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DeleteFromClasspathChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DeletePackageFragmentRootChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DeleteSourceManipulationChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.UndoablePackageDeleteChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ASTNodeDeleteUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;

class DeleteChangeCreator {
    private DeleteChangeCreator() {
    }

    static Change createDeleteChange(TextChangeManager manager, IResource[] resources, IJavaElement[] javaElements, String changeName, List packageDeletes) throws CoreException {
        DynamicValidationStateChange result = packageDeletes.size() > 0 ? new UndoablePackageDeleteChange(changeName, packageDeletes) : new DynamicValidationStateChange(changeName);
        int i = 0;
        while (i < javaElements.length) {
            IJavaElement element = javaElements[i];
            if (!ReorgUtils.isInsideCompilationUnit(element)) {
                result.add(DeleteChangeCreator.createDeleteChange(element));
            }
            ++i;
        }
        i = 0;
        while (i < resources.length) {
            result.add(DeleteChangeCreator.createDeleteChange(resources[i]));
            ++i;
        }
        Map grouped = ReorgUtils.groupByCompilationUnit(DeleteChangeCreator.getElementsSmallerThanCu(javaElements));
        if (grouped.size() != 0) {
            Assert.isNotNull((Object)manager);
            Iterator iter = grouped.keySet().iterator();
            while (iter.hasNext()) {
                ICompilationUnit cu = (ICompilationUnit)iter.next();
                result.add(DeleteChangeCreator.createDeleteChange(cu, (List)grouped.get(cu), manager));
            }
        }
        return result;
    }

    private static Change createDeleteChange(IResource resource) {
        Assert.isTrue((!(resource instanceof IWorkspaceRoot) ? 1 : 0) != 0);
        Assert.isTrue((!(resource instanceof IProject) ? 1 : 0) != 0);
        if (resource instanceof IFile) {
            return new DeleteFileChange((IFile)resource, true);
        }
        if (resource instanceof IFolder) {
            return new DeleteFolderChange((IFolder)resource, true);
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private static Change createDeleteChange(ICompilationUnit cu, List javaElements, TextChangeManager manager) throws CoreException {
        CompilationUnit cuNode = RefactoringASTParser.parseWithASTProvider((ITypeRoot)cu, false, null);
        CompilationUnitRewrite rewriter = new CompilationUnitRewrite(cu, cuNode);
        IJavaElement[] elements = javaElements.toArray(new IJavaElement[javaElements.size()]);
        ASTNodeDeleteUtil.markAsDeleted(elements, rewriter, null);
        return DeleteChangeCreator.addTextEditFromRewrite(manager, cu, rewriter.getASTRewrite());
    }

    private static TextChange addTextEditFromRewrite(TextChangeManager manager, ICompilationUnit cu, ASTRewrite rewrite) throws CoreException {
        TextChange textChange;
        try {
            ITextFileBuffer buffer = RefactoringFileBuffers.acquire(cu);
            TextEdit resultingEdits = rewrite.rewriteAST(buffer.getDocument(), cu.getJavaProject().getOptions(true));
            TextChange textChange2 = manager.get(cu);
            if (textChange2 instanceof TextFileChange) {
                TextFileChange tfc = (TextFileChange)textChange2;
                if (cu.isWorkingCopy()) {
                    tfc.setSaveMode(4);
                }
            }
            String message = RefactoringCoreMessages.DeleteChangeCreator_1;
            TextChangeCompatibility.addTextEdit(textChange2, message, resultingEdits);
            textChange = textChange2;
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            RefactoringFileBuffers.release(cu);
            throw throwable;
        }
        RefactoringFileBuffers.release(cu);
        return textChange;
    }

    private static List getElementsSmallerThanCu(IJavaElement[] javaElements) {
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>();
        int i = 0;
        while (i < javaElements.length) {
            IJavaElement element = javaElements[i];
            if (ReorgUtils.isInsideCompilationUnit(element)) {
                result.add(element);
            }
            ++i;
        }
        return result;
    }

    private static Change createDeleteChange(IJavaElement javaElement) {
        Assert.isTrue((!ReorgUtils.isInsideCompilationUnit(javaElement) ? 1 : 0) != 0);
        switch (javaElement.getElementType()) {
            case 3: {
                return DeleteChangeCreator.createPackageFragmentRootDeleteChange((IPackageFragmentRoot)javaElement);
            }
            case 4: {
                return DeleteChangeCreator.createSourceManipulationDeleteChange((ISourceManipulation)((IPackageFragment)javaElement));
            }
            case 5: {
                return DeleteChangeCreator.createSourceManipulationDeleteChange((ISourceManipulation)((ICompilationUnit)javaElement));
            }
            case 6: {
                Assert.isTrue((boolean)(((IClassFile)javaElement).getResource() instanceof IFile));
                return DeleteChangeCreator.createDeleteChange(((IClassFile)javaElement).getResource());
            }
            case 1: {
                Assert.isTrue((boolean)false);
                return null;
            }
            case 2: {
                Assert.isTrue((boolean)false);
                return null;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                Assert.isTrue((boolean)false);
            }
        }
        Assert.isTrue((boolean)false);
        return new NullChange();
    }

    private static Change createSourceManipulationDeleteChange(ISourceManipulation element) {
        IResource resource;
        if ((element instanceof ICompilationUnit || element instanceof IPackageFragment) && (resource = element instanceof ICompilationUnit ? ReorgUtils.getResource((IJavaElement)((ICompilationUnit)element)) : ((IPackageFragment)element).getResource()) != null && resource.isLinked()) {
            return DeleteChangeCreator.createDeleteChange(resource);
        }
        return new DeleteSourceManipulationChange(element, true);
    }

    private static Change createPackageFragmentRootDeleteChange(IPackageFragmentRoot root) {
        IResource resource = root.getResource();
        if (resource != null && resource.isLinked()) {
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.DeleteRefactoring_delete_package_fragment_root);
            composite.add(new DeleteFromClasspathChange(root));
            Assert.isTrue((!Checks.isClasspathDelete(root) ? 1 : 0) != 0);
            composite.add(DeleteChangeCreator.createDeleteChange(resource));
            return composite;
        }
        Assert.isTrue((!root.isExternal() ? 1 : 0) != 0);
        return new DeletePackageFragmentRootChange(root, true, null);
    }
}

