/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.CopyArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IImportContainer;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageDeclaration;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CopyCompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CopyPackageChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CopyPackageFragmentRootChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CopyResourceChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.MoveCompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.MovePackageChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.MovePackageFragmentRootChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.MoveResourceChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ASTNodeDeleteUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ArrayTypeConverter;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.CopyModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.CreateCopyOfCompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.CreateTargetExecutionLog;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.DeleteChangeCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.INewNameQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JDTCopyRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JDTMoveRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.MoveCuUpdateCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.MoveModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.OverwriteHelper;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReadOnlyResourceFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.RefactoringModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.Changes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.QualifiedNameFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JavaElementResourceMapping;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public final class ReorgPolicyFactory {
    private static final String ATTRIBUTE_FILES = "files";
    private static final String ATTRIBUTE_FOLDERS = "folders";
    private static final String ATTRIBUTE_FRAGMENTS = "fragments";
    private static final String ATTRIBUTE_LOG = "log";
    private static final String ATTRIBUTE_MEMBERS = "members";
    private static final String ATTRIBUTE_PATTERNS = "patterns";
    private static final String ATTRIBUTE_POLICY = "policy";
    private static final String ATTRIBUTE_QUALIFIED = "qualified";
    private static final String ATTRIBUTE_ROOTS = "roots";
    private static final String ATTRIBUTE_UNITS = "units";
    private static final String DELIMITER_ELEMENT = "\t";
    private static final String DELIMITER_RECORD = "\n";
    private static final String NO_ID = "no_id";
    private static final String NO_POLICY = "no_policy";
    private static final String UNUSED_STRING = "unused";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private static boolean containsNull(Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IReorgPolicy.ICopyPolicy createCopyPolicy(IResource[] resources, IJavaElement[] javaElements) throws JavaModelException {
        return (IReorgPolicy.ICopyPolicy)ReorgPolicyFactory.createReorgPolicy(true, resources, javaElements);
    }

    public static IReorgPolicy.ICopyPolicy createCopyPolicy(RefactoringStatus status, RefactoringArguments arguments) {
        if (arguments instanceof JavaRefactoringArguments) {
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String policy = extended.getAttribute(ATTRIBUTE_POLICY);
            if (policy != null && !"".equals(policy)) {
                if ("org.eclipse.wst.jsdt.ui.copyResources".equals(policy)) {
                    return new CopyFilesFoldersAndCusPolicy(null, null, null);
                }
                if ("org.eclipse.wst.jsdt.ui.copyRoots".equals(policy)) {
                    return new CopyPackageFragmentRootsPolicy(null);
                }
                if ("org.eclipse.wst.jsdt.ui.copyPackages".equals(policy)) {
                    return new CopyPackagesPolicy(null);
                }
                if ("org.eclipse.wst.jsdt.ui.copyMembers".equals(policy)) {
                    return new CopySubCuElementsPolicy(null);
                }
                status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{policy, ATTRIBUTE_POLICY})));
            } else {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_POLICY)));
            }
        } else {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments));
        }
        return null;
    }

    public static IReorgPolicy.IMovePolicy createMovePolicy(IResource[] resources, IJavaElement[] javaElements) throws JavaModelException {
        return (IReorgPolicy.IMovePolicy)ReorgPolicyFactory.createReorgPolicy(false, resources, javaElements);
    }

    public static IReorgPolicy.IMovePolicy createMovePolicy(RefactoringStatus status, RefactoringArguments arguments) {
        if (arguments instanceof JavaRefactoringArguments) {
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String policy = extended.getAttribute(ATTRIBUTE_POLICY);
            if (policy != null && !"".equals(policy)) {
                if ("org.eclipse.wst.jsdt.ui.moveResources".equals(policy)) {
                    return new MoveFilesFoldersAndCusPolicy(null, null, null);
                }
                if ("org.eclipse.wst.jsdt.ui.moveRoots".equals(policy)) {
                    return new MovePackageFragmentRootsPolicy(null);
                }
                if ("org.eclipse.wst.jsdt.ui.movePackages".equals(policy)) {
                    return new MovePackagesPolicy(null);
                }
                if ("org.eclipse.wst.jsdt.ui.moveMembers".equals(policy)) {
                    return new MoveSubCuElementsPolicy(null);
                }
                status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{policy, ATTRIBUTE_POLICY})));
            } else {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_POLICY)));
            }
        } else {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments));
        }
        return null;
    }

    private static IReorgPolicy createReorgPolicy(boolean copy, IResource[] selectedResources, IJavaElement[] selectedJavaElements) throws JavaModelException {
        Object[] javaElements;
        ReorgPolicy NO = copy ? new NoCopyPolicy() : new NoMovePolicy();
        ActualSelectionComputer selectionComputer = new ActualSelectionComputer(selectedJavaElements, selectedResources);
        Object[] resources = selectionComputer.getActualResourcesToReorg();
        if (resources.length + (javaElements = selectionComputer.getActualJavaElementsToReorg()).length == 0 || ReorgPolicyFactory.containsNull(resources) || ReorgPolicyFactory.containsNull(javaElements) || ReorgUtils.isArchiveMember((IJavaElement[])javaElements) || ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 2) || ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 1) || ReorgUtils.hasElementsOfType((IResource[])resources, 12) || !new ParentChecker((IResource[])resources, (IJavaElement[])javaElements).haveCommonParent()) {
            return NO;
        }
        if (ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 4)) {
            if (resources.length != 0 || ReorgUtils.hasElementsNotOfType((IJavaElement[])javaElements, 4)) {
                return NO;
            }
            if (copy) {
                return new CopyPackagesPolicy(ArrayTypeConverter.toPackageArray(javaElements));
            }
            return new MovePackagesPolicy(ArrayTypeConverter.toPackageArray(javaElements));
        }
        if (ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 3)) {
            if (resources.length != 0 || ReorgUtils.hasElementsNotOfType((IJavaElement[])javaElements, 3)) {
                return NO;
            }
            if (copy) {
                return new CopyPackageFragmentRootsPolicy(ArrayTypeConverter.toPackageFragmentRootArray(javaElements));
            }
            return new MovePackageFragmentRootsPolicy(ArrayTypeConverter.toPackageFragmentRootArray(javaElements));
        }
        if (ReorgUtils.hasElementsOfType((IResource[])resources, 3) || ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 5)) {
            if (ReorgUtils.hasElementsNotOfType((IJavaElement[])javaElements, 5)) {
                return NO;
            }
            if (ReorgUtils.hasElementsNotOfType((IResource[])resources, 3)) {
                return NO;
            }
            if (copy) {
                return new CopyFilesFoldersAndCusPolicy(ReorgUtils.getFiles((IResource[])resources), ReorgUtils.getFolders((IResource[])resources), ArrayTypeConverter.toCuArray(javaElements));
            }
            return new MoveFilesFoldersAndCusPolicy(ReorgUtils.getFiles((IResource[])resources), ReorgUtils.getFolders((IResource[])resources), ArrayTypeConverter.toCuArray(javaElements));
        }
        if (ReorgPolicyFactory.hasElementsSmallerThanCuOrClassFile((IJavaElement[])javaElements)) {
            Assert.isTrue((resources.length == 0 ? 1 : 0) != 0);
            Assert.isTrue((!ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 5) ? 1 : 0) != 0);
            Assert.isTrue((!ReorgUtils.hasElementsOfType((IJavaElement[])javaElements, 6) ? 1 : 0) != 0);
            Assert.isTrue((!ReorgPolicyFactory.hasElementsLargerThanCuOrClassFile((IJavaElement[])javaElements) ? 1 : 0) != 0);
            if (copy) {
                return new CopySubCuElementsPolicy((IJavaElement[])javaElements);
            }
            return new MoveSubCuElementsPolicy((IJavaElement[])javaElements);
        }
        return NO;
    }

    private static boolean hasElementsLargerThanCuOrClassFile(IJavaElement[] javaElements) {
        int i = 0;
        while (i < javaElements.length) {
            if (!ReorgUtils.isInsideCompilationUnit(javaElements[i]) && !ReorgUtils.isInsideClassFile(javaElements[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasElementsSmallerThanCuOrClassFile(IJavaElement[] javaElements) {
        int i = 0;
        while (i < javaElements.length) {
            if (ReorgUtils.isInsideCompilationUnit(javaElements[i])) {
                return true;
            }
            if (ReorgUtils.isInsideClassFile(javaElements[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static CreateTargetExecutionLog loadCreateTargetExecutionLog(RefactoringStatus status, JavaRefactoringArguments arguments) {
        CreateTargetExecutionLog log = new CreateTargetExecutionLog();
        String value = arguments.getAttribute(ATTRIBUTE_LOG);
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, DELIMITER_RECORD, false);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                ReorgPolicyFactory.processCreateTargetExecutionRecord(log, arguments, token);
            }
        }
        return log;
    }

    public static ReorgExecutionLog loadReorgExecutionLog(RefactoringStatus status, JavaRefactoringArguments arguments) {
        ReorgExecutionLog log = new ReorgExecutionLog();
        String value = arguments.getAttribute(ATTRIBUTE_LOG);
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, DELIMITER_RECORD, false);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                ReorgPolicyFactory.processReorgExecutionRecord(log, arguments, token);
            }
        }
        return log;
    }

    private static void processCreateTargetExecutionRecord(CreateTargetExecutionLog log, JavaRefactoringArguments arguments, String token) {
        StringTokenizer tokenizer = new StringTokenizer(token, DELIMITER_ELEMENT, false);
        String value = null;
        if (tokenizer.hasMoreTokens()) {
            value = tokenizer.nextToken();
            IJavaElement selection = JDTRefactoringDescriptor.handleToElement(arguments.getProject(), value, false);
            if (selection == null) {
                selection = JDTRefactoringDescriptor.handleToResource(arguments.getProject(), value);
            }
            if (selection != null && tokenizer.hasMoreTokens()) {
                value = tokenizer.nextToken();
                IJavaElement created = JDTRefactoringDescriptor.handleToElement(arguments.getProject(), value, false);
                if (created == null) {
                    created = JDTRefactoringDescriptor.handleToResource(arguments.getProject(), value);
                }
                if (created != null) {
                    log.markAsCreated(selection, created);
                }
            }
        }
    }

    private static void processReorgExecutionRecord(ReorgExecutionLog log, JavaRefactoringArguments arguments, String token) {
        StringTokenizer tokenizer = new StringTokenizer(token, DELIMITER_ELEMENT, false);
        String value = null;
        if (tokenizer.hasMoreTokens()) {
            value = tokenizer.nextToken();
            IJavaElement element = JDTRefactoringDescriptor.handleToElement(arguments.getProject(), value);
            if (element == null) {
                element = JDTRefactoringDescriptor.handleToResource(arguments.getProject(), value);
            }
            if (tokenizer.hasMoreTokens()) {
                boolean renamed;
                boolean processed = Boolean.valueOf(tokenizer.nextToken());
                if (processed) {
                    log.markAsProcessed((Object)element);
                    if (element instanceof IJavaElement) {
                        log.markAsProcessed((Object)JavaElementResourceMapping.create(element));
                    }
                }
                if (tokenizer.hasMoreTokens() && (renamed = Boolean.valueOf(tokenizer.nextToken()).booleanValue()) && tokenizer.hasMoreTokens()) {
                    String name = tokenizer.nextToken();
                    log.setNewName((Object)element, name);
                    if (element instanceof IJavaElement) {
                        log.setNewName((Object)JavaElementResourceMapping.create(element), name);
                    }
                }
            }
        }
    }

    public static void storeCreateTargetExecutionLog(String project, Map arguments, CreateTargetExecutionLog log) {
        if (log != null) {
            StringBuffer buffer = new StringBuffer(64);
            Object[] selections = log.getSelectedElements();
            int index = 0;
            while (index < selections.length) {
                Object created;
                Object selection = selections[index];
                if (selection != null && (created = log.getCreatedElement(selection)) != null) {
                    ReorgPolicyFactory.storeLogElement(buffer, project, selection);
                    buffer.append(DELIMITER_ELEMENT);
                    ReorgPolicyFactory.storeLogElement(buffer, project, created);
                    buffer.append(DELIMITER_RECORD);
                }
                ++index;
            }
            String value = new String(buffer.toString().trim());
            if (!"".equals(value)) {
                arguments.put(ATTRIBUTE_LOG, value);
            }
        }
    }

    private static boolean storeLogElement(StringBuffer buffer, String project, Object object) {
        if (object instanceof IJavaElement) {
            IJavaElement element = (IJavaElement)object;
            buffer.append(JDTRefactoringDescriptor.elementToHandle(project, element));
            return true;
        }
        if (object instanceof IResource) {
            IResource resource = (IResource)object;
            buffer.append(JDTRefactoringDescriptor.resourceToHandle(project, resource));
            return true;
        }
        return false;
    }

    public static void storeReorgExecutionLog(String project, Map arguments, ReorgExecutionLog log) {
        if (log != null) {
            HashSet<Object> set = new HashSet<Object>();
            set.addAll(Arrays.asList(log.getProcessedElements()));
            set.addAll(Arrays.asList(log.getRenamedElements()));
            StringBuffer buffer = new StringBuffer(64);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!ReorgPolicyFactory.storeLogElement(buffer, project, object)) continue;
                buffer.append(DELIMITER_ELEMENT);
                buffer.append(log.isProcessed(object));
                buffer.append(DELIMITER_ELEMENT);
                boolean renamed = log.isRenamed(object);
                buffer.append(renamed);
                if (renamed) {
                    buffer.append(DELIMITER_ELEMENT);
                    buffer.append(log.getNewName(object));
                }
                buffer.append(DELIMITER_RECORD);
            }
            String value = new String(buffer.toString().trim());
            if (!"".equals(value)) {
                arguments.put(ATTRIBUTE_LOG, value);
            }
        }
    }

    private ReorgPolicyFactory() {
    }

    private static final class ActualSelectionComputer {
        private final IJavaElement[] fJavaElements;
        private final IResource[] fResources;

        public ActualSelectionComputer(IJavaElement[] javaElements, IResource[] resources) {
            this.fJavaElements = javaElements;
            this.fResources = resources;
        }

        public IJavaElement[] getActualJavaElementsToReorg() throws JavaModelException {
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            while (i < this.fJavaElements.length) {
                IJavaElement element = this.fJavaElements[i];
                if (element != null) {
                    if (element instanceof IType) {
                        IType type = (IType)element;
                        ICompilationUnit cu = type.getCompilationUnit();
                        if (cu != null && type.getDeclaringType() == null && cu.exists() && cu.getTypes().length == 1 && !result.contains(cu)) {
                            result.add(cu);
                        } else if (!result.contains(type)) {
                            result.add(type);
                        }
                    } else if (!result.contains(element)) {
                        result.add(element);
                    }
                }
                ++i;
            }
            return result.toArray(new IJavaElement[result.size()]);
        }

        public IResource[] getActualResourcesToReorg() {
            HashSet<IJavaElement> javaElementSet = new HashSet<IJavaElement>(Arrays.asList(this.fJavaElements));
            ArrayList<IResource> result = new ArrayList<IResource>();
            int i = 0;
            while (i < this.fResources.length) {
                IJavaElement element;
                if (!(this.fResources[i] == null || (element = JavaCore.create((IResource)this.fResources[i])) != null && element.exists() && javaElementSet.contains(element) || result.contains(this.fResources[i]))) {
                    result.add(this.fResources[i]);
                }
                ++i;
            }
            return result.toArray(new IResource[result.size()]);
        }
    }

    private static final class CopyFilesFoldersAndCusPolicy
    extends FilesFoldersAndCusReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private static final String POLICY_COPY_RESOURCE = "org.eclipse.wst.jsdt.ui.copyResources";
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        private static Change copyCuToPackage(ICompilationUnit cu, IPackageFragment dest, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IResource res = ReorgUtils.getResource((IJavaElement)cu);
            if (res != null && res.isLinked() && ResourceUtil.getResource(dest) instanceof IContainer) {
                return CopyFilesFoldersAndCusPolicy.copyFileToContainer(cu, (IContainer)ResourceUtil.getResource(dest), nameProposer, copyQueries);
            }
            String newName = nameProposer.createNewName(cu, dest);
            CopyCompilationUnitChange simpleCopy = new CopyCompilationUnitChange(cu, dest, copyQueries.createStaticQuery(newName));
            if (newName == null || newName.equals(cu.getElementName())) {
                return simpleCopy;
            }
            try {
                IPath newPath = cu.getResource().getParent().getFullPath().append(JavaModelUtil.getRenamedCUName(cu, newName));
                INewNameQuery nameQuery = copyQueries.createNewCompilationUnitNameQuery(cu, newName);
                return new CreateCopyOfCompilationUnitChange(newPath, cu.getSource(), cu, nameQuery);
            }
            catch (CoreException coreException) {
                return simpleCopy;
            }
        }

        private static Change copyFileToContainer(ICompilationUnit cu, IContainer dest, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IResource resource = ReorgUtils.getResource((IJavaElement)cu);
            return CopyFilesFoldersAndCusPolicy.createCopyResourceChange(resource, nameProposer, copyQueries, dest);
        }

        private static Change createCopyResourceChange(IResource resource, NewNameProposer nameProposer, INewNameQueries copyQueries, IContainer destination) {
            if (resource == null || destination == null) {
                return new NullChange();
            }
            String name = nameProposer.createNewName(resource, destination);
            INewNameQuery nameQuery = name == null ? copyQueries.createNullQuery() : copyQueries.createNewResourceNameQuery(resource, name);
            return new CopyResourceChange(resource, destination, nameQuery);
        }

        CopyFilesFoldersAndCusPolicy(IFile[] files, IFolder[] folders, ICompilationUnit[] cus) {
            super(files, folders, cus);
        }

        private Change createChange(ICompilationUnit unit, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            if (pack != null) {
                return CopyFilesFoldersAndCusPolicy.copyCuToPackage(unit, pack, nameProposer, copyQueries);
            }
            IContainer container = this.getDestinationAsContainer();
            return CopyFilesFoldersAndCusPolicy.copyFileToContainer(unit, container, nameProposer, copyQueries);
        }

        public Change createChange(IProgressMonitor pm, INewNameQueries copyQueries) {
            IFile[] file = this.getFiles();
            IFolder[] folders = this.getFolders();
            ICompilationUnit[] cus = this.getCus();
            pm.beginTask("", cus.length + file.length + folders.length);
            NewNameProposer nameProposer = new NewNameProposer();
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_copy);
            composite.markAsSynthetic();
            int i = 0;
            while (i < cus.length) {
                composite.add(this.createChange(cus[i], nameProposer, copyQueries));
                pm.worked(1);
                ++i;
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            i = 0;
            while (i < file.length) {
                composite.add(this.createChange((IResource)file[i], nameProposer, copyQueries));
                pm.worked(1);
                ++i;
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            i = 0;
            while (i < folders.length) {
                composite.add(this.createChange((IResource)folders[i], nameProposer, copyQueries));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return composite;
        }

        private Change createChange(IResource resource, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IContainer dest = this.getDestinationAsContainer();
            return CopyFilesFoldersAndCusPolicy.createCopyResourceChange(resource, nameProposer, copyQueries, dest);
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map arguments, String description, String project, int flags) {
            return new JDTCopyRefactoringDescriptor(this.getReorgExecutionLog(), this.getProcessorId(), project, description, comment.asString(), arguments, flags);
        }

        protected String getDescriptionPlural() {
            int kind = this.getContentKind();
            switch (kind) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_folders;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_files;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_compilation_units;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_description_plural;
        }

        protected String getDescriptionSingular() {
            int kind = this.getContentKind();
            switch (kind) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_folder;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_file;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_compilation_unit;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_description_singular;
        }

        private Object getDestination() {
            IPackageFragment result = this.getDestinationAsPackageFragment();
            if (result != null) {
                return result;
            }
            return this.getDestinationAsContainer();
        }

        protected String getHeaderPattern() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_header;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            CopyArguments jArgs = new CopyArguments(this.getDestination(), this.fReorgExecutionLog);
            CopyArguments rArgs = new CopyArguments((Object)this.getDestinationAsContainer(), this.fReorgExecutionLog);
            ICompilationUnit[] cus = this.getCus();
            int i = 0;
            while (i < cus.length) {
                this.fModifications.copy(cus[i], jArgs, rArgs);
                ++i;
            }
            IResource[] resources = ReorgUtils.union((IResource[])this.getFiles(), (IResource[])this.getFolders());
            int i2 = 0;
            while (i2 < resources.length) {
                this.fModifications.copy(resources[i2], rArgs);
                ++i2;
            }
            return this.fModifications;
        }

        public String getPolicyId() {
            return POLICY_COPY_RESOURCE;
        }

        protected String getProcessorId() {
            return "org.eclipse.wst.jsdt.ui.copy";
        }

        protected String getRefactoringId() {
            return "org.eclipse.wst.jsdt.ui.copy";
        }

        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }
    }

    private static final class CopyPackageFragmentRootsPolicy
    extends PackageFragmentRootsReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private static final String POLICY_COPY_ROOTS = "org.eclipse.wst.jsdt.ui.copyRoots";
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        public CopyPackageFragmentRootsPolicy(IPackageFragmentRoot[] roots) {
            super(roots);
        }

        private Change createChange(IPackageFragmentRoot root, IJavaProject destination, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            IProject destinationProject;
            IResource res = root.getResource();
            String newName = nameProposer.createNewName(res, (IContainer)(destinationProject = destination.getProject()));
            INewNameQuery nameQuery = newName == null ? copyQueries.createNullQuery() : copyQueries.createNewPackageFragmentRootNameQuery(root, newName);
            return new CopyPackageFragmentRootChange(root, destinationProject, nameQuery, null);
        }

        public Change createChange(IProgressMonitor pm, INewNameQueries copyQueries) {
            NewNameProposer nameProposer = new NewNameProposer();
            IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
            pm.beginTask("", roots.length);
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_copy_source_folder);
            composite.markAsSynthetic();
            IJavaProject destination = this.getDestinationJavaProject();
            Assert.isNotNull((Object)destination);
            int i = 0;
            while (i < roots.length) {
                composite.add(this.createChange(roots[i], destination, nameProposer, copyQueries));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return composite;
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map arguments, String description, String project, int flags) {
            return new JDTCopyRefactoringDescriptor(this.getReorgExecutionLog(), this.getProcessorId(), project, description, comment.asString(), arguments, flags);
        }

        protected String getDescriptionPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_roots_plural;
        }

        protected String getDescriptionSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_roots_singular;
        }

        protected String getHeaderPattern() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_roots_header;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            CopyArguments javaArgs = new CopyArguments((Object)this.getDestinationJavaProject(), this.fReorgExecutionLog);
            CopyArguments resourceArgs = new CopyArguments((Object)this.getDestinationJavaProject().getProject(), this.fReorgExecutionLog);
            IPackageFragmentRoot[] roots = this.getRoots();
            int i = 0;
            while (i < roots.length) {
                this.fModifications.copy(roots[i], javaArgs, resourceArgs);
                ++i;
            }
            return this.fModifications;
        }

        public String getPolicyId() {
            return POLICY_COPY_ROOTS;
        }

        protected String getProcessorId() {
            return "org.eclipse.wst.jsdt.ui.copy";
        }

        protected String getRefactoringId() {
            return "org.eclipse.wst.jsdt.ui.copy";
        }

        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }
    }

    private static final class CopyPackagesPolicy
    extends PackagesReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private static final String POLICY_COPY_PACKAGES = "org.eclipse.wst.jsdt.ui.copyPackages";
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        public CopyPackagesPolicy(IPackageFragment[] packageFragments) {
            super(packageFragments);
        }

        private Change createChange(IPackageFragment pack, IPackageFragmentRoot destination, NewNameProposer nameProposer, INewNameQueries copyQueries) {
            String newName = nameProposer.createNewName(pack, destination);
            if (newName == null || JavaConventions.validatePackageName((String)newName).getSeverity() < 4) {
                INewNameQuery nameQuery = newName == null ? copyQueries.createNullQuery() : copyQueries.createNewPackageNameQuery(pack, newName);
                return new CopyPackageChange(pack, destination, nameQuery);
            }
            if (destination.getResource() instanceof IContainer) {
                IContainer dest = (IContainer)destination.getResource();
                IResource res = pack.getResource();
                INewNameQuery nameQuery = copyQueries.createNewResourceNameQuery(res, newName);
                return new CopyResourceChange(res, dest, nameQuery);
            }
            return new NullChange();
        }

        public Change createChange(IProgressMonitor pm, INewNameQueries newNameQueries) throws JavaModelException {
            NewNameProposer nameProposer = new NewNameProposer();
            IPackageFragment[] fragments = this.getPackages();
            pm.beginTask("", fragments.length);
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_copy_package);
            composite.markAsSynthetic();
            IPackageFragmentRoot root = this.getDestinationAsPackageFragmentRoot();
            int i = 0;
            while (i < fragments.length) {
                composite.add(this.createChange(fragments[i], root, nameProposer, newNameQueries));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return composite;
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map arguments, String description, String project, int flags) {
            return new JDTCopyRefactoringDescriptor(this.getReorgExecutionLog(), this.getProcessorId(), project, description, comment.asString(), arguments, flags);
        }

        protected String getDescriptionPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_packages_plural;
        }

        protected String getDescriptionSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_package_singular;
        }

        protected String getHeaderPattern() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_packages_header;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            IPackageFragmentRoot destination = this.getDestinationAsPackageFragmentRoot();
            CopyArguments javaArgs = new CopyArguments((Object)destination, this.fReorgExecutionLog);
            CopyArguments resourceArgs = new CopyArguments((Object)destination.getResource(), this.fReorgExecutionLog);
            IPackageFragment[] packages = this.getPackages();
            int i = 0;
            while (i < packages.length) {
                this.fModifications.copy(packages[i], javaArgs, resourceArgs);
                ++i;
            }
            return this.fModifications;
        }

        public String getPolicyId() {
            return POLICY_COPY_PACKAGES;
        }

        protected String getProcessorId() {
            return "org.eclipse.wst.jsdt.ui.copy";
        }

        protected String getRefactoringId() {
            return "org.eclipse.wst.jsdt.ui.copy";
        }

        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }
    }

    private static final class CopySubCuElementsPolicy
    extends SubCuElementReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private static final String POLICY_COPY_MEMBERS = "org.eclipse.wst.jsdt.ui.copyMembers";
        private CopyModifications fModifications;
        private ReorgExecutionLog fReorgExecutionLog;

        CopySubCuElementsPolicy(IJavaElement[] javaElements) {
            super(javaElements);
        }

        public boolean canEnable() throws JavaModelException {
            return super.canEnable() && (this.getSourceCu() != null || this.getSourceClassFile() != null);
        }

        public Change createChange(IProgressMonitor pm, INewNameQueries copyQueries) throws JavaModelException {
            try {
                CompilationUnit sourceCuNode = this.createSourceCuNode();
                ICompilationUnit targetCu = this.getDestinationCu();
                CompilationUnitRewrite targetRewriter = new CompilationUnitRewrite(targetCu);
                IJavaElement[] javaElements = this.getJavaElements();
                int i = 0;
                while (i < javaElements.length) {
                    this.copyToDestination(javaElements[i], targetRewriter, sourceCuNode, targetRewriter.getRoot());
                    ++i;
                }
                return CopySubCuElementsPolicy.createCompilationUnitChange(targetCu, targetRewriter);
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map arguments, String description, String project, int flags) {
            return new JDTCopyRefactoringDescriptor(this.getReorgExecutionLog(), this.getProcessorId(), project, description, comment.asString(), arguments, flags);
        }

        private CompilationUnit createSourceCuNode() {
            Assert.isTrue((this.getSourceCu() != null || this.getSourceClassFile() != null ? 1 : 0) != 0);
            Assert.isTrue((this.getSourceCu() == null || this.getSourceClassFile() == null ? 1 : 0) != 0);
            ASTParser parser = ASTParser.newParser((int)3);
            if (this.getSourceCu() != null) {
                parser.setSource(this.getSourceCu());
            } else {
                parser.setSource(this.getSourceClassFile());
            }
            return (CompilationUnit)parser.createAST(null);
        }

        public IFile[] getAllModifiedFiles() {
            return ReorgUtils.getFiles(new IResource[]{ReorgUtils.getResource((IJavaElement)this.getDestinationCu())});
        }

        protected String getDescriptionPlural() {
            int kind = this.getContentKind();
            switch (kind) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_types;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_fields;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_methods;
                }
                case 3: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_initializers;
                }
                case 4: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_package_declarations;
                }
                case 5: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_import_containers;
                }
                case 6: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_imports;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_move_elements_plural;
        }

        protected String getDescriptionSingular() {
            int kind = this.getContentKind();
            switch (kind) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_type;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_field;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_method;
                }
                case 3: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_initializer;
                }
                case 4: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_package;
                }
                case 5: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_import_section;
                }
                case 6: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_copy_import;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_elements_singular;
        }

        protected String getHeaderPattern() {
            return RefactoringCoreMessages.ReorgPolicyFactory_copy_elements_header;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new CopyModifications();
            this.fReorgExecutionLog = new ReorgExecutionLog();
            CopyArguments args = new CopyArguments((Object)this.getJavaElementDestination(), this.fReorgExecutionLog);
            IJavaElement[] javaElements = this.getJavaElements();
            int i = 0;
            while (i < javaElements.length) {
                this.fModifications.copy(javaElements[i], args, null);
                ++i;
            }
            return this.fModifications;
        }

        public String getPolicyId() {
            return POLICY_COPY_MEMBERS;
        }

        protected String getProcessorId() {
            return "org.eclipse.wst.jsdt.ui.copy";
        }

        protected String getRefactoringId() {
            return "org.eclipse.wst.jsdt.ui.copy";
        }

        public ReorgExecutionLog getReorgExecutionLog() {
            return this.fReorgExecutionLog;
        }

        private IClassFile getSourceClassFile() {
            return (IClassFile)this.getJavaElements()[0].getAncestor(6);
        }
    }

    private static abstract class FilesFoldersAndCusReorgPolicy
    extends ReorgPolicy {
        protected static final int ONLY_CUS = 2;
        protected static final int ONLY_FILES = 1;
        protected static final int ONLY_FOLDERS = 0;
        private ICompilationUnit[] fCus;
        private IFile[] fFiles;
        private IFolder[] fFolders;

        private static IContainer getAsContainer(IResource resDest) {
            if (resDest instanceof IContainer) {
                return (IContainer)resDest;
            }
            if (resDest instanceof IFile) {
                return ((IFile)resDest).getParent();
            }
            return null;
        }

        public FilesFoldersAndCusReorgPolicy(IFile[] files, IFolder[] folders, ICompilationUnit[] cus) {
            this.fFiles = files;
            this.fFolders = folders;
            this.fCus = cus;
        }

        public boolean canChildrenBeDestinations(IJavaElement javaElement) {
            switch (javaElement.getElementType()) {
                case 1: 
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }

        public boolean canChildrenBeDestinations(IResource resource) {
            return resource instanceof IContainer;
        }

        public boolean canElementBeDestination(IJavaElement javaElement) {
            switch (javaElement.getElementType()) {
                case 4: {
                    return true;
                }
            }
            return false;
        }

        public boolean canElementBeDestination(IResource resource) {
            return resource instanceof IProject || resource instanceof IFolder;
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            RefactoringStatus status = super.checkFinalConditions(pm, context, reorgQueries);
            this.confirmOverwriting(reorgQueries);
            return status;
        }

        private void confirmOverwriting(IReorgQueries reorgQueries) {
            OverwriteHelper helper = new OverwriteHelper();
            helper.setFiles(this.fFiles);
            helper.setFolders(this.fFolders);
            helper.setCus(this.fCus);
            IPackageFragment destPack = this.getDestinationAsPackageFragment();
            if (destPack != null) {
                helper.confirmOverwriting(reorgQueries, (IJavaElement)destPack);
            } else {
                IContainer destinationAsContainer = this.getDestinationAsContainer();
                if (destinationAsContainer != null) {
                    helper.confirmOverwriting(reorgQueries, (IResource)destinationAsContainer);
                }
            }
            this.fFiles = helper.getFilesWithoutUnconfirmedOnes();
            this.fFolders = helper.getFoldersWithoutUnconfirmedOnes();
            this.fCus = helper.getCusWithoutUnconfirmedOnes();
        }

        protected boolean containsLinkedResources() {
            return ReorgUtils.containsLinkedResources((IResource[])this.fFiles) || ReorgUtils.containsLinkedResources((IResource[])this.fFolders) || ReorgUtils.containsLinkedResources((IJavaElement[])this.fCus);
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map arguments, String description, String project, int flags) {
            return new JDTRefactoringDescriptor(this.getProcessorId(), project, description, comment.asString(), arguments, flags);
        }

        protected final int getContentKind() {
            int length = this.fCus.length + this.fFiles.length + this.fFolders.length;
            if (length == this.fCus.length) {
                return 2;
            }
            if (length == this.fFiles.length) {
                return 1;
            }
            if (length == this.fFolders.length) {
                return 0;
            }
            return -1;
        }

        protected final ICompilationUnit[] getCus() {
            return this.fCus;
        }

        public final ChangeDescriptor getDescriptor() {
            HashMap<String, String> arguments = new HashMap<String, String>();
            int length = this.fFiles.length + this.fFolders.length + this.fCus.length;
            String description = length == 1 ? this.getDescriptionSingular() : this.getDescriptionPlural();
            IProject resource = this.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String header = Messages.format(this.getHeaderPattern(), new String[]{String.valueOf(length), this.getDestinationLabel()});
            int flags = 589830;
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
            JDTRefactoringDescriptor descriptor = this.createRefactoringDescriptor(comment, arguments, description, project, flags);
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_POLICY, this.getPolicyId());
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_FILES, new Integer(this.fFiles.length).toString());
            int offset = 0;
            while (offset < this.fFiles.length) {
                arguments.put("element" + (offset + 1), descriptor.resourceToHandle((IResource)this.fFiles[offset]));
                ++offset;
            }
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_FOLDERS, new Integer(this.fFolders.length).toString());
            offset = 0;
            while (offset < this.fFolders.length) {
                arguments.put("element" + (offset + this.fFiles.length + 1), descriptor.resourceToHandle((IResource)this.fFolders[offset]));
                ++offset;
            }
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_UNITS, new Integer(this.fCus.length).toString());
            offset = 0;
            while (offset < this.fCus.length) {
                arguments.put("element" + (offset + this.fFolders.length + this.fFiles.length + 1), descriptor.elementToHandle((IJavaElement)this.fCus[offset]));
                ++offset;
            }
            arguments.putAll(this.getRefactoringArguments(project));
            return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
        }

        protected final IContainer getDestinationAsContainer() {
            IResource resDest = this.getResourceDestination();
            if (resDest != null) {
                return FilesFoldersAndCusReorgPolicy.getAsContainer(resDest);
            }
            IJavaElement jelDest = this.getJavaElementDestination();
            Assert.isNotNull((Object)jelDest);
            return FilesFoldersAndCusReorgPolicy.getAsContainer(ReorgUtils.getResource(jelDest));
        }

        protected final IPackageFragment getDestinationAsPackageFragment() {
            IPackageFragment javaAsPackage = this.getJavaDestinationAsPackageFragment(this.getJavaElementDestination());
            if (javaAsPackage != null) {
                return javaAsPackage;
            }
            return this.getResourceDestinationAsPackageFragment(this.getResourceDestination());
        }

        protected final IJavaElement getDestinationContainerAsJavaElement() {
            if (this.getJavaElementDestination() != null) {
                return this.getJavaElementDestination();
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer == null) {
                return null;
            }
            IJavaElement je = JavaCore.create((IResource)destinationAsContainer);
            if (je != null && je.exists()) {
                return je;
            }
            return null;
        }

        protected final IFile[] getFiles() {
            return this.fFiles;
        }

        protected final IFolder[] getFolders() {
            return this.fFolders;
        }

        private IPackageFragment getJavaDestinationAsPackageFragment(IJavaElement javaDest) {
            if (javaDest == null || this.fCheckDestination && !javaDest.exists()) {
                return null;
            }
            if (javaDest instanceof IPackageFragment) {
                return (IPackageFragment)javaDest;
            }
            if (javaDest instanceof IPackageFragmentRoot) {
                return ((IPackageFragmentRoot)javaDest).getPackageFragment("");
            }
            if (javaDest instanceof IJavaProject) {
                try {
                    IPackageFragmentRoot root = ReorgUtils.getCorrespondingPackageFragmentRoot((IJavaProject)javaDest);
                    if (root != null) {
                        return root.getPackageFragment("");
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            return (IPackageFragment)javaDest.getAncestor(4);
        }

        public final IJavaElement[] getJavaElements() {
            return this.fCus;
        }

        private IPackageFragment getResourceDestinationAsPackageFragment(IResource resource) {
            if (resource instanceof IFile) {
                return this.getJavaDestinationAsPackageFragment(JavaCore.create((IResource)resource.getParent()));
            }
            return null;
        }

        public final IResource[] getResources() {
            return ReorgUtils.union((IResource[])this.fFiles, (IResource[])this.fFolders);
        }

        private IProject getSingleProject() {
            IProject result = null;
            int index = 0;
            while (index < this.fFiles.length) {
                if (result == null) {
                    result = this.fFiles[index].getProject();
                } else if (!result.equals((Object)this.fFiles[index].getProject())) {
                    return null;
                }
                ++index;
            }
            index = 0;
            while (index < this.fFolders.length) {
                if (result == null) {
                    result = this.fFolders[index].getProject();
                } else if (!result.equals((Object)this.fFolders[index].getProject())) {
                    return null;
                }
                ++index;
            }
            index = 0;
            while (index < this.fCus.length) {
                if (result == null) {
                    result = this.fCus[index].getJavaProject().getProject();
                } else if (!result.equals((Object)this.fCus[index].getJavaProject().getProject())) {
                    return null;
                }
                ++index;
            }
            return result;
        }

        public RefactoringStatus initialize(RefactoringArguments arguments) {
            ArrayList<Object> elements;
            RefactoringStatus status = new RefactoringStatus();
            if (arguments instanceof JavaRefactoringArguments) {
                IResource resource;
                String attribute;
                JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
                int fileCount = 0;
                int folderCount = 0;
                int unitCount = 0;
                String value = extended.getAttribute(ReorgPolicyFactory.ATTRIBUTE_FILES);
                if (value != null && !"".equals(value)) {
                    try {
                        fileCount = Integer.parseInt(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FILES));
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FILES));
                }
                value = extended.getAttribute(ReorgPolicyFactory.ATTRIBUTE_FOLDERS);
                if (value != null && !"".equals(value)) {
                    try {
                        folderCount = Integer.parseInt(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FOLDERS));
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FOLDERS));
                }
                value = extended.getAttribute(ReorgPolicyFactory.ATTRIBUTE_UNITS);
                if (value != null && !"".equals(value)) {
                    try {
                        unitCount = Integer.parseInt(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_UNITS));
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_UNITS));
                }
                String handle = null;
                elements = new ArrayList<Object>();
                int index = 0;
                while (index < fileCount) {
                    attribute = "element" + (index + 1);
                    handle = extended.getAttribute(attribute);
                    if (handle != null && !"".equals(handle)) {
                        resource = JDTRefactoringDescriptor.handleToResource(extended.getProject(), handle);
                        if (resource == null || !resource.exists()) {
                            status.merge(ScriptableRefactoring.createInputWarningStatus(resource, this.getProcessorId(), this.getRefactoringId()));
                        } else {
                            elements.add(resource);
                        }
                    } else {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                    }
                    ++index;
                }
                this.fFiles = elements.toArray(new IFile[elements.size()]);
                elements = new ArrayList();
                index = 0;
                while (index < folderCount) {
                    attribute = "element" + (fileCount + index + 1);
                    handle = extended.getAttribute(attribute);
                    if (handle != null && !"".equals(handle)) {
                        resource = JDTRefactoringDescriptor.handleToResource(extended.getProject(), handle);
                        if (resource == null || !resource.exists()) {
                            status.merge(ScriptableRefactoring.createInputWarningStatus(resource, this.getProcessorId(), this.getRefactoringId()));
                        } else {
                            elements.add(resource);
                        }
                    } else {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                    }
                    ++index;
                }
                this.fFolders = elements.toArray(new IFolder[elements.size()]);
                elements = new ArrayList();
                index = 0;
                while (index < unitCount) {
                    attribute = "element" + (folderCount + fileCount + index + 1);
                    handle = extended.getAttribute(attribute);
                    if (handle != null && !"".equals(handle)) {
                        IJavaElement element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                        if (element == null || !element.exists() || element.getElementType() != 5) {
                            status.merge(ScriptableRefactoring.createInputWarningStatus(element, this.getProcessorId(), this.getRefactoringId()));
                        } else {
                            elements.add(element);
                        }
                    } else {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                    }
                    ++index;
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
            }
            this.fCus = elements.toArray(new ICompilationUnit[elements.size()]);
            status.merge(super.initialize(arguments));
            return status;
        }

        private boolean isChildOfOrEqualToAnyFolder(IResource resource) {
            int i = 0;
            while (i < this.fFolders.length) {
                IFolder folder = this.fFolders[i];
                if (folder.equals((Object)resource) || ParentChecker.isDescendantOf(resource, (IResource)folder)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            IOpenable openable;
            Assert.isNotNull((Object)javaElement);
            if (!this.fCheckDestination) {
                return new RefactoringStatus();
            }
            if (!javaElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_doesnotexist0);
            }
            if (javaElement instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            if (javaElement.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_readonly);
            }
            if (!javaElement.isStructureKnown()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_structure);
            }
            if (javaElement instanceof IOpenable && !(openable = (IOpenable)javaElement).isConsistent()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_inconsistent);
            }
            if (javaElement instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)javaElement;
                if (root.isArchive()) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_archive);
                }
                if (root.isExternal()) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_external);
                }
            }
            if (ReorgUtils.isInsideCompilationUnit(javaElement)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer == null || this.isChildOfOrEqualToAnyFolder((IResource)destinationAsContainer)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.containsLinkedResources() && !ReorgUtils.canBeDestinationForLinkedResources(javaElement)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_linked);
            }
            return new RefactoringStatus();
        }

        protected RefactoringStatus verifyDestination(IResource resource) throws JavaModelException {
            Assert.isNotNull((Object)resource);
            if (!resource.exists() || resource.isPhantom()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_phantom);
            }
            if (!resource.isAccessible()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_inaccessible);
            }
            if (resource.getType() == 8) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.isChildOfOrEqualToAnyFolder(resource)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_not_this_resource);
            }
            if (this.containsLinkedResources() && !ReorgUtils.canBeDestinationForLinkedResources(resource)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_linked);
            }
            return new RefactoringStatus();
        }
    }

    private static final class MoveFilesFoldersAndCusPolicy
    extends FilesFoldersAndCusReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private static final String POLICY_MOVE_RESOURCES = "org.eclipse.wst.jsdt.ui.moveResources";
        private TextChangeManager fChangeManager;
        private CreateTargetExecutionLog fCreateTargetExecutionLog = new CreateTargetExecutionLog();
        private String fFilePatterns;
        private MoveModifications fModifications;
        private QualifiedNameSearchResult fQualifiedNameSearchResult = new QualifiedNameSearchResult();
        private boolean fUpdateQualifiedNames = false;
        private boolean fUpdateReferences = true;

        private static Change moveCuToPackage(ICompilationUnit cu, IPackageFragment dest) {
            IResource resource = cu.getResource();
            if (resource != null && resource.isLinked() && ResourceUtil.getResource(dest) instanceof IContainer) {
                return MoveFilesFoldersAndCusPolicy.moveFileToContainer(cu, (IContainer)ResourceUtil.getResource(dest));
            }
            return new MoveCompilationUnitChange(cu, dest);
        }

        private static Change moveFileToContainer(ICompilationUnit cu, IContainer dest) {
            return new MoveResourceChange(cu.getResource(), dest);
        }

        MoveFilesFoldersAndCusPolicy(IFile[] files, IFolder[] folders, ICompilationUnit[] cus) {
            super(files, folders, cus);
        }

        public boolean canEnableQualifiedNameUpdating() {
            return this.getCus().length > 0 && !JavaElementUtil.isDefaultPackage(this.getCommonParent());
        }

        public boolean canEnableUpdateReferences() {
            return this.getCus().length > 0;
        }

        public boolean canUpdateQualifiedNames() {
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            return this.canEnableQualifiedNameUpdating() && pack != null && !pack.isDefaultPackage();
        }

        public boolean canUpdateReferences() {
            if (this.getCus().length == 0) {
                return false;
            }
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            if (pack != null && pack.isDefaultPackage()) {
                return false;
            }
            Object commonParent = this.getCommonParent();
            return !JavaElementUtil.isDefaultPackage(commonParent);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            RefactoringStatus refactoringStatus;
            try {
                try {
                    pm.beginTask("", this.fUpdateQualifiedNames ? 7 : 3);
                    RefactoringStatus result = new RefactoringStatus();
                    this.confirmMovingReadOnly(reorgQueries);
                    this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 2), result);
                    if (this.fUpdateQualifiedNames) {
                        this.computeQualifiedNameMatches((IProgressMonitor)new SubProgressMonitor(pm, 4));
                    }
                    result.merge(super.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, 1), context, reorgQueries));
                    refactoringStatus = result;
                    Object var5_8 = null;
                }
                catch (JavaModelException e) {
                    throw e;
                }
                catch (CoreException e) {
                    throw new JavaModelException(e);
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return refactoringStatus;
        }

        private void computeQualifiedNameMatches(IProgressMonitor pm) throws JavaModelException {
            if (!this.fUpdateQualifiedNames) {
                return;
            }
            IPackageFragment destination = this.getDestinationAsPackageFragment();
            if (destination != null) {
                ICompilationUnit[] cus = this.getCus();
                pm.beginTask("", cus.length);
                pm.subTask(RefactoringCoreMessages.MoveRefactoring_scanning_qualified_names);
                int i = 0;
                while (i < cus.length) {
                    ICompilationUnit cu = cus[i];
                    IType[] types = cu.getTypes();
                    SubProgressMonitor typesMonitor = new SubProgressMonitor(pm, 1);
                    typesMonitor.beginTask("", types.length);
                    int j = 0;
                    while (j < types.length) {
                        this.handleType(types[j], destination, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)typesMonitor, 1));
                        if (typesMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        ++j;
                    }
                    typesMonitor.done();
                    ++i;
                }
            }
            pm.done();
        }

        private void confirmMovingReadOnly(IReorgQueries reorgQueries) throws CoreException {
            if (!ReadOnlyResourceFinder.confirmMoveOfReadOnlyElements(this.getJavaElements(), this.getResources(), reorgQueries)) {
                throw new OperationCanceledException();
            }
        }

        private Change createChange(ICompilationUnit cu) {
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            if (pack != null) {
                return MoveFilesFoldersAndCusPolicy.moveCuToPackage(cu, pack);
            }
            IContainer container = this.getDestinationAsContainer();
            if (container == null) {
                return new NullChange();
            }
            return MoveFilesFoldersAndCusPolicy.moveFileToContainer(cu, container);
        }

        public Change createChange(IProgressMonitor pm) throws JavaModelException {
            if (!this.fUpdateReferences) {
                return this.createSimpleMoveChange(pm);
            }
            return this.createReferenceUpdatingMoveChange(pm);
        }

        private Change createChange(IResource res) {
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer == null) {
                return new NullChange();
            }
            return new MoveResourceChange(res, destinationAsContainer);
        }

        private TextChangeManager createChangeManager(IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
            block5: {
                block4: {
                    TextChangeManager textChangeManager;
                    pm.beginTask("", 1);
                    try {
                        if (this.fUpdateReferences) break block4;
                        textChangeManager = new TextChangeManager();
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        pm.done();
                        throw throwable;
                    }
                    pm.done();
                    return textChangeManager;
                }
                IPackageFragment packageDest = this.getDestinationAsPackageFragment();
                if (packageDest == null) break block5;
                MoveCuUpdateCreator creator = new MoveCuUpdateCreator(this.getCus(), packageDest);
                TextChangeManager textChangeManager = creator.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), status);
                Object var5_7 = null;
                pm.done();
                return textChangeManager;
            }
            TextChangeManager textChangeManager = new TextChangeManager();
            Object var5_8 = null;
            pm.done();
            return textChangeManager;
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map arguments, String description, String project, int flags) {
            return new JDTMoveRefactoringDescriptor(this.getCreateTargetExecutionLog(), this.getProcessorId(), project, description, comment.asString(), arguments, flags);
        }

        private Change createReferenceUpdatingMoveChange(IProgressMonitor pm) throws JavaModelException {
            DynamicValidationStateChange dynamicValidationStateChange;
            pm.beginTask("", 2 + (this.fUpdateQualifiedNames ? 1 : 0));
            try {
                DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move);
                composite.markAsSynthetic();
                if (this.fChangeManager == null) {
                    this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), new RefactoringStatus());
                    RefactoringStatus status = Checks.validateModifiesFiles(this.getAllModifiedFiles(), null);
                    if (status.hasFatalError()) {
                        this.fChangeManager = new TextChangeManager();
                    }
                }
                composite.merge(new CompositeChange(RefactoringCoreMessages.MoveRefactoring_reorganize_elements, (Change[])this.fChangeManager.getAllChanges()));
                Change fileMove = this.createSimpleMoveChange((IProgressMonitor)new SubProgressMonitor(pm, 1));
                if (fileMove instanceof CompositeChange) {
                    composite.merge((CompositeChange)fileMove);
                } else {
                    composite.add(fileMove);
                }
                dynamicValidationStateChange = composite;
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return dynamicValidationStateChange;
        }

        private Change createSimpleMoveChange(IProgressMonitor pm) {
            DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move);
            result.markAsSynthetic();
            IFile[] files = this.getFiles();
            IFolder[] folders = this.getFolders();
            ICompilationUnit[] cus = this.getCus();
            pm.beginTask("", files.length + folders.length + cus.length);
            int i = 0;
            while (i < files.length) {
                result.add(this.createChange((IResource)files[i]));
                pm.worked(1);
                ++i;
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            i = 0;
            while (i < folders.length) {
                result.add(this.createChange((IResource)folders[i]));
                pm.worked(1);
                ++i;
            }
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            i = 0;
            while (i < cus.length) {
                result.add(this.createChange(cus[i]));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return result;
        }

        public IFile[] getAllModifiedFiles() {
            HashSet<IFile> result = new HashSet<IFile>();
            result.addAll(Arrays.asList(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits())));
            result.addAll(Arrays.asList(this.fQualifiedNameSearchResult.getAllFiles()));
            if (this.getDestinationAsPackageFragment() != null && this.getUpdateReferences()) {
                result.addAll(Arrays.asList(ResourceUtil.getFiles(this.getCus())));
            }
            return result.toArray(new IFile[result.size()]);
        }

        private Object getCommonParent() {
            return new ParentChecker(this.getResources(), this.getJavaElements()).getCommonParent();
        }

        public CreateTargetExecutionLog getCreateTargetExecutionLog() {
            return this.fCreateTargetExecutionLog;
        }

        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return createQueries.createNewPackageQuery();
        }

        protected String getDescriptionPlural() {
            int kind = this.getContentKind();
            switch (kind) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_folders;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_files;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_compilation_units;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_move_description_plural;
        }

        protected String getDescriptionSingular() {
            int kind = this.getContentKind();
            switch (kind) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_folder;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_file;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_compilation_unit;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_move_description_singular;
        }

        public String getFilePatterns() {
            return this.fFilePatterns;
        }

        protected String getHeaderPattern() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_header;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            int i;
            boolean updateReferenes;
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new MoveModifications();
            IPackageFragment pack = this.getDestinationAsPackageFragment();
            IContainer container = this.getDestinationAsContainer();
            Object unitDestination = null;
            unitDestination = pack != null ? pack : container;
            boolean bl = updateReferenes = this.canUpdateReferences() && this.getUpdateReferences();
            if (unitDestination != null) {
                ICompilationUnit[] units = this.getCus();
                i = 0;
                while (i < units.length) {
                    this.fModifications.move(units[i], new MoveArguments(unitDestination, updateReferenes));
                    ++i;
                }
            }
            if (container != null) {
                IFile[] files = this.getFiles();
                i = 0;
                while (i < files.length) {
                    this.fModifications.move((IResource)files[i], new MoveArguments((Object)container, updateReferenes));
                    ++i;
                }
                IFolder[] folders = this.getFolders();
                int i2 = 0;
                while (i2 < folders.length) {
                    this.fModifications.move((IResource)folders[i2], new MoveArguments((Object)container, updateReferenes));
                    ++i2;
                }
            }
            return this.fModifications;
        }

        public String getPolicyId() {
            return POLICY_MOVE_RESOURCES;
        }

        protected String getProcessorId() {
            return "org.eclipse.wst.jsdt.ui.move";
        }

        protected Map getRefactoringArguments(String project) {
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.putAll(super.getRefactoringArguments(project));
            if (this.fFilePatterns != null && !"".equals(this.fFilePatterns)) {
                arguments.put(ReorgPolicyFactory.ATTRIBUTE_PATTERNS, this.fFilePatterns);
            }
            arguments.put("references", Boolean.valueOf(this.fUpdateReferences).toString());
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_QUALIFIED, Boolean.valueOf(this.fUpdateQualifiedNames).toString());
            return arguments;
        }

        protected String getRefactoringId() {
            return "org.eclipse.wst.jsdt.ui.move";
        }

        public boolean getUpdateQualifiedNames() {
            return this.fUpdateQualifiedNames;
        }

        public boolean getUpdateReferences() {
            return this.fUpdateReferences;
        }

        private void handleType(IType type, IPackageFragment destination, IProgressMonitor pm) {
            QualifiedNameFinder.process(this.fQualifiedNameSearchResult, type.getFullyQualifiedName(), String.valueOf(destination.getElementName()) + "." + type.getTypeQualifiedName(), this.fFilePatterns, type.getJavaProject().getProject(), pm);
        }

        public boolean hasAllInputSet() {
            return super.hasAllInputSet() && !this.canUpdateReferences() && !this.canUpdateQualifiedNames();
        }

        public RefactoringStatus initialize(RefactoringArguments arguments) {
            String qualified;
            if (arguments instanceof JavaRefactoringArguments) {
                JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
                String patterns = extended.getAttribute(ReorgPolicyFactory.ATTRIBUTE_PATTERNS);
                this.fFilePatterns = patterns != null && !"".equals(patterns) ? patterns : "";
                String references = extended.getAttribute("references");
                if (references == null) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
                }
                this.fUpdateReferences = Boolean.valueOf(references);
                qualified = extended.getAttribute(ReorgPolicyFactory.ATTRIBUTE_QUALIFIED);
                if (qualified == null) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_QUALIFIED));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
            }
            this.fUpdateQualifiedNames = Boolean.valueOf(qualified);
            return super.initialize(arguments);
        }

        public boolean isTextualMove() {
            return false;
        }

        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            if (this.fQualifiedNameSearchResult != null) {
                return this.fQualifiedNameSearchResult.getSingleChange(Changes.getModifiedFiles(participantChanges));
            }
            return null;
        }

        public void setDestinationCheck(boolean check) {
            this.fCheckDestination = check;
        }

        public void setFilePatterns(String patterns) {
            Assert.isNotNull((Object)patterns);
            this.fFilePatterns = patterns;
        }

        public void setUpdateQualifiedNames(boolean update) {
            this.fUpdateQualifiedNames = update;
        }

        public void setUpdateReferences(boolean update) {
            this.fUpdateReferences = update;
        }

        protected RefactoringStatus verifyDestination(IJavaElement destination) throws JavaModelException {
            RefactoringStatus superStatus = super.verifyDestination(destination);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            Object commonParent = new ParentChecker(this.getResources(), this.getJavaElements()).getCommonParent();
            if (destination.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer != null && destinationAsContainer.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IPackageFragment destinationAsPackage = this.getDestinationAsPackageFragment();
            if (destinationAsPackage != null && destinationAsPackage.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            return superStatus;
        }

        protected RefactoringStatus verifyDestination(IResource destination) throws JavaModelException {
            RefactoringStatus superStatus = super.verifyDestination(destination);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            Object commonParent = this.getCommonParent();
            if (destination.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IContainer destinationAsContainer = this.getDestinationAsContainer();
            if (destinationAsContainer != null && destinationAsContainer.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            IJavaElement destinationContainerAsPackage = this.getDestinationContainerAsJavaElement();
            if (destinationContainerAsPackage != null && destinationContainerAsPackage.equals(commonParent)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_parent);
            }
            return superStatus;
        }
    }

    private static final class MovePackageFragmentRootsPolicy
    extends PackageFragmentRootsReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private static final String POLICY_MOVE_ROOTS = "org.eclipse.wst.jsdt.ui.moveRoots";
        private CreateTargetExecutionLog fCreateTargetExecutionLog = new CreateTargetExecutionLog();
        private MoveModifications fModifications;

        private static boolean isParentOfAny(IJavaProject javaProject, IPackageFragmentRoot[] roots) {
            int i = 0;
            while (i < roots.length) {
                if (ReorgUtils.isParentInWorkspaceOrOnDisk(roots[i], javaProject)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        MovePackageFragmentRootsPolicy(IPackageFragmentRoot[] roots) {
            super(roots);
        }

        public boolean canEnable() throws JavaModelException {
            if (!super.canEnable()) {
                return false;
            }
            IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                ResourceAttributes attributes;
                if (roots[i].isReadOnly() && !roots[i].isArchive() && ((attributes = roots[i].getResource().getResourceAttributes()) == null || attributes.isReadOnly())) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            try {
                RefactoringStatus status = super.checkFinalConditions(pm, context, reorgQueries);
                this.confirmMovingReadOnly(reorgQueries);
                return status;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }

        private void confirmMovingReadOnly(IReorgQueries reorgQueries) throws CoreException {
            if (!ReadOnlyResourceFinder.confirmMoveOfReadOnlyElements(this.getJavaElements(), this.getResources(), reorgQueries)) {
                throw new OperationCanceledException();
            }
        }

        private Change createChange(IPackageFragmentRoot root, IJavaProject destination) {
            return new MovePackageFragmentRootChange(root, destination.getProject(), null);
        }

        public Change createChange(IProgressMonitor pm) throws JavaModelException {
            IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
            pm.beginTask("", roots.length);
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move_source_folder);
            composite.markAsSynthetic();
            IJavaProject destination = this.getDestinationJavaProject();
            Assert.isNotNull((Object)destination);
            int i = 0;
            while (i < roots.length) {
                composite.add(this.createChange(roots[i], destination));
                pm.worked(1);
                ++i;
            }
            pm.done();
            return composite;
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map arguments, String description, String project, int flags) {
            return new JDTMoveRefactoringDescriptor(this.getCreateTargetExecutionLog(), this.getProcessorId(), project, description, comment.asString(), arguments, flags);
        }

        public CreateTargetExecutionLog getCreateTargetExecutionLog() {
            return this.fCreateTargetExecutionLog;
        }

        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return null;
        }

        protected String getDescriptionPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_roots_plural;
        }

        protected String getDescriptionSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_roots_singular;
        }

        protected String getHeaderPattern() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_roots_header;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            boolean updateReferences;
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new MoveModifications();
            IJavaProject destination = this.getDestinationJavaProject();
            boolean bl = updateReferences = this.canUpdateReferences() && this.getUpdateReferences();
            if (destination != null) {
                IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    this.fModifications.move(roots[i], new MoveArguments((Object)destination, updateReferences));
                    ++i;
                }
            }
            return this.fModifications;
        }

        public String getPolicyId() {
            return POLICY_MOVE_ROOTS;
        }

        protected String getProcessorId() {
            return "org.eclipse.wst.jsdt.ui.move";
        }

        protected String getRefactoringId() {
            return "org.eclipse.wst.jsdt.ui.move";
        }

        public boolean isTextualMove() {
            return false;
        }

        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            return null;
        }

        public void setDestinationCheck(boolean check) {
            this.fCheckDestination = check;
        }

        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            RefactoringStatus superStatus = super.verifyDestination(javaElement);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            IJavaProject javaProject = this.getDestinationJavaProject();
            if (MovePackageFragmentRootsPolicy.isParentOfAny(javaProject, this.getPackageFragmentRoots())) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_element2parent);
            }
            return superStatus;
        }
    }

    private static final class MovePackagesPolicy
    extends PackagesReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private static final String POLICY_MOVE_PACKAGES = "org.eclipse.wst.jsdt.ui.movePackages";
        private CreateTargetExecutionLog fCreateTargetExecutionLog = new CreateTargetExecutionLog();
        private MoveModifications fModifications;

        private static boolean isParentOfAny(IPackageFragmentRoot root, IPackageFragment[] fragments) {
            int i = 0;
            while (i < fragments.length) {
                IPackageFragment fragment = fragments[i];
                if (ReorgUtils.isParentInWorkspaceOrOnDisk(fragment, root)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        MovePackagesPolicy(IPackageFragment[] packageFragments) {
            super(packageFragments);
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            try {
                RefactoringStatus status = super.checkFinalConditions(pm, context, reorgQueries);
                this.confirmMovingReadOnly(reorgQueries);
                return status;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }

        private void confirmMovingReadOnly(IReorgQueries reorgQueries) throws CoreException {
            if (!ReadOnlyResourceFinder.confirmMoveOfReadOnlyElements(this.getJavaElements(), this.getResources(), reorgQueries)) {
                throw new OperationCanceledException();
            }
        }

        private Change createChange(IPackageFragment pack, IPackageFragmentRoot destination) {
            return new MovePackageChange(pack, destination);
        }

        public Change createChange(IProgressMonitor pm) throws JavaModelException {
            IPackageFragment[] fragments = this.getPackages();
            pm.beginTask("", fragments.length);
            DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move_package);
            result.markAsSynthetic();
            IPackageFragmentRoot root = this.getDestinationAsPackageFragmentRoot();
            int i = 0;
            while (i < fragments.length) {
                result.add(this.createChange(fragments[i], root));
                pm.worked(1);
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++i;
            }
            pm.done();
            return result;
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map arguments, String description, String project, int flags) {
            return new JDTMoveRefactoringDescriptor(this.getCreateTargetExecutionLog(), this.getProcessorId(), project, description, comment.asString(), arguments, flags);
        }

        public CreateTargetExecutionLog getCreateTargetExecutionLog() {
            return this.fCreateTargetExecutionLog;
        }

        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return null;
        }

        protected String getDescriptionPlural() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_packages_plural;
        }

        protected String getDescriptionSingular() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_packages_singular;
        }

        protected String getHeaderPattern() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_packages_header;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            if (this.fModifications != null) {
                return this.fModifications;
            }
            this.fModifications = new MoveModifications();
            boolean updateReferences = this.canUpdateReferences() && this.getUpdateReferences();
            IPackageFragment[] packages = this.getPackages();
            IPackageFragmentRoot javaDestination = this.getDestinationAsPackageFragmentRoot();
            int i = 0;
            while (i < packages.length) {
                this.fModifications.move(packages[i], new MoveArguments((Object)javaDestination, updateReferences));
                ++i;
            }
            return this.fModifications;
        }

        public String getPolicyId() {
            return POLICY_MOVE_PACKAGES;
        }

        protected String getProcessorId() {
            return "org.eclipse.wst.jsdt.ui.move";
        }

        protected String getRefactoringId() {
            return "org.eclipse.wst.jsdt.ui.move";
        }

        public boolean isTextualMove() {
            return false;
        }

        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            return null;
        }

        public void setDestinationCheck(boolean check) {
            this.fCheckDestination = check;
        }

        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            RefactoringStatus superStatus = super.verifyDestination(javaElement);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            IPackageFragmentRoot root = this.getDestinationAsPackageFragmentRoot();
            if (MovePackagesPolicy.isParentOfAny(root, this.getPackages())) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_package2parent);
            }
            return superStatus;
        }
    }

    private static final class MoveSubCuElementsPolicy
    extends SubCuElementReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private static final String POLICY_MOVE_MEMBERS = "org.eclipse.wst.jsdt.ui.moveMembers";
        private CreateTargetExecutionLog fCreateTargetExecutionLog = new CreateTargetExecutionLog();

        MoveSubCuElementsPolicy(IJavaElement[] javaElements) {
            super(javaElements);
        }

        public boolean canEnable() throws JavaModelException {
            return super.canEnable() && this.getSourceCu() != null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Change createChange(IProgressMonitor pm) throws JavaModelException {
            DynamicValidationStateChange dynamicValidationStateChange;
            block13: {
                CompilationUnitChange compilationUnitChange;
                block12: {
                    pm.beginTask("", 3);
                    try {
                        try {
                            CompilationUnitChange targetCuChange;
                            CompilationUnitRewrite targetRewriter;
                            ICompilationUnit sourceCu = this.getSourceCu();
                            CompilationUnit sourceCuNode = RefactoringASTParser.parseWithASTProvider((ITypeRoot)sourceCu, false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                            CompilationUnitRewrite sourceRewriter = new CompilationUnitRewrite(sourceCu, sourceCuNode);
                            ICompilationUnit destinationCu = this.getDestinationCu();
                            if (sourceCu.equals(destinationCu)) {
                                targetRewriter = sourceRewriter;
                                pm.worked(1);
                            } else {
                                CompilationUnit destinationCuNode = RefactoringASTParser.parseWithASTProvider((ITypeRoot)destinationCu, false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                                targetRewriter = new CompilationUnitRewrite(destinationCu, destinationCuNode);
                            }
                            IJavaElement[] javaElements = this.getJavaElements();
                            int i = 0;
                            while (true) {
                                if (i >= javaElements.length) {
                                    ASTNodeDeleteUtil.markAsDeleted(javaElements, sourceRewriter, null);
                                    targetCuChange = MoveSubCuElementsPolicy.createCompilationUnitChange(destinationCu, targetRewriter);
                                    if (!sourceCu.equals(destinationCu)) break;
                                    compilationUnitChange = targetCuChange;
                                    Object var10_14 = null;
                                    break block12;
                                }
                                this.copyToDestination(javaElements[i], targetRewriter, sourceRewriter.getRoot(), targetRewriter.getRoot());
                                ++i;
                            }
                            DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.ReorgPolicy_move_members);
                            result.markAsSynthetic();
                            result.add((Change)targetCuChange);
                            if (Arrays.asList(this.getJavaElements()).containsAll(Arrays.asList(sourceCu.getTypes()))) {
                                result.add(DeleteChangeCreator.createDeleteChange(null, new IResource[0], (IJavaElement[])new ICompilationUnit[]{sourceCu}, RefactoringCoreMessages.ReorgPolicy_move, null));
                            } else {
                                result.add((Change)MoveSubCuElementsPolicy.createCompilationUnitChange(sourceCu, sourceRewriter));
                            }
                            dynamicValidationStateChange = result;
                            break block13;
                        }
                        catch (JavaModelException e) {
                            throw e;
                        }
                        catch (CoreException e) {
                            throw new JavaModelException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_16 = null;
                        pm.done();
                        throw throwable;
                    }
                }
                pm.done();
                return compilationUnitChange;
            }
            Object var10_15 = null;
            pm.done();
            return dynamicValidationStateChange;
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map arguments, String description, String project, int flags) {
            return new JDTMoveRefactoringDescriptor(this.getCreateTargetExecutionLog(), this.getProcessorId(), project, description, comment.asString(), arguments, flags);
        }

        public IFile[] getAllModifiedFiles() {
            return ReorgUtils.getFiles(new IResource[]{ReorgUtils.getResource((IJavaElement)this.getSourceCu()), ReorgUtils.getResource((IJavaElement)this.getDestinationCu())});
        }

        public CreateTargetExecutionLog getCreateTargetExecutionLog() {
            return this.fCreateTargetExecutionLog;
        }

        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return null;
        }

        protected String getDescriptionPlural() {
            int kind = this.getContentKind();
            switch (kind) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_types;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_fields;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_methods;
                }
                case 3: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_initializers;
                }
                case 4: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_package_declarations;
                }
                case 5: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_import_containers;
                }
                case 6: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_import_declarations;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_move_elements_plural;
        }

        protected String getDescriptionSingular() {
            int kind = this.getContentKind();
            switch (kind) {
                case 0: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_type;
                }
                case 1: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_field;
                }
                case 2: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_method;
                }
                case 3: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_initializer;
                }
                case 4: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_package_declaration;
                }
                case 5: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_import_section;
                }
                case 6: {
                    return RefactoringCoreMessages.ReorgPolicyFactory_move_import_declaration;
                }
            }
            return RefactoringCoreMessages.ReorgPolicyFactory_move_elements_singular;
        }

        protected String getHeaderPattern() {
            return RefactoringCoreMessages.ReorgPolicyFactory_move_elements_header;
        }

        public String getPolicyId() {
            return POLICY_MOVE_MEMBERS;
        }

        protected String getProcessorId() {
            return "org.eclipse.wst.jsdt.ui.move";
        }

        protected String getRefactoringId() {
            return "org.eclipse.wst.jsdt.ui.move";
        }

        public boolean isTextualMove() {
            return true;
        }

        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            return null;
        }

        public void setDestinationCheck(boolean check) {
            this.fCheckDestination = check;
        }

        protected RefactoringStatus verifyDestination(IJavaElement destination) throws JavaModelException {
            IJavaElement[] elements = this.getJavaElements();
            int i = 0;
            while (i < elements.length) {
                IJavaElement parent = destination.getParent();
                while (parent != null) {
                    if (parent.equals(elements[i])) {
                        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                    }
                    parent = parent.getParent();
                }
                ++i;
            }
            RefactoringStatus superStatus = super.verifyDestination(destination);
            if (superStatus.hasFatalError()) {
                return superStatus;
            }
            Object commonParent = new ParentChecker(new IResource[0], this.getJavaElements()).getCommonParent();
            if (destination.equals(commonParent) || Arrays.asList(this.getJavaElements()).contains(destination)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_element2parent);
            }
            return superStatus;
        }
    }

    private static final class NewNameProposer {
        private final Set fAutoGeneratedNewNames = new HashSet(2);

        private NewNameProposer() {
        }

        private static boolean isNewNameOk(IContainer container, String newName) {
            return container.findMember(newName) == null;
        }

        private static boolean isNewNameOk(IPackageFragment dest, String newName) {
            return !dest.getCompilationUnit(newName).exists();
        }

        private static boolean isNewNameOk(IPackageFragmentRoot root, String newName) {
            return !root.getPackageFragment(newName).exists();
        }

        public String createNewName(ICompilationUnit cu, IPackageFragment destination) {
            if (NewNameProposer.isNewNameOk(destination, cu.getElementName())) {
                return null;
            }
            if (!ReorgUtils.isParentInWorkspaceOrOnDisk(cu, destination)) {
                return null;
            }
            int i = 1;
            while (true) {
                String newName;
                if (NewNameProposer.isNewNameOk(destination, newName = i == 1 ? Messages.format(RefactoringCoreMessages.CopyRefactoring_cu_copyOf1, cu.getElementName()) : Messages.format(RefactoringCoreMessages.CopyRefactoring_cu_copyOfMore, new String[]{String.valueOf(i), cu.getElementName()})) && !this.fAutoGeneratedNewNames.contains(newName)) {
                    this.fAutoGeneratedNewNames.add(newName);
                    return JavaCore.removeJavaLikeExtension((String)newName);
                }
                ++i;
            }
        }

        public String createNewName(IPackageFragment pack, IPackageFragmentRoot destination) {
            if (NewNameProposer.isNewNameOk(destination, pack.getElementName())) {
                return null;
            }
            if (!ReorgUtils.isParentInWorkspaceOrOnDisk(pack, destination)) {
                return null;
            }
            int i = 1;
            while (true) {
                String newName;
                if (NewNameProposer.isNewNameOk(destination, newName = i == 1 ? Messages.format(RefactoringCoreMessages.CopyRefactoring_package_copyOf1, pack.getElementName()) : Messages.format(RefactoringCoreMessages.CopyRefactoring_package_copyOfMore, new String[]{String.valueOf(i), pack.getElementName()})) && !this.fAutoGeneratedNewNames.contains(newName)) {
                    this.fAutoGeneratedNewNames.add(newName);
                    return newName;
                }
                ++i;
            }
        }

        public String createNewName(IResource res, IContainer destination) {
            if (NewNameProposer.isNewNameOk(destination, res.getName())) {
                return null;
            }
            if (!ReorgUtils.isParentInWorkspaceOrOnDisk(res, (IResource)destination)) {
                return null;
            }
            int i = 1;
            while (true) {
                String newName;
                if (NewNameProposer.isNewNameOk(destination, newName = i == 1 ? Messages.format(RefactoringCoreMessages.CopyRefactoring_resource_copyOf1, res.getName()) : Messages.format(RefactoringCoreMessages.CopyRefactoring_resource_copyOfMore, new String[]{String.valueOf(i), res.getName()})) && !this.fAutoGeneratedNewNames.contains(newName)) {
                    this.fAutoGeneratedNewNames.add(newName);
                    return newName;
                }
                ++i;
            }
        }
    }

    private static final class NoCopyPolicy
    extends ReorgPolicy
    implements IReorgPolicy.ICopyPolicy {
        private NoCopyPolicy() {
        }

        public boolean canEnable() throws JavaModelException {
            return false;
        }

        public Change createChange(IProgressMonitor pm, INewNameQueries copyQueries) {
            return new NullChange();
        }

        protected String getDescriptionPlural() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        protected String getDescriptionSingular() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        public ChangeDescriptor getDescriptor() {
            return null;
        }

        protected String getHeaderPattern() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        public IJavaElement[] getJavaElements() {
            return new IJavaElement[0];
        }

        public String getPolicyId() {
            return ReorgPolicyFactory.NO_POLICY;
        }

        protected String getProcessorId() {
            return ReorgPolicyFactory.NO_ID;
        }

        protected String getRefactoringId() {
            return ReorgPolicyFactory.NO_ID;
        }

        public ReorgExecutionLog getReorgExecutionLog() {
            return null;
        }

        public IResource[] getResources() {
            return new IResource[0];
        }

        public RefactoringStatus initialize(RefactoringArguments arguments) {
            return new RefactoringStatus();
        }

        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noCopying);
        }

        protected RefactoringStatus verifyDestination(IResource resource) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noCopying);
        }
    }

    private static final class NoMovePolicy
    extends ReorgPolicy
    implements IReorgPolicy.IMovePolicy {
        private NoMovePolicy() {
        }

        public boolean canEnable() throws JavaModelException {
            return false;
        }

        public Change createChange(IProgressMonitor pm) {
            return new NullChange();
        }

        public CreateTargetExecutionLog getCreateTargetExecutionLog() {
            return new CreateTargetExecutionLog();
        }

        public ICreateTargetQuery getCreateTargetQuery(ICreateTargetQueries createQueries) {
            return null;
        }

        protected String getDescriptionPlural() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        protected String getDescriptionSingular() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        public ChangeDescriptor getDescriptor() {
            return null;
        }

        protected String getHeaderPattern() {
            return ReorgPolicyFactory.UNUSED_STRING;
        }

        public IJavaElement[] getJavaElements() {
            return new IJavaElement[0];
        }

        public String getPolicyId() {
            return ReorgPolicyFactory.NO_POLICY;
        }

        protected String getProcessorId() {
            return ReorgPolicyFactory.NO_ID;
        }

        protected String getRefactoringId() {
            return ReorgPolicyFactory.NO_ID;
        }

        public IResource[] getResources() {
            return new IResource[0];
        }

        public RefactoringStatus initialize(RefactoringArguments arguments) {
            return new RefactoringStatus();
        }

        public boolean isTextualMove() {
            return true;
        }

        public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
            return null;
        }

        public void setDestinationCheck(boolean check) {
            this.fCheckDestination = check;
        }

        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noMoving);
        }

        protected RefactoringStatus verifyDestination(IResource resource) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_noMoving);
        }
    }

    private static abstract class PackageFragmentRootsReorgPolicy
    extends ReorgPolicy {
        private IPackageFragmentRoot[] fPackageFragmentRoots;

        public PackageFragmentRootsReorgPolicy(IPackageFragmentRoot[] roots) {
            this.fPackageFragmentRoots = roots;
        }

        public boolean canChildrenBeDestinations(IJavaElement javaElement) {
            switch (javaElement.getElementType()) {
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        public boolean canChildrenBeDestinations(IResource resource) {
            return false;
        }

        public boolean canElementBeDestination(IJavaElement javaElement) {
            return javaElement.getElementType() == 2;
        }

        public boolean canElementBeDestination(IResource resource) {
            return false;
        }

        public boolean canEnable() throws JavaModelException {
            if (!super.canEnable()) {
                return false;
            }
            int i = 0;
            while (i < this.fPackageFragmentRoots.length) {
                if (!(ReorgUtils.isSourceFolder((IJavaElement)this.fPackageFragmentRoots[i]) || this.fPackageFragmentRoots[i].isArchive() && !this.fPackageFragmentRoots[i].isExternal())) {
                    return false;
                }
                ++i;
            }
            return !ReorgUtils.containsLinkedResources((IJavaElement[])this.fPackageFragmentRoots);
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            RefactoringStatus status = super.checkFinalConditions(pm, context, reorgQueries);
            this.confirmOverwriting(reorgQueries);
            return status;
        }

        private void confirmOverwriting(IReorgQueries reorgQueries) {
            OverwriteHelper oh = new OverwriteHelper();
            oh.setPackageFragmentRoots(this.fPackageFragmentRoots);
            IJavaProject javaProject = this.getDestinationJavaProject();
            oh.confirmOverwriting(reorgQueries, (IJavaElement)javaProject);
            this.fPackageFragmentRoots = oh.getPackageFragmentRootsWithoutUnconfirmedOnes();
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map arguments, String description, String project, int flags) {
            return new JDTRefactoringDescriptor(this.getProcessorId(), project, description, comment.asString(), arguments, flags);
        }

        public final ChangeDescriptor getDescriptor() {
            HashMap<String, String> arguments = new HashMap<String, String>();
            int length = this.fPackageFragmentRoots.length;
            String description = length == 1 ? this.getDescriptionSingular() : this.getDescriptionPlural();
            IProject resource = this.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String header = Messages.format(this.getHeaderPattern(), new String[]{String.valueOf(length), this.getDestinationLabel()});
            int flags = 6;
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
            JDTRefactoringDescriptor descriptor = this.createRefactoringDescriptor(comment, arguments, description, project, flags);
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_POLICY, this.getPolicyId());
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_ROOTS, new Integer(this.fPackageFragmentRoots.length).toString());
            int offset = 0;
            while (offset < this.fPackageFragmentRoots.length) {
                arguments.put("element" + (offset + 1), descriptor.elementToHandle((IJavaElement)this.fPackageFragmentRoots[offset]));
                ++offset;
            }
            arguments.putAll(this.getRefactoringArguments(project));
            return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
        }

        private IJavaProject getDestinationAsJavaProject(IJavaElement javaElementDestination) {
            if (javaElementDestination == null) {
                return null;
            }
            return javaElementDestination.getJavaProject();
        }

        protected IJavaProject getDestinationJavaProject() {
            return this.getDestinationAsJavaProject(this.getJavaElementDestination());
        }

        public IJavaElement[] getJavaElements() {
            return this.fPackageFragmentRoots;
        }

        protected IPackageFragmentRoot[] getPackageFragmentRoots() {
            return this.fPackageFragmentRoots;
        }

        public IResource[] getResources() {
            return new IResource[0];
        }

        public IPackageFragmentRoot[] getRoots() {
            return this.fPackageFragmentRoots;
        }

        private IProject getSingleProject() {
            IProject result = null;
            int index = 0;
            while (index < this.fPackageFragmentRoots.length) {
                if (result == null) {
                    result = this.fPackageFragmentRoots[index].getJavaProject().getProject();
                } else if (!result.equals((Object)this.fPackageFragmentRoots[index].getJavaProject().getProject())) {
                    return null;
                }
                ++index;
            }
            return result;
        }

        public RefactoringStatus initialize(RefactoringArguments arguments) {
            ArrayList<IJavaElement> elements;
            RefactoringStatus status = new RefactoringStatus();
            if (arguments instanceof JavaRefactoringArguments) {
                JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
                int rootCount = 0;
                String value = extended.getAttribute(ReorgPolicyFactory.ATTRIBUTE_ROOTS);
                if (value != null && !"".equals(value)) {
                    try {
                        rootCount = Integer.parseInt(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_ROOTS));
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_ROOTS));
                }
                String handle = null;
                elements = new ArrayList<IJavaElement>();
                int index = 0;
                while (index < rootCount) {
                    String attribute = "element" + (index + 1);
                    handle = extended.getAttribute(attribute);
                    if (handle != null && !"".equals(handle)) {
                        IJavaElement element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                        if (element == null || !element.exists() || element.getElementType() != 3) {
                            status.merge(ScriptableRefactoring.createInputWarningStatus(element, this.getProcessorId(), this.getRefactoringId()));
                        } else {
                            elements.add(element);
                        }
                    } else {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                    }
                    ++index;
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
            }
            this.fPackageFragmentRoots = elements.toArray(new IPackageFragmentRoot[elements.size()]);
            status.merge(super.initialize(arguments));
            return status;
        }

        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            Assert.isNotNull((Object)javaElement);
            if (!this.fCheckDestination) {
                return new RefactoringStatus();
            }
            if (!javaElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot1);
            }
            if (javaElement instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            if (!(javaElement instanceof IJavaProject) && !(javaElement instanceof IPackageFragmentRoot)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_src2proj);
            }
            if (javaElement.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_src2writable);
            }
            if (ReorgUtils.isPackageFragmentRoot(javaElement.getJavaProject())) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_src2nosrc);
            }
            return new RefactoringStatus();
        }

        protected RefactoringStatus verifyDestination(IResource resource) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_src2proj);
        }
    }

    private static abstract class PackagesReorgPolicy
    extends ReorgPolicy {
        private IPackageFragment[] fPackageFragments;

        public PackagesReorgPolicy(IPackageFragment[] packageFragments) {
            this.fPackageFragments = packageFragments;
        }

        public boolean canChildrenBeDestinations(IJavaElement javaElement) {
            switch (javaElement.getElementType()) {
                case 1: 
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }

        public boolean canChildrenBeDestinations(IResource resource) {
            return false;
        }

        public boolean canElementBeDestination(IJavaElement javaElement) {
            switch (javaElement.getElementType()) {
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }

        public boolean canElementBeDestination(IResource resource) {
            return false;
        }

        public boolean canEnable() throws JavaModelException {
            int i = 0;
            while (i < this.fPackageFragments.length) {
                if (JavaElementUtil.isDefaultPackage(this.fPackageFragments[i]) || this.fPackageFragments[i].isReadOnly()) {
                    return false;
                }
                ++i;
            }
            return !ReorgUtils.containsLinkedResources((IJavaElement[])this.fPackageFragments);
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            RefactoringStatus refactoringStatus = super.checkFinalConditions(pm, context, reorgQueries);
            this.confirmOverwriting(reorgQueries);
            return refactoringStatus;
        }

        private void confirmOverwriting(IReorgQueries reorgQueries) throws JavaModelException {
            OverwriteHelper helper = new OverwriteHelper();
            helper.setPackages(this.fPackageFragments);
            IPackageFragmentRoot destRoot = this.getDestinationAsPackageFragmentRoot();
            helper.confirmOverwriting(reorgQueries, (IJavaElement)destRoot);
            this.fPackageFragments = helper.getPackagesWithoutUnconfirmedOnes();
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map arguments, String description, String project, int flags) {
            return new JDTRefactoringDescriptor(this.getProcessorId(), project, description, comment.asString(), arguments, flags);
        }

        public final ChangeDescriptor getDescriptor() {
            HashMap<String, String> arguments = new HashMap<String, String>();
            int length = this.fPackageFragments.length;
            String description = length == 1 ? this.getDescriptionSingular() : this.getDescriptionPlural();
            IProject resource = this.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String header = Messages.format(this.getHeaderPattern(), new String[]{String.valueOf(length), this.getDestinationLabel()});
            int flags = 589830;
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
            JDTRefactoringDescriptor descriptor = this.createRefactoringDescriptor(comment, arguments, description, project, flags);
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_POLICY, this.getPolicyId());
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_FRAGMENTS, new Integer(this.fPackageFragments.length).toString());
            int offset = 0;
            while (offset < this.fPackageFragments.length) {
                arguments.put("element" + (offset + 1), descriptor.elementToHandle((IJavaElement)this.fPackageFragments[offset]));
                ++offset;
            }
            arguments.putAll(this.getRefactoringArguments(project));
            return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
        }

        protected IPackageFragmentRoot getDestinationAsPackageFragmentRoot() throws JavaModelException {
            return this.getDestinationAsPackageFragmentRoot(this.getJavaElementDestination());
        }

        private IPackageFragmentRoot getDestinationAsPackageFragmentRoot(IJavaElement javaElement) throws JavaModelException {
            IPackageFragment pack;
            if (javaElement == null) {
                return null;
            }
            if (javaElement instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)javaElement;
            }
            if (javaElement instanceof IPackageFragment && (pack = (IPackageFragment)javaElement).getParent() instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)pack.getParent();
            }
            if (javaElement instanceof IJavaProject) {
                return ReorgUtils.getCorrespondingPackageFragmentRoot((IJavaProject)javaElement);
            }
            return null;
        }

        public IJavaElement[] getJavaElements() {
            return this.fPackageFragments;
        }

        protected IPackageFragment[] getPackages() {
            return this.fPackageFragments;
        }

        public IResource[] getResources() {
            return new IResource[0];
        }

        private IProject getSingleProject() {
            IProject result = null;
            int index = 0;
            while (index < this.fPackageFragments.length) {
                if (result == null) {
                    result = this.fPackageFragments[index].getJavaProject().getProject();
                } else if (!result.equals((Object)this.fPackageFragments[index].getJavaProject().getProject())) {
                    return null;
                }
                ++index;
            }
            return result;
        }

        public RefactoringStatus initialize(RefactoringArguments arguments) {
            ArrayList<IJavaElement> elements;
            RefactoringStatus status = new RefactoringStatus();
            if (arguments instanceof JavaRefactoringArguments) {
                JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
                int fragmentCount = 0;
                String value = extended.getAttribute(ReorgPolicyFactory.ATTRIBUTE_FRAGMENTS);
                if (value != null && !"".equals(value)) {
                    try {
                        fragmentCount = Integer.parseInt(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FRAGMENTS));
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_FRAGMENTS));
                }
                String handle = null;
                elements = new ArrayList<IJavaElement>();
                int index = 0;
                while (index < fragmentCount) {
                    String attribute = "element" + (index + 1);
                    handle = extended.getAttribute(attribute);
                    if (handle != null && !"".equals(handle)) {
                        IJavaElement element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                        if (element == null || !element.exists() || element.getElementType() != 4) {
                            status.merge(ScriptableRefactoring.createInputWarningStatus(element, this.getProcessorId(), this.getRefactoringId()));
                        } else {
                            elements.add(element);
                        }
                    } else {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                    }
                    ++index;
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
            }
            this.fPackageFragments = elements.toArray(new IPackageFragment[elements.size()]);
            status.merge(super.initialize(arguments));
            return status;
        }

        protected RefactoringStatus verifyDestination(IJavaElement javaElement) throws JavaModelException {
            Assert.isNotNull((Object)javaElement);
            if (!this.fCheckDestination) {
                return new RefactoringStatus();
            }
            if (!javaElement.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot1);
            }
            if (javaElement instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            IPackageFragmentRoot destRoot = this.getDestinationAsPackageFragmentRoot(javaElement);
            if (!ReorgUtils.isSourceFolder((IJavaElement)destRoot)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_packages);
            }
            return new RefactoringStatus();
        }

        protected RefactoringStatus verifyDestination(IResource resource) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_packages);
        }
    }

    private static abstract class ReorgPolicy
    implements IReorgPolicy {
        private static final String ATTRIBUTE_DESTINATION = "destination";
        private static final String ATTRIBUTE_TARGET = "target";
        protected boolean fCheckDestination = true;
        private IJavaElement fJavaElementDestination;
        private IResource fResourceDestination;

        private ReorgPolicy() {
        }

        public boolean canChildrenBeDestinations(IJavaElement javaElement) {
            return true;
        }

        public boolean canChildrenBeDestinations(IResource resource) {
            return true;
        }

        public boolean canElementBeDestination(IJavaElement javaElement) {
            return true;
        }

        public boolean canElementBeDestination(IResource resource) {
            return true;
        }

        public boolean canEnable() throws JavaModelException {
            IResource[] resources = this.getResources();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (!resource.exists() || resource.isPhantom() || !resource.isAccessible()) {
                    return false;
                }
                ++i;
            }
            IJavaElement[] javaElements = this.getJavaElements();
            int i2 = 0;
            while (i2 < javaElements.length) {
                IJavaElement element = javaElements[i2];
                if (!element.exists()) {
                    return false;
                }
                ++i2;
            }
            return true;
        }

        public boolean canEnableQualifiedNameUpdating() {
            return false;
        }

        public boolean canEnableUpdateReferences() {
            return false;
        }

        public boolean canUpdateQualifiedNames() {
            Assert.isTrue((boolean)false);
            return false;
        }

        public boolean canUpdateReferences() {
            return false;
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, IReorgQueries reorgQueries) throws CoreException {
            Assert.isNotNull((Object)reorgQueries);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker((Class)clazz);
            IFile[] allModifiedFiles = this.getAllModifiedFiles();
            RefactoringModifications modifications = this.getModifications();
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            int i = 0;
            while (i < allModifiedFiles.length) {
                deltaFactory.change(allModifiedFiles[i]);
                ++i;
            }
            if (modifications != null) {
                modifications.buildDelta(deltaFactory);
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                modifications.buildValidateEdits((ValidateEditChecker)context.getChecker((Class)clazz2));
            }
            return new RefactoringStatus();
        }

        public IFile[] getAllModifiedFiles() {
            return new IFile[0];
        }

        protected abstract String getDescriptionPlural();

        protected abstract String getDescriptionSingular();

        protected String getDestinationLabel() {
            IJavaElement destination = this.getJavaElementDestination();
            if (destination == null) {
                destination = this.getResourceDestination();
            }
            return JavaElementLabels.getTextLabel(destination, JavaElementLabels.ALL_FULLY_QUALIFIED);
        }

        public String getFilePatterns() {
            Assert.isTrue((boolean)false);
            return null;
        }

        protected abstract String getHeaderPattern();

        public final IJavaElement getJavaElementDestination() {
            return this.fJavaElementDestination;
        }

        protected RefactoringModifications getModifications() throws CoreException {
            return null;
        }

        protected abstract String getProcessorId();

        protected Map getRefactoringArguments(String project) {
            HashMap<String, String> arguments = new HashMap<String, String>();
            IJavaElement element = this.getJavaElementDestination();
            if (element != null) {
                arguments.put(ATTRIBUTE_DESTINATION, JDTRefactoringDescriptor.elementToHandle(project, element));
            } else {
                IResource resource = this.getResourceDestination();
                if (resource != null) {
                    arguments.put(ATTRIBUTE_TARGET, JDTRefactoringDescriptor.resourceToHandle(null, resource));
                }
            }
            return arguments;
        }

        protected abstract String getRefactoringId();

        public final IResource getResourceDestination() {
            return this.fResourceDestination;
        }

        public boolean getUpdateQualifiedNames() {
            Assert.isTrue((boolean)false);
            return false;
        }

        public boolean getUpdateReferences() {
            Assert.isTrue((boolean)false);
            return false;
        }

        public boolean hasAllInputSet() {
            return this.fJavaElementDestination != null || this.fResourceDestination != null;
        }

        public RefactoringStatus initialize(RefactoringArguments arguments) {
            if (arguments instanceof JavaRefactoringArguments) {
                JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
                String handle = extended.getAttribute(ATTRIBUTE_DESTINATION);
                if (handle != null) {
                    IJavaElement element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                    if (element != null) {
                        if (this.fCheckDestination && !element.exists()) {
                            return ScriptableRefactoring.createInputFatalStatus(element, this.getProcessorId(), this.getRefactoringId());
                        }
                        try {
                            return this.setDestination(element);
                        }
                        catch (JavaModelException exception) {
                            JavaPlugin.log(exception);
                            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{handle, "input"}));
                        }
                    }
                    IResource resource = JDTRefactoringDescriptor.handleToResource(extended.getProject(), handle);
                    if (resource == null || this.fCheckDestination && !resource.exists()) {
                        return ScriptableRefactoring.createInputFatalStatus(resource, this.getProcessorId(), this.getRefactoringId());
                    }
                    try {
                        return this.setDestination(resource);
                    }
                    catch (JavaModelException exception) {
                        JavaPlugin.log(exception);
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{handle, "input"}));
                    }
                }
                handle = extended.getAttribute(ATTRIBUTE_TARGET);
                if (handle != null) {
                    IResource resource = JDTRefactoringDescriptor.handleToResource(null, handle);
                    if (resource == null || this.fCheckDestination && !resource.exists()) {
                        return ScriptableRefactoring.createInputFatalStatus(resource, this.getProcessorId(), this.getRefactoringId());
                    }
                    try {
                        return this.setDestination(resource);
                    }
                    catch (JavaModelException exception) {
                        JavaPlugin.log(exception);
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{handle, "input"}));
                    }
                }
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }

        public final RefactoringParticipant[] loadParticipants(RefactoringStatus status, RefactoringProcessor processor, String[] natures, SharableParticipants shared) throws CoreException {
            RefactoringModifications modifications = this.getModifications();
            if (modifications != null) {
                return modifications.loadParticipants(status, processor, natures, shared);
            }
            return new RefactoringParticipant[0];
        }

        public final RefactoringStatus setDestination(IJavaElement destination) throws JavaModelException {
            Assert.isNotNull((Object)destination);
            this.fJavaElementDestination = null;
            this.fResourceDestination = null;
            this.fJavaElementDestination = destination;
            return this.verifyDestination(destination);
        }

        public final RefactoringStatus setDestination(IResource destination) throws JavaModelException {
            Assert.isNotNull((Object)destination);
            this.fJavaElementDestination = null;
            this.fResourceDestination = null;
            this.fResourceDestination = destination;
            return this.verifyDestination(destination);
        }

        public void setFilePatterns(String patterns) {
            Assert.isTrue((boolean)false);
        }

        public void setUpdateQualifiedNames(boolean update) {
            Assert.isTrue((boolean)false);
        }

        public void setUpdateReferences(boolean update) {
            Assert.isTrue((boolean)false);
        }

        protected abstract RefactoringStatus verifyDestination(IJavaElement var1) throws JavaModelException;

        protected abstract RefactoringStatus verifyDestination(IResource var1) throws JavaModelException;
    }

    private static abstract class SubCuElementReorgPolicy
    extends ReorgPolicy {
        protected static final int ONLY_FIELDS = 1;
        protected static final int ONLY_IMPORT_CONTAINERS = 5;
        protected static final int ONLY_IMPORT_DECLARATIONS = 6;
        protected static final int ONLY_INITIALIZERS = 3;
        protected static final int ONLY_METHODS = 2;
        protected static final int ONLY_PACKAGE_DECLARATIONS = 4;
        protected static final int ONLY_TYPES = 0;
        private IJavaElement[] fJavaElements;

        protected static CompilationUnitChange createCompilationUnitChange(ICompilationUnit cu, CompilationUnitRewrite rewrite) throws CoreException {
            CompilationUnitChange change = rewrite.createChange();
            if (change != null && cu.isWorkingCopy()) {
                change.setSaveMode(4);
            }
            return change;
        }

        protected static final ICompilationUnit getDestinationCu(IJavaElement destination) {
            if (destination instanceof ICompilationUnit) {
                return (ICompilationUnit)destination;
            }
            return (ICompilationUnit)destination.getAncestor(5);
        }

        private static ICompilationUnit getEnclosingCu(IJavaElement destination) {
            if (destination instanceof ICompilationUnit) {
                return (ICompilationUnit)destination;
            }
            return (ICompilationUnit)destination.getAncestor(5);
        }

        private static IType getEnclosingType(IJavaElement destination) {
            if (destination instanceof IType) {
                return (IType)destination;
            }
            return (IType)destination.getAncestor(7);
        }

        private static String getUnindentedSource(ISourceReference sourceReference) throws JavaModelException {
            Assert.isTrue((boolean)(sourceReference instanceof IJavaElement));
            String[] lines = Strings.convertIntoLines(sourceReference.getSource());
            IJavaProject project = ((IJavaElement)sourceReference).getJavaProject();
            Strings.trimIndentation(lines, project, false);
            return Strings.concatenate(lines, StubUtility.getLineDelimiterUsed((IJavaElement)sourceReference));
        }

        SubCuElementReorgPolicy(IJavaElement[] javaElements) {
            this.fJavaElements = javaElements;
        }

        public boolean canChildrenBeDestinations(IResource resource) {
            return false;
        }

        public boolean canElementBeDestination(IResource resource) {
            return false;
        }

        public boolean canEnable() throws JavaModelException {
            if (!super.canEnable()) {
                return false;
            }
            int i = 0;
            while (i < this.fJavaElements.length) {
                IMember member;
                if (this.fJavaElements[i] instanceof IMember && (member = (IMember)this.fJavaElements[i]).isBinary() && member.getSourceRange() == null) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private void copyImportsToDestination(IImportContainer container, ASTRewrite rewrite, CompilationUnit sourceCuNode, CompilationUnit destinationCuNode) throws JavaModelException {
            IJavaElement[] importDeclarations = container.getChildren();
            int i = 0;
            while (i < importDeclarations.length) {
                Assert.isTrue((boolean)(importDeclarations[i] instanceof IImportDeclaration));
                IImportDeclaration importDeclaration = (IImportDeclaration)importDeclarations[i];
                this.copyImportToDestination(importDeclaration, rewrite, sourceCuNode, destinationCuNode);
                ++i;
            }
        }

        private void copyImportToDestination(IImportDeclaration declaration, ASTRewrite targetRewrite, CompilationUnit sourceCuNode, CompilationUnit destinationCuNode) throws JavaModelException {
            ImportDeclaration sourceNode = ASTNodeSearchUtil.getImportDeclarationNode(declaration, sourceCuNode);
            ImportDeclaration copiedNode = (ImportDeclaration)ASTNode.copySubtree((AST)targetRewrite.getAST(), (ASTNode)sourceNode);
            targetRewrite.getListRewrite((ASTNode)destinationCuNode, CompilationUnit.IMPORTS_PROPERTY).insertLast((ASTNode)copiedNode, null);
        }

        private void copyInitializerToDestination(IInitializer initializer, CompilationUnitRewrite targetRewriter, CompilationUnit sourceCuNode, CompilationUnit targetCuNode) throws JavaModelException {
            BodyDeclaration newInitializer = (BodyDeclaration)targetRewriter.getASTRewrite().createStringPlaceholder(SubCuElementReorgPolicy.getUnindentedSource((ISourceReference)initializer), 28);
            this.copyMemberToDestination((IMember)initializer, targetRewriter, sourceCuNode, targetCuNode, newInitializer);
        }

        private void copyMemberToDestination(IMember member, CompilationUnitRewrite targetRewriter, CompilationUnit sourceCuNode, CompilationUnit targetCuNode, BodyDeclaration newMember) throws JavaModelException {
            BodyDeclaration decl;
            ASTNode destinationContainer;
            Initializer nodeDestination;
            IJavaElement javaElementDestination = this.getJavaElementDestination();
            switch (javaElementDestination.getElementType()) {
                case 10: {
                    nodeDestination = ASTNodeSearchUtil.getInitializerNode((IInitializer)javaElementDestination, targetCuNode);
                    destinationContainer = nodeDestination.getParent();
                    break;
                }
                case 8: {
                    nodeDestination = ASTNodeSearchUtil.getFieldOrEnumConstantDeclaration((IField)javaElementDestination, targetCuNode);
                    destinationContainer = nodeDestination.getParent();
                    break;
                }
                case 9: {
                    nodeDestination = ASTNodeSearchUtil.getMethodOrAnnotationTypeMemberDeclarationNode((IMethod)javaElementDestination, targetCuNode);
                    destinationContainer = nodeDestination.getParent();
                    break;
                }
                case 7: {
                    nodeDestination = null;
                    IType typeDestination = (IType)javaElementDestination;
                    if (typeDestination.isAnonymous()) {
                        destinationContainer = ASTNodeSearchUtil.getClassInstanceCreationNode(typeDestination, targetCuNode).getAnonymousClassDeclaration();
                        break;
                    }
                    destinationContainer = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(typeDestination, targetCuNode);
                    break;
                }
                default: {
                    nodeDestination = null;
                    destinationContainer = null;
                }
            }
            if (!(member instanceof IInitializer) && (decl = ASTNodeSearchUtil.getBodyDeclarationNode(member, sourceCuNode)) != null) {
                ImportRewriteUtil.addImports(targetRewriter, (ASTNode)decl, new HashMap(), new HashMap(), false);
            }
            if (destinationContainer != null) {
                ListRewrite listRewrite = destinationContainer instanceof AbstractTypeDeclaration ? (newMember instanceof EnumConstantDeclaration && destinationContainer instanceof EnumDeclaration ? targetRewriter.getASTRewrite().getListRewrite(destinationContainer, EnumDeclaration.ENUM_CONSTANTS_PROPERTY) : targetRewriter.getASTRewrite().getListRewrite(destinationContainer, ((AbstractTypeDeclaration)destinationContainer).getBodyDeclarationsProperty())) : targetRewriter.getASTRewrite().getListRewrite(destinationContainer, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
                if (nodeDestination != null) {
                    List list = listRewrite.getOriginalList();
                    int index = list.indexOf(nodeDestination);
                    if (index > 0 && index < list.size() - 1) {
                        listRewrite.insertBefore((ASTNode)newMember, (ASTNode)list.get(index), null);
                    } else {
                        listRewrite.insertLast((ASTNode)newMember, null);
                    }
                } else {
                    listRewrite.insertAt((ASTNode)newMember, ASTNodes.getInsertionIndex(newMember, listRewrite.getRewrittenList()), null);
                }
                return;
            }
            AbstractTypeDeclaration declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(this.getDestinationAsType(), targetCuNode);
            targetRewriter.getASTRewrite().getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertLast((ASTNode)newMember, null);
        }

        private void copyMethodToDestination(IMethod method, CompilationUnitRewrite targetRewriter, CompilationUnit sourceCuNode, CompilationUnit targetCuNode) throws JavaModelException {
            BodyDeclaration newMethod = (BodyDeclaration)targetRewriter.getASTRewrite().createStringPlaceholder(SubCuElementReorgPolicy.getUnindentedSource((ISourceReference)method), 31);
            this.copyMemberToDestination((IMember)method, targetRewriter, sourceCuNode, targetCuNode, newMethod);
        }

        private void copyPackageDeclarationToDestination(IPackageDeclaration declaration, ASTRewrite targetRewrite, CompilationUnit sourceCuNode, CompilationUnit destinationCuNode) throws JavaModelException {
            if (destinationCuNode.getPackage() != null) {
                return;
            }
            PackageDeclaration sourceNode = ASTNodeSearchUtil.getPackageDeclarationNode(declaration, sourceCuNode);
            PackageDeclaration copiedNode = (PackageDeclaration)ASTNode.copySubtree((AST)targetRewrite.getAST(), (ASTNode)sourceNode);
            targetRewrite.set((ASTNode)destinationCuNode, (StructuralPropertyDescriptor)CompilationUnit.PACKAGE_PROPERTY, (Object)copiedNode, null);
        }

        protected void copyToDestination(IJavaElement element, CompilationUnitRewrite targetRewriter, CompilationUnit sourceCuNode, CompilationUnit targetCuNode) throws CoreException {
            ASTRewrite rewrite = targetRewriter.getASTRewrite();
            switch (element.getElementType()) {
                case 8: {
                    this.copyMemberToDestination((IMember)element, targetRewriter, sourceCuNode, targetCuNode, this.createNewFieldDeclarationNode((IField)element, rewrite, sourceCuNode));
                    break;
                }
                case 12: {
                    this.copyImportsToDestination((IImportContainer)element, rewrite, sourceCuNode, targetCuNode);
                    break;
                }
                case 13: {
                    this.copyImportToDestination((IImportDeclaration)element, rewrite, sourceCuNode, targetCuNode);
                    break;
                }
                case 10: {
                    this.copyInitializerToDestination((IInitializer)element, targetRewriter, sourceCuNode, targetCuNode);
                    break;
                }
                case 9: {
                    this.copyMethodToDestination((IMethod)element, targetRewriter, sourceCuNode, targetCuNode);
                    break;
                }
                case 11: {
                    this.copyPackageDeclarationToDestination((IPackageDeclaration)element, rewrite, sourceCuNode, targetCuNode);
                    break;
                }
                case 7: {
                    this.copyTypeToDestination((IType)element, targetRewriter, sourceCuNode, targetCuNode);
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false);
                }
            }
        }

        private void copyTypeToDestination(IType type, CompilationUnitRewrite targetRewriter, CompilationUnit sourceCuNode, CompilationUnit targetCuNode) throws JavaModelException {
            AbstractTypeDeclaration newType = (AbstractTypeDeclaration)targetRewriter.getASTRewrite().createStringPlaceholder(SubCuElementReorgPolicy.getUnindentedSource((ISourceReference)type), 55);
            IType enclosingType = SubCuElementReorgPolicy.getEnclosingType(this.getJavaElementDestination());
            if (enclosingType != null) {
                this.copyMemberToDestination((IMember)type, targetRewriter, sourceCuNode, targetCuNode, (BodyDeclaration)newType);
            } else {
                targetRewriter.getASTRewrite().getListRewrite((ASTNode)targetCuNode, CompilationUnit.TYPES_PROPERTY).insertLast((ASTNode)newType, null);
            }
        }

        /*
         * Exception decompiling
         */
        private BodyDeclaration createNewFieldDeclarationNode(IField field, ASTRewrite rewrite, CompilationUnit sourceCuNode) throws CoreException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 340->343)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected JDTRefactoringDescriptor createRefactoringDescriptor(JDTRefactoringDescriptorComment comment, Map arguments, String description, String project, int flags) {
            return new JDTRefactoringDescriptor(this.getProcessorId(), project, description, comment.asString(), arguments, flags);
        }

        protected final int getContentKind() {
            int imp;
            int container;
            int packages;
            int initializers;
            int methods;
            int fields;
            int types = ReorgUtils.getElementsOfType(this.fJavaElements, 7).size();
            int length = types + (fields = ReorgUtils.getElementsOfType(this.fJavaElements, 8).size()) + (methods = ReorgUtils.getElementsOfType(this.fJavaElements, 9).size()) + (initializers = ReorgUtils.getElementsOfType(this.fJavaElements, 10).size()) + (packages = ReorgUtils.getElementsOfType(this.fJavaElements, 11).size()) + (container = ReorgUtils.getElementsOfType(this.fJavaElements, 12).size()) + (imp = ReorgUtils.getElementsOfType(this.fJavaElements, 13).size());
            if (length == types) {
                return 0;
            }
            if (length == fields) {
                return 1;
            }
            if (length == methods) {
                return 2;
            }
            if (length == initializers) {
                return 3;
            }
            if (length == packages) {
                return 4;
            }
            if (length == container) {
                return 5;
            }
            if (length == imp) {
                return 6;
            }
            return -1;
        }

        public final ChangeDescriptor getDescriptor() {
            HashMap<String, String> arguments = new HashMap<String, String>();
            int length = this.fJavaElements.length;
            String description = length == 1 ? this.getDescriptionSingular() : this.getDescriptionPlural();
            IProject resource = this.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String header = Messages.format(this.getHeaderPattern(), new String[]{String.valueOf(length), this.getDestinationLabel()});
            int flags = 589830;
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
            JDTRefactoringDescriptor descriptor = this.createRefactoringDescriptor(comment, arguments, description, project, flags);
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_POLICY, this.getPolicyId());
            arguments.put(ReorgPolicyFactory.ATTRIBUTE_MEMBERS, new Integer(this.fJavaElements.length).toString());
            int offset = 0;
            while (offset < this.fJavaElements.length) {
                arguments.put("element" + (offset + 1), descriptor.elementToHandle(this.fJavaElements[offset]));
                ++offset;
            }
            arguments.putAll(this.getRefactoringArguments(project));
            return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
        }

        private IType getDestinationAsType() throws JavaModelException {
            IJavaElement destination = this.getJavaElementDestination();
            IType enclosingType = SubCuElementReorgPolicy.getEnclosingType(destination);
            if (enclosingType != null) {
                return enclosingType;
            }
            ICompilationUnit enclosingCu = SubCuElementReorgPolicy.getEnclosingCu(destination);
            Assert.isNotNull((Object)enclosingCu);
            IType mainType = JavaElementUtil.getMainType(enclosingCu);
            Assert.isNotNull((Object)mainType);
            return mainType;
        }

        protected final ICompilationUnit getDestinationCu() {
            return SubCuElementReorgPolicy.getDestinationCu(this.getJavaElementDestination());
        }

        public final IJavaElement[] getJavaElements() {
            return this.fJavaElements;
        }

        public final IResource[] getResources() {
            return new IResource[0];
        }

        private IProject getSingleProject() {
            IProject result = null;
            int index = 0;
            while (index < this.fJavaElements.length) {
                if (result == null) {
                    result = this.fJavaElements[index].getJavaProject().getProject();
                } else if (!result.equals((Object)this.fJavaElements[index].getJavaProject().getProject())) {
                    return null;
                }
                ++index;
            }
            return result;
        }

        protected final ICompilationUnit getSourceCu() {
            return (ICompilationUnit)this.fJavaElements[0].getAncestor(5);
        }

        public RefactoringStatus initialize(RefactoringArguments arguments) {
            ArrayList<IJavaElement> elements;
            RefactoringStatus status = new RefactoringStatus();
            if (arguments instanceof JavaRefactoringArguments) {
                JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
                int memberCount = 0;
                String value = extended.getAttribute(ReorgPolicyFactory.ATTRIBUTE_MEMBERS);
                if (value != null && !"".equals(value)) {
                    try {
                        memberCount = Integer.parseInt(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_MEMBERS));
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ReorgPolicyFactory.ATTRIBUTE_MEMBERS));
                }
                String handle = null;
                elements = new ArrayList<IJavaElement>();
                int index = 0;
                while (index < memberCount) {
                    String attribute = "element" + (index + 1);
                    handle = extended.getAttribute(attribute);
                    if (handle != null && !"".equals(handle)) {
                        IJavaElement element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                        if (element == null || !element.exists()) {
                            status.merge(ScriptableRefactoring.createInputWarningStatus(element, this.getProcessorId(), this.getRefactoringId()));
                        } else {
                            elements.add(element);
                        }
                    } else {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                    }
                    ++index;
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
            }
            this.fJavaElements = elements.toArray(new IJavaElement[elements.size()]);
            status.merge(super.initialize(arguments));
            return status;
        }

        private RefactoringStatus recursiveVerifyDestination(IJavaElement destination) throws JavaModelException {
            Assert.isNotNull((Object)destination);
            if (!this.fCheckDestination) {
                return new RefactoringStatus();
            }
            if (!destination.exists()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_doesnotexist1);
            }
            if (destination instanceof IJavaModel) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_jmodel);
            }
            if (!(destination instanceof ICompilationUnit) && !ReorgUtils.isInsideCompilationUnit(destination)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
            }
            ICompilationUnit destinationCu = SubCuElementReorgPolicy.getDestinationCu(destination);
            Assert.isNotNull((Object)destinationCu);
            if (destinationCu.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot_modify);
            }
            switch (destination.getElementType()) {
                case 5: {
                    int[] types0 = new int[]{8, 10, 9};
                    if (!ReorgUtils.hasElementsOfType(this.getJavaElements(), types0)) break;
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
                case 11: {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_package_decl);
                }
                case 12: {
                    if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 13)) break;
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
                case 13: {
                    if (!ReorgUtils.hasElementsNotOfType(this.getJavaElements(), 13)) break;
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_cannot);
                }
                case 8: 
                case 9: 
                case 10: {
                    return this.recursiveVerifyDestination(destination.getParent());
                }
                case 7: {
                    int[] types1 = new int[]{13, 12, 11};
                    if (!ReorgUtils.hasElementsOfType(this.getJavaElements(), types1)) break;
                    return this.recursiveVerifyDestination(destination.getParent());
                }
            }
            return new RefactoringStatus();
        }

        protected RefactoringStatus verifyDestination(IJavaElement destination) throws JavaModelException {
            return this.recursiveVerifyDestination(destination);
        }

        protected final RefactoringStatus verifyDestination(IResource destination) throws JavaModelException {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReorgPolicyFactory_no_resource);
        }
    }
}

