/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.ConditionalTypeConstraint;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.CovariantTypeConstraint;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.CompilationUnitRange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.CastVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ConstraintVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ITypeConstraint2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ImmutableTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.IndependentTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ParameterTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ReturnTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.SubTypeConstraint2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TypeEquivalenceSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.VariableVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;

public final class SuperTypeConstraintsModel {
    private static final String DATA_USAGE = "us";
    private static final int MAX_CACHE = 64;
    private final Collection fCastVariables = new ArrayList();
    private int fCompliance = 3;
    private final HashedSet fConstraintVariables = new HashedSet();
    private final Collection fCovariantTypeConstraints = new ArrayList();
    private TypeEnvironment fEnvironment;
    private final TType fSubType;
    private final TType fSuperType;
    private Map fTTypeCache = new LinkedHashMap(64, 0.75f, true){
        private static final long serialVersionUID = 1L;

        protected final boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 64;
        }
    };
    private final Set fTypeConstraints = new HashSet();

    public static Collection getVariableUsage(ConstraintVariable2 variable) {
        Object data = variable.getData(DATA_USAGE);
        if (data == null) {
            return Collections.EMPTY_LIST;
        }
        if (data instanceof Collection) {
            return Collections.unmodifiableCollection((Collection)data);
        }
        return Collections.singletonList(data);
    }

    public static boolean isConstrainedType(ITypeBinding binding) {
        return binding != null && !binding.isSynthetic() && !binding.isPrimitive();
    }

    public static void setVariableUsage(ConstraintVariable2 variable, ITypeConstraint2 constraint) {
        Object data = variable.getData(DATA_USAGE);
        if (data == null) {
            variable.setData(DATA_USAGE, constraint);
        } else if (data instanceof Collection) {
            ((Collection)data).add(constraint);
        } else {
            ArrayList<Object> usage = new ArrayList<Object>(2);
            usage.add(data);
            usage.add(constraint);
            variable.setData(DATA_USAGE, usage);
        }
    }

    public SuperTypeConstraintsModel(TypeEnvironment environment, TType subType, TType superType) {
        this.fEnvironment = environment;
        this.fSubType = subType;
        this.fSuperType = superType;
    }

    public final void beginCreation() {
    }

    public final ConstraintVariable2 createCastVariable(CastExpression expression, ConstraintVariable2 variable) {
        ITypeBinding binding = expression.resolveTypeBinding();
        if (binding.isArray()) {
            binding = binding.getElementType();
        }
        if (SuperTypeConstraintsModel.isConstrainedType(binding)) {
            CastVariable2 result = new CastVariable2(this.createTType(binding), new CompilationUnitRange(RefactoringASTParser.getCompilationUnit((ASTNode)expression), (ASTNode)expression), variable);
            this.fCastVariables.add(result);
            return result;
        }
        return null;
    }

    public final void createConditionalTypeConstraint(ConstraintVariable2 expressionVariable, ConstraintVariable2 thenVariable, ConstraintVariable2 elseVariable) {
        ConditionalTypeConstraint constraint = new ConditionalTypeConstraint(expressionVariable, thenVariable, elseVariable);
        if (!this.fTypeConstraints.contains(constraint)) {
            this.fTypeConstraints.add(constraint);
            SuperTypeConstraintsModel.setVariableUsage(expressionVariable, constraint);
            SuperTypeConstraintsModel.setVariableUsage(thenVariable, constraint);
            SuperTypeConstraintsModel.setVariableUsage(elseVariable, constraint);
        }
    }

    public final void createCovariantTypeConstraint(ConstraintVariable2 descendant, ConstraintVariable2 ancestor) {
        CovariantTypeConstraint constraint = new CovariantTypeConstraint(descendant, ancestor);
        if (!this.fTypeConstraints.contains(constraint)) {
            this.fTypeConstraints.add(constraint);
            this.fCovariantTypeConstraints.add(constraint);
            SuperTypeConstraintsModel.setVariableUsage(descendant, constraint);
            SuperTypeConstraintsModel.setVariableUsage(ancestor, constraint);
        }
    }

    public final ConstraintVariable2 createDeclaringTypeVariable(ITypeBinding type) {
        if (type.isArray()) {
            type = type.getElementType();
        }
        type = type.getTypeDeclaration();
        return (ConstraintVariable2)this.fConstraintVariables.addExisting(new ImmutableTypeVariable2(this.createTType(type)));
    }

    public final void createEqualityConstraint(ConstraintVariable2 left, ConstraintVariable2 right) {
        if (left != null && right != null) {
            TypeEquivalenceSet first = left.getTypeEquivalenceSet();
            TypeEquivalenceSet second = right.getTypeEquivalenceSet();
            if (first == null) {
                if (second == null) {
                    TypeEquivalenceSet set = new TypeEquivalenceSet(left, right);
                    left.setTypeEquivalenceSet(set);
                    right.setTypeEquivalenceSet(set);
                } else {
                    second.add(left);
                    left.setTypeEquivalenceSet(second);
                }
            } else if (second == null) {
                first.add(right);
                right.setTypeEquivalenceSet(first);
            } else {
                if (first == second) {
                    return;
                }
                ConstraintVariable2[] variables = second.getContributingVariables();
                first.addAll(variables);
                int index = 0;
                while (index < variables.length) {
                    variables[index].setTypeEquivalenceSet(first);
                    ++index;
                }
            }
        }
    }

    public final ConstraintVariable2 createExceptionVariable(Name name) {
        ITypeBinding binding = name.resolveTypeBinding();
        if (SuperTypeConstraintsModel.isConstrainedType(binding)) {
            return (ConstraintVariable2)this.fConstraintVariables.addExisting(new TypeVariable2(this.createTType(binding), new CompilationUnitRange(RefactoringASTParser.getCompilationUnit((ASTNode)name), (ASTNode)name)));
        }
        return null;
    }

    public final ConstraintVariable2 createImmutableTypeVariable(ITypeBinding type) {
        if (type.isArray()) {
            type = type.getElementType();
        }
        if (SuperTypeConstraintsModel.isConstrainedType(type)) {
            return (ConstraintVariable2)this.fConstraintVariables.addExisting(new ImmutableTypeVariable2(this.createTType(type)));
        }
        return null;
    }

    public final ConstraintVariable2 createIndependentTypeVariable(ITypeBinding type) {
        if (type.isArray()) {
            type = type.getElementType();
        }
        if (SuperTypeConstraintsModel.isConstrainedType(type)) {
            return (ConstraintVariable2)this.fConstraintVariables.addExisting(new IndependentTypeVariable2(this.createTType(type)));
        }
        return null;
    }

    public final ConstraintVariable2 createMethodParameterVariable(IMethodBinding method, int index) {
        ITypeBinding[] parameters = method.getParameterTypes();
        ITypeBinding binding = parameters[Math.min(index, parameters.length - 1)];
        if (binding.isArray()) {
            binding = binding.getElementType();
        }
        if (SuperTypeConstraintsModel.isConstrainedType(binding)) {
            ConstraintVariable2 variable = null;
            TType type = this.createTType(binding);
            variable = method.getDeclaringClass().isFromSource() ? new ParameterTypeVariable2(type, index, method.getMethodDeclaration()) : new ImmutableTypeVariable2(type);
            return (ConstraintVariable2)this.fConstraintVariables.addExisting(variable);
        }
        return null;
    }

    public final ConstraintVariable2 createReturnTypeVariable(IMethodBinding method) {
        if (!method.isConstructor()) {
            ITypeBinding binding = method.getReturnType();
            if (binding != null && binding.isArray()) {
                binding = binding.getElementType();
            }
            if (binding != null && SuperTypeConstraintsModel.isConstrainedType(binding)) {
                ConstraintVariable2 variable = null;
                TType type = this.createTType(binding);
                variable = method.getDeclaringClass().isFromSource() ? new ReturnTypeVariable2(type, method) : new ImmutableTypeVariable2(type);
                return (ConstraintVariable2)this.fConstraintVariables.addExisting(variable);
            }
        }
        return null;
    }

    public final void createSubtypeConstraint(ConstraintVariable2 descendant, ConstraintVariable2 ancestor) {
        SubTypeConstraint2 constraint = new SubTypeConstraint2(descendant, ancestor);
        if (!this.fTypeConstraints.contains(constraint)) {
            this.fTypeConstraints.add(constraint);
            SuperTypeConstraintsModel.setVariableUsage(descendant, constraint);
            SuperTypeConstraintsModel.setVariableUsage(ancestor, constraint);
        }
    }

    public final TType createTType(ITypeBinding binding) {
        String key = binding.getKey();
        TType cached = (TType)this.fTTypeCache.get(key);
        if (cached != null) {
            return cached;
        }
        TType type = this.fEnvironment.create(binding);
        this.fTTypeCache.put(key, type);
        return type;
    }

    public final ConstraintVariable2 createTypeVariable(ITypeBinding type, CompilationUnitRange range) {
        if (type.isArray()) {
            type = type.getElementType();
        }
        if (SuperTypeConstraintsModel.isConstrainedType(type)) {
            return (ConstraintVariable2)this.fConstraintVariables.addExisting(new TypeVariable2(this.createTType(type), range));
        }
        return null;
    }

    public final ConstraintVariable2 createTypeVariable(Type type) {
        ITypeBinding binding = type.resolveBinding();
        if (binding != null) {
            if (binding.isArray()) {
                binding = binding.getElementType();
            }
            if (SuperTypeConstraintsModel.isConstrainedType(binding)) {
                return (ConstraintVariable2)this.fConstraintVariables.addExisting(new TypeVariable2(this.createTType(binding), new CompilationUnitRange(RefactoringASTParser.getCompilationUnit((ASTNode)type), (ASTNode)type)));
            }
        }
        return null;
    }

    public final ConstraintVariable2 createVariableVariable(IVariableBinding binding) {
        ITypeBinding type = binding.getType();
        if (type.isArray()) {
            type = type.getElementType();
        }
        if (SuperTypeConstraintsModel.isConstrainedType(type)) {
            ConstraintVariable2 variable = null;
            IVariableBinding declaration = binding.getVariableDeclaration();
            if (declaration.isField()) {
                ITypeBinding declaring = declaration.getDeclaringClass();
                if (!declaring.isFromSource()) {
                    variable = new ImmutableTypeVariable2(this.createTType(type));
                }
            } else {
                IMethodBinding declaring = declaration.getDeclaringMethod();
                if (declaring != null && !declaring.getDeclaringClass().isFromSource()) {
                    variable = new ImmutableTypeVariable2(this.createTType(type));
                }
            }
            if (variable == null) {
                variable = new VariableVariable2(this.createTType(type), declaration);
            }
            return (ConstraintVariable2)this.fConstraintVariables.addExisting(variable);
        }
        return null;
    }

    public final void endCreation() {
        this.fEnvironment = null;
        this.fTTypeCache = null;
    }

    public final Collection getCastVariables() {
        return Collections.unmodifiableCollection(this.fCastVariables);
    }

    public final int getCompliance() {
        return this.fCompliance;
    }

    public final Collection getConstraintVariables() {
        return Collections.unmodifiableCollection(this.fConstraintVariables);
    }

    public final TType getSubType() {
        return this.fSubType;
    }

    public final TType getSuperType() {
        return this.fSuperType;
    }

    public final Collection getTypeConstraints() {
        return Collections.unmodifiableCollection(this.fTypeConstraints);
    }

    public final void setCompliance(int level) {
        this.fCompliance = level;
    }

    private static class HashedSet
    extends AbstractSet
    implements Set {
        private final Map fImplementation = new HashMap();

        private HashedSet() {
        }

        public final boolean add(Object object) {
            return this.fImplementation.put(object, object) == null;
        }

        public final Object addExisting(Object object) {
            Object result = this.fImplementation.get(object);
            if (result != null) {
                return result;
            }
            this.fImplementation.put(object, object);
            return object;
        }

        public final void clear() {
            this.fImplementation.clear();
        }

        public final boolean contains(Object object) {
            return this.fImplementation.containsKey(object);
        }

        public final boolean isEmpty() {
            return this.fImplementation.isEmpty();
        }

        public final Iterator iterator() {
            return this.fImplementation.keySet().iterator();
        }

        public final boolean remove(Object object) {
            return this.fImplementation.remove(object) == object;
        }

        public final int size() {
            return this.fImplementation.size();
        }
    }
}

