/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;

public final class CompilationUnitRange {
    private final ICompilationUnit fCompilationUnit;
    private final ISourceRange fSourceRange;

    public CompilationUnitRange(ICompilationUnit unit, ISourceRange range) {
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)range);
        this.fCompilationUnit = unit;
        this.fSourceRange = range;
    }

    public CompilationUnitRange(ICompilationUnit unit, ASTNode node) {
        this(unit, new SourceRange(node));
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public ISourceRange getSourceRange() {
        return this.fSourceRange;
    }

    public ASTNode getNode(CompilationUnit rootNode) {
        NodeFinder finder = new NodeFinder(this.fSourceRange.getOffset(), this.fSourceRange.getLength());
        rootNode.accept((ASTVisitor)finder);
        ASTNode result = finder.getCoveringNode();
        if (result != null) {
            return result;
        }
        return finder.getCoveredNode();
    }

    public String toString() {
        return "(" + this.fSourceRange.toString() + " in " + this.fCompilationUnit.getElementName() + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CompilationUnitRange)) {
            return false;
        }
        CompilationUnitRange other = (CompilationUnitRange)obj;
        return this.fCompilationUnit.equals(other.fCompilationUnit) && this.fSourceRange.equals(other.fSourceRange);
    }

    public int hashCode() {
        return 37 * this.fCompilationUnit.hashCode() ^ this.fSourceRange.hashCode();
    }
}

