/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ConstraintVariable;

public class ParameterTypeVariable
extends ConstraintVariable {
    private final IMethodBinding fMethodBinding;
    private final int fParameterIndex;

    public ParameterTypeVariable(IMethodBinding methodBinding, int parameterIndex) {
        super(methodBinding.getParameterTypes()[parameterIndex]);
        Assert.isNotNull((Object)methodBinding);
        Assert.isTrue((parameterIndex >= 0 ? 1 : 0) != 0);
        Assert.isTrue((parameterIndex < methodBinding.getParameterTypes().length ? 1 : 0) != 0);
        this.fMethodBinding = methodBinding;
        this.fParameterIndex = parameterIndex;
    }

    public String toString() {
        return "[Parameter(" + this.fParameterIndex + "," + Bindings.asString((IBinding)this.fMethodBinding) + ")]";
    }

    public IMethodBinding getMethodBinding() {
        return this.fMethodBinding;
    }

    public int getParameterIndex() {
        return this.fParameterIndex;
    }
}

