/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavadocTagsSubProcessor;

public class JavadocUtil {
    private JavadocUtil() {
    }

    public static TagElement createParamTag(String parameterName, AST ast, IJavaProject javaProject) {
        TagElement paramNode = ast.newTagElement();
        paramNode.setTagName("@param");
        SimpleName simpleName = ast.newSimpleName(parameterName);
        paramNode.fragments().add(simpleName);
        TextElement textElement = ast.newTextElement();
        String text = StubUtility.getTodoTaskTag(javaProject);
        if (text != null) {
            textElement.setText(text);
        }
        paramNode.fragments().add(textElement);
        return paramNode;
    }

    public static boolean shouldAddParamJavadoc(MethodDeclaration methodDeclaration) {
        Javadoc javadoc = methodDeclaration.getJavadoc();
        if (javadoc == null) {
            return false;
        }
        if (methodDeclaration.parameters().size() == 0) {
            return true;
        }
        List tags = javadoc.tags();
        Iterator iter = tags.iterator();
        while (iter.hasNext()) {
            TagElement element = (TagElement)iter.next();
            if (!"@param".equals(element.getTagName())) continue;
            return true;
        }
        return false;
    }

    public static void addParamJavadoc(String parameterName, MethodDeclaration methodDeclaration, ASTRewrite astRewrite, IJavaProject javaProject, TextEditGroup groupDescription) {
        if (!JavadocUtil.shouldAddParamJavadoc(methodDeclaration)) {
            return;
        }
        ListRewrite tagsRewrite = astRewrite.getListRewrite((ASTNode)methodDeclaration.getJavadoc(), Javadoc.TAGS_PROPERTY);
        HashSet<String> leadingNames = new HashSet<String>();
        Iterator iter = methodDeclaration.parameters().iterator();
        while (iter.hasNext()) {
            SingleVariableDeclaration curr = (SingleVariableDeclaration)iter.next();
            leadingNames.add(curr.getName().getIdentifier());
        }
        TagElement parameterTag = JavadocUtil.createParamTag(parameterName, astRewrite.getAST(), javaProject);
        JavadocTagsSubProcessor.insertTag(tagsRewrite, parameterTag, leadingNames, groupDescription);
    }
}

