/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WithStatement;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.dom.TokenScanner;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.CommentAnalyzer;

public class StatementAnalyzer
extends SelectionAnalyzer {
    protected ICompilationUnit fCUnit;
    private TokenScanner fScanner;
    private RefactoringStatus fStatus;

    public StatementAnalyzer(ICompilationUnit cunit, Selection selection, boolean traverseSelectedNode) throws JavaModelException {
        super(selection, traverseSelectedNode);
        Assert.isNotNull((Object)cunit);
        this.fCUnit = cunit;
        this.fStatus = new RefactoringStatus();
        this.fScanner = new TokenScanner(this.fCUnit);
    }

    protected void checkSelectedNodes() {
        ASTNode[] nodes = this.getSelectedNodes();
        if (nodes.length == 0) {
            return;
        }
        ASTNode node = nodes[0];
        int selectionOffset = this.getSelection().getOffset();
        try {
            int pos = this.fScanner.getNextStartOffset(selectionOffset, true);
            if (pos == node.getStartPosition()) {
                int selectionEnd;
                int lastNodeEnd = ASTNodes.getExclusiveEnd(nodes[nodes.length - 1]);
                pos = this.fScanner.getNextStartOffset(lastNodeEnd, true);
                if (pos <= (selectionEnd = this.getSelection().getInclusiveEnd())) {
                    SourceRange range = new SourceRange(lastNodeEnd, pos - lastNodeEnd);
                    this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_end_of_selection, JavaStatusContext.create((ITypeRoot)this.fCUnit, range));
                }
                return;
            }
        }
        catch (CoreException coreException) {}
        SourceRange range = new SourceRange(selectionOffset, node.getStartPosition() - selectionOffset + 1);
        this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_beginning_of_selection, JavaStatusContext.create((ITypeRoot)this.fCUnit, range));
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    protected ICompilationUnit getCompilationUnit() {
        return this.fCUnit;
    }

    protected TokenScanner getTokenScanner() {
        return this.fScanner;
    }

    public void endVisit(CompilationUnit node) {
        if (!this.hasSelectedNodes()) {
            super.endVisit(node);
            return;
        }
        ASTNode selectedNode = this.getFirstSelectedNode();
        Selection selection = this.getSelection();
        if (node != selectedNode) {
            ASTNode parent = selectedNode.getParent();
            this.fStatus.merge(CommentAnalyzer.perform(selection, this.fScanner.getScanner(), parent.getStartPosition(), parent.getLength()));
        }
        if (!this.fStatus.hasFatalError()) {
            this.checkSelectedNodes();
        }
        super.endVisit(node);
    }

    public void endVisit(DoStatement node) {
        ASTNode[] selectedNodes = this.getSelectedNodes();
        if (this.doAfterValidation((ASTNode)node, selectedNodes) && StatementAnalyzer.contains(selectedNodes, (ASTNode)node.getBody()) && StatementAnalyzer.contains(selectedNodes, (ASTNode)node.getExpression())) {
            this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_do_body_expression);
        }
        super.endVisit(node);
    }

    public void endVisit(ForStatement node) {
        ASTNode[] selectedNodes = this.getSelectedNodes();
        if (this.doAfterValidation((ASTNode)node, selectedNodes)) {
            boolean containsExpression = StatementAnalyzer.contains(selectedNodes, (ASTNode)node.getExpression());
            boolean containsUpdaters = StatementAnalyzer.contains(selectedNodes, node.updaters());
            if (StatementAnalyzer.contains(selectedNodes, node.initializers()) && containsExpression) {
                this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_for_initializer_expression);
            } else if (containsExpression && containsUpdaters) {
                this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_for_expression_updater);
            } else if (containsUpdaters && StatementAnalyzer.contains(selectedNodes, (ASTNode)node.getBody())) {
                this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_for_updater_body);
            }
        }
        super.endVisit(node);
    }

    public void endVisit(ForInStatement node) {
        ASTNode[] selectedNodes = this.getSelectedNodes();
        if (this.doAfterValidation((ASTNode)node, selectedNodes)) {
            boolean containsVar = StatementAnalyzer.contains(selectedNodes, (ASTNode)node.getIterationVariable());
            boolean containsCollection = StatementAnalyzer.contains(selectedNodes, (ASTNode)node.getCollection());
            if (containsVar && containsCollection) {
                this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_for_expression_updater);
            } else if (containsCollection && StatementAnalyzer.contains(selectedNodes, (ASTNode)node.getBody())) {
                this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_for_updater_body);
            }
        }
        super.endVisit(node);
    }

    public void endVisit(SwitchStatement node) {
        ASTNode[] selectedNodes = this.getSelectedNodes();
        if (this.doAfterValidation((ASTNode)node, selectedNodes)) {
            List cases = StatementAnalyzer.getSwitchCases(node);
            int i = 0;
            while (i < selectedNodes.length) {
                ASTNode topNode = selectedNodes[i];
                if (cases.contains(topNode)) {
                    this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_switch_statement);
                    break;
                }
                ++i;
            }
        }
        super.endVisit(node);
    }

    public void endVisit(TryStatement node) {
        ASTNode firstSelectedNode = this.getFirstSelectedNode();
        if (this.getSelection().getEndVisitSelectionMode((ASTNode)node) == 3) {
            if (firstSelectedNode == node.getBody() || firstSelectedNode == node.getFinally()) {
                this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_try_statement);
            } else {
                List catchClauses = node.catchClauses();
                Iterator iterator = catchClauses.iterator();
                while (iterator.hasNext()) {
                    CatchClause element = (CatchClause)iterator.next();
                    if (element == firstSelectedNode || element.getBody() == firstSelectedNode) {
                        this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_try_statement);
                        continue;
                    }
                    if (element.getException() != firstSelectedNode) continue;
                    this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_catch_argument);
                }
            }
        }
        super.endVisit(node);
    }

    public void endVisit(WhileStatement node) {
        ASTNode[] selectedNodes = this.getSelectedNodes();
        if (this.doAfterValidation((ASTNode)node, selectedNodes) && StatementAnalyzer.contains(selectedNodes, (ASTNode)node.getExpression()) && StatementAnalyzer.contains(selectedNodes, (ASTNode)node.getBody())) {
            this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_while_expression_body);
        }
        super.endVisit(node);
    }

    public void endVisit(WithStatement node) {
        ASTNode[] selectedNodes = this.getSelectedNodes();
        if (this.doAfterValidation((ASTNode)node, selectedNodes) && StatementAnalyzer.contains(selectedNodes, (ASTNode)node.getExpression()) && StatementAnalyzer.contains(selectedNodes, (ASTNode)node.getBody())) {
            this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_while_expression_body);
        }
        super.endVisit(node);
    }

    private boolean doAfterValidation(ASTNode node, ASTNode[] selectedNodes) {
        return selectedNodes.length > 0 && node == selectedNodes[0].getParent() && this.getSelection().getEndVisitSelectionMode(node) == 3;
    }

    protected void invalidSelection(String message) {
        this.fStatus.addFatalError(message);
        this.reset();
    }

    protected void invalidSelection(String message, RefactoringStatusContext context) {
        this.fStatus.addFatalError(message, context);
        this.reset();
    }

    private static List getSwitchCases(SwitchStatement node) {
        ArrayList result = new ArrayList();
        Iterator iter = node.statements().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof SwitchCase)) continue;
            result.add(element);
        }
        return result;
    }

    protected static boolean contains(ASTNode[] nodes, ASTNode node) {
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i] == node) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static boolean contains(ASTNode[] nodes, List list) {
        int i = 0;
        while (i < nodes.length) {
            if (list.contains(nodes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

