/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class JavaWorkbenchAdapter
implements IWorkbenchAdapter {
    protected static final Object[] NO_CHILDREN = new Object[0];
    private JavaElementImageProvider fImageProvider = new JavaElementImageProvider();

    public Object[] getChildren(Object element) {
        IJavaElement je = this.getJavaElement(element);
        if (je instanceof IParent) {
            try {
                return ((IParent)je).getChildren();
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return NO_CHILDREN;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        IJavaElement je = this.getJavaElement(element);
        if (je != null) {
            return this.fImageProvider.getJavaImageDescriptor(je, 3);
        }
        return null;
    }

    public String getLabel(Object element) {
        return JavaElementLabels.getTextLabel(this.getJavaElement(element), JavaElementLabels.ALL_DEFAULT);
    }

    public Object getParent(Object element) {
        IJavaElement je = this.getJavaElement(element);
        return je != null ? je.getParent() : null;
    }

    private IJavaElement getJavaElement(Object element) {
        if (element instanceof IJavaElement) {
            return (IJavaElement)element;
        }
        if (element instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)element).getClassFile().getPrimaryElement();
        }
        return null;
    }
}

