/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;

public class GenerateConstructorUsingFieldsContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY = new Object[0];
    private List fFields = new ArrayList();
    private List fSelected = new ArrayList();
    private ITypeBinding fType = null;
    private final CompilationUnit fUnit;

    public GenerateConstructorUsingFieldsContentProvider(IType type, List fields, List selected) throws JavaModelException {
        RefactoringASTParser parser = new RefactoringASTParser(3);
        this.fUnit = parser.parse((ITypeRoot)type.getCompilationUnit(), true);
        this.fType = ASTNodes.getTypeBinding(this.fUnit, type);
        if (this.fType != null) {
            IVariableBinding binding;
            VariableDeclarationFragment fragment;
            IField field = null;
            Iterator iterator = fields.iterator();
            while (iterator.hasNext()) {
                field = (IField)iterator.next();
                fragment = ASTNodeSearchUtil.getFieldDeclarationFragmentNode(field, this.fUnit);
                if (fragment == null || (binding = fragment.resolveBinding()) == null) continue;
                this.fFields.add(binding);
            }
            iterator = selected.iterator();
            while (iterator.hasNext()) {
                field = (IField)iterator.next();
                fragment = ASTNodeSearchUtil.getFieldDeclarationFragmentNode(field, this.fUnit);
                if (fragment == null || (binding = fragment.resolveBinding()) == null) continue;
                this.fSelected.add(binding);
            }
        }
    }

    public CompilationUnit getCompilationUnit() {
        return this.fUnit;
    }

    public boolean canMoveDown(List selectedElements) {
        int nSelected = selectedElements.size();
        int index = this.fFields.size() - 1;
        while (index >= 0 && nSelected > 0) {
            if (!selectedElements.contains(this.fFields.get(index))) {
                return true;
            }
            --nSelected;
            --index;
        }
        return false;
    }

    public boolean canMoveUp(List selected) {
        int nSelected = selected.size();
        int index = 0;
        while (index < this.fFields.size() && nSelected > 0) {
            if (!selected.contains(this.fFields.get(index))) {
                return true;
            }
            --nSelected;
            ++index;
        }
        return false;
    }

    public void dispose() {
    }

    public void down(List checked, CheckboxTreeViewer tree) {
        if (checked.size() > 0) {
            this.setElements(this.reverse(this.moveUp(this.reverse(this.fFields), checked)), tree);
            tree.reveal(checked.get(checked.size() - 1));
        }
        tree.setSelection((ISelection)new StructuredSelection(checked));
    }

    public Object[] getChildren(Object parentElement) {
        return EMPTY;
    }

    public Object[] getElements(Object inputElement) {
        return this.fFields.toArray();
    }

    public List getFieldsList() {
        return this.fFields;
    }

    public Object[] getInitiallySelectedElements() {
        if (this.fSelected.isEmpty()) {
            return this.getElements(null);
        }
        return this.fSelected.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public ITypeBinding getType() {
        return this.fType;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private List moveUp(List elements, List move) {
        ArrayList result = new ArrayList(elements.size());
        Object floating = null;
        int index = 0;
        while (index < elements.size()) {
            Object current = elements.get(index);
            if (move.contains(current)) {
                result.add(current);
            } else {
                if (floating != null) {
                    result.add(floating);
                }
                floating = current;
            }
            ++index;
        }
        if (floating != null) {
            result.add(floating);
        }
        return result;
    }

    private List reverse(List list) {
        ArrayList reverse = new ArrayList(list.size());
        int index = list.size() - 1;
        while (index >= 0) {
            reverse.add(list.get(index));
            --index;
        }
        return reverse;
    }

    public void setElements(List elements, CheckboxTreeViewer tree) {
        this.fFields = new ArrayList(elements);
        if (tree != null) {
            tree.refresh();
        }
    }

    public void up(List checked, CheckboxTreeViewer tree) {
        if (checked.size() > 0) {
            this.setElements(this.moveUp(this.fFields, checked), tree);
            tree.reveal(checked.get(0));
        }
        tree.setSelection((ISelection)new StructuredSelection(checked));
    }
}

