/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICodeAssist;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;

public class SelectionConverter {
    private static final IJavaElement[] EMPTY_RESULT = new IJavaElement[0];

    private SelectionConverter() {
    }

    public static IStructuredSelection getStructuredSelection(IWorkbenchPart part) throws JavaModelException {
        ISelection selection;
        if (part instanceof JavaEditor) {
            return new StructuredSelection((Object[])SelectionConverter.codeResolve((JavaEditor)part));
        }
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    public static IJavaElement[] getElements(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            IJavaElement[] result = new IJavaElement[selection.size()];
            int i = 0;
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof IJavaElement)) {
                    return EMPTY_RESULT;
                }
                result[i] = (IJavaElement)element;
                ++i;
            }
            return result;
        }
        return EMPTY_RESULT;
    }

    public static boolean canOperateOn(JavaEditor editor) {
        if (editor == null) {
            return false;
        }
        return SelectionConverter.getInput(editor) != null;
    }

    public static IJavaElement[] codeResolveOrInputForked(JavaEditor editor) throws InvocationTargetException, InterruptedException {
        ITextSelection selection;
        IJavaElement input = SelectionConverter.getInput(editor);
        IJavaElement[] result = SelectionConverter.performForkedCodeResolve(input, selection = (ITextSelection)editor.getSelectionProvider().getSelection());
        if (result.length == 0) {
            result = new IJavaElement[]{input};
        }
        return result;
    }

    public static IJavaElement[] codeResolve(JavaEditor editor) throws JavaModelException {
        return SelectionConverter.codeResolve(editor, true);
    }

    public static IJavaElement[] codeResolve(JavaEditor editor, boolean primaryOnly) throws JavaModelException {
        return SelectionConverter.codeResolve(SelectionConverter.getInput(editor, primaryOnly), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static IJavaElement[] codeResolveForked(JavaEditor editor, boolean primaryOnly) throws InvocationTargetException, InterruptedException {
        return SelectionConverter.performForkedCodeResolve(SelectionConverter.getInput(editor, primaryOnly), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static IJavaElement getElementAtOffset(JavaEditor editor) throws JavaModelException {
        return SelectionConverter.getElementAtOffset(editor, true);
    }

    private static IJavaElement getElementAtOffset(JavaEditor editor, boolean primaryOnly) throws JavaModelException {
        return SelectionConverter.getElementAtOffset(SelectionConverter.getInput(editor, primaryOnly), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static IType getTypeAtOffset(JavaEditor editor) throws JavaModelException {
        ICompilationUnit unit;
        IJavaElement element = SelectionConverter.getElementAtOffset(editor);
        IType type = (IType)element.getAncestor(7);
        if (type == null && (unit = SelectionConverter.getInputAsCompilationUnit(editor)) != null) {
            type = unit.findPrimaryType();
        }
        return type;
    }

    public static IJavaElement getInput(JavaEditor editor) {
        return SelectionConverter.getInput(editor, true);
    }

    private static IJavaElement getInput(JavaEditor editor, boolean primaryOnly) {
        if (editor == null) {
            return null;
        }
        return EditorUtility.getEditorInputJavaElement((IEditorPart)editor, primaryOnly);
    }

    public static ITypeRoot getInputAsTypeRoot(JavaEditor editor) {
        IJavaElement editorInput = SelectionConverter.getInput(editor);
        if (editorInput instanceof ITypeRoot) {
            return (ITypeRoot)editorInput;
        }
        return null;
    }

    public static ICompilationUnit getInputAsCompilationUnit(JavaEditor editor) {
        IJavaElement editorInput = SelectionConverter.getInput(editor);
        if (editorInput instanceof ICompilationUnit) {
            return (ICompilationUnit)editorInput;
        }
        return null;
    }

    public static IClassFile getInputAsClassFile(JavaEditor editor) {
        IJavaElement editorInput = SelectionConverter.getInput(editor);
        if (editorInput instanceof IClassFile) {
            return (IClassFile)editorInput;
        }
        return null;
    }

    private static IJavaElement[] performForkedCodeResolve(IJavaElement input, ITextSelection selection) throws InvocationTargetException, InterruptedException {
        final class CodeResolveRunnable
        implements IRunnableWithProgress {
            IJavaElement[] result;
            private final /* synthetic */ IJavaElement val$input;
            private final /* synthetic */ ITextSelection val$selection;

            CodeResolveRunnable(IJavaElement iJavaElement, ITextSelection iTextSelection) {
                this.val$input = iJavaElement;
                this.val$selection = iTextSelection;
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    this.result = SelectionConverter.codeResolve(this.val$input, this.val$selection);
                }
                catch (JavaModelException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
        CodeResolveRunnable runnable = new CodeResolveRunnable(input, selection);
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)runnable);
        return runnable.result;
    }

    public static IJavaElement[] codeResolve(IJavaElement input, ITextSelection selection) throws JavaModelException {
        if (input instanceof ICodeAssist) {
            IJavaElement[] elements;
            if (input instanceof ICompilationUnit) {
                JavaModelUtil.reconcile((ICompilationUnit)input);
            }
            if ((elements = ((ICodeAssist)input).codeSelect(selection.getOffset() + selection.getLength(), 0)).length > 0) {
                return elements;
            }
        }
        return EMPTY_RESULT;
    }

    public static IJavaElement getElementAtOffset(IJavaElement input, ITextSelection selection) throws JavaModelException {
        if (input instanceof ICompilationUnit) {
            ICompilationUnit cunit = (ICompilationUnit)input;
            JavaModelUtil.reconcile(cunit);
            IJavaElement ref = cunit.getElementAt(selection.getOffset());
            if (ref == null) {
                return input;
            }
            return ref;
        }
        if (input instanceof IClassFile) {
            IJavaElement ref = ((IClassFile)input).getElementAt(selection.getOffset());
            if (ref == null) {
                return input;
            }
            return ref;
        }
        return null;
    }

    public static IJavaElement resolveEnclosingElement(JavaEditor editor, ITextSelection selection) throws JavaModelException {
        return SelectionConverter.resolveEnclosingElement(SelectionConverter.getInput(editor), selection);
    }

    public static IJavaElement resolveEnclosingElement(IJavaElement input, ITextSelection selection) throws JavaModelException {
        IJavaElement atOffset = null;
        if (input instanceof ICompilationUnit) {
            ICompilationUnit cunit = (ICompilationUnit)input;
            JavaModelUtil.reconcile(cunit);
            atOffset = cunit.getElementAt(selection.getOffset());
        } else if (input instanceof IClassFile) {
            IClassFile cfile = (IClassFile)input;
            atOffset = cfile.getElementAt(selection.getOffset());
        } else {
            return null;
        }
        if (atOffset == null) {
            return input;
        }
        int selectionEnd = selection.getOffset() + selection.getLength();
        IJavaElement result = atOffset;
        if (atOffset instanceof ISourceReference) {
            ISourceRange range = ((ISourceReference)atOffset).getSourceRange();
            while (range.getOffset() + range.getLength() < selectionEnd) {
                if (!((result = result.getParent()) instanceof ISourceReference)) {
                    result = input;
                    break;
                }
                range = ((ISourceReference)result).getSourceRange();
            }
        }
        return result;
    }

    public static IJavaElement selectJavaElement(IJavaElement[] elements, Shell shell, String title, String message) {
        int nResults = elements.length;
        if (nResults == 0) {
            return null;
        }
        if (nResults == 1) {
            return elements[0];
        }
        int flags = JavaElementLabelProvider.SHOW_DEFAULT | 0x400 | 0x40;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(flags));
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements((Object[])elements);
        if (dialog.open() == 0) {
            return (IJavaElement)dialog.getFirstResult();
        }
        return null;
    }
}

