/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.dialogs;

import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TypeSelectionDialog2;
import org.eclipse.wst.jsdt.ui.dialogs.TypeSelectionExtension;

public class OpenTypeSelectionDialog2
extends TypeSelectionDialog2 {
    private IDialogSettings fSettings;
    private Point fLocation;
    private Point fSize;
    private static final String DIALOG_SETTINGS = "org.eclipse.wst.jsdt.internal.ui.dialogs.OpenTypeSelectionDialog2";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";

    public OpenTypeSelectionDialog2(Shell parent, boolean multi, IRunnableContext context, IJavaSearchScope scope, int elementKinds) {
        this(parent, multi, context, scope, elementKinds, null);
    }

    public OpenTypeSelectionDialog2(Shell parent, boolean multi, IRunnableContext context, IJavaSearchScope scope, int elementKinds, TypeSelectionExtension extension) {
        super(parent, multi, context, scope, elementKinds, extension);
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
        this.fSettings = settings.getSection(DIALOG_SETTINGS);
        if (this.fSettings == null) {
            this.fSettings = new DialogSettings(DIALOG_SETTINGS);
            settings.addSection(this.fSettings);
            this.fSettings.put(WIDTH, 480);
            this.fSettings.put(HEIGHT, 320);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.wst.jsdt.ui.open_type_dialog_context");
    }

    protected Point getInitialSize() {
        Point result = super.getInitialSize();
        if (this.fSize != null) {
            result.x = Math.max(result.x, this.fSize.x);
            result.y = Math.max(result.y, this.fSize.y);
            Rectangle display = this.getShell().getDisplay().getClientArea();
            result.x = Math.min(result.x, display.width);
            result.y = Math.min(result.y, display.height);
        }
        return result;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point result = super.getInitialLocation(initialSize);
        if (this.fLocation != null) {
            int ye;
            result.x = this.fLocation.x;
            result.y = this.fLocation.y;
            Rectangle display = this.getShell().getDisplay().getClientArea();
            int xe = result.x + initialSize.x;
            if (xe > display.width) {
                result.x -= xe - display.width;
            }
            if ((ye = result.y + initialSize.y) > display.height) {
                result.y -= ye - display.height;
            }
        }
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        this.readSettings();
        return super.createDialogArea(parent);
    }

    public boolean close() {
        this.writeSettings();
        return super.close();
    }

    private void readSettings() {
        try {
            int x = this.fSettings.getInt("x");
            int y = this.fSettings.getInt("y");
            this.fLocation = new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            this.fLocation = null;
        }
        try {
            int width = this.fSettings.getInt(WIDTH);
            int height = this.fSettings.getInt(HEIGHT);
            this.fSize = new Point(width, height);
        }
        catch (NumberFormatException numberFormatException) {
            this.fSize = null;
        }
    }

    private void writeSettings() {
        Point location = this.getShell().getLocation();
        this.fSettings.put("x", location.x);
        this.fSettings.put("y", location.y);
        Point size = this.getShell().getSize();
        this.fSettings.put(WIDTH, size.x);
        this.fSettings.put(HEIGHT, size.y);
    }
}

