/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.UnusedCodeFix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class UnnecessaryCodeCleanUp
extends AbstractCleanUp {
    public UnnecessaryCodeCleanUp(Map options) {
        super(options);
    }

    public UnnecessaryCodeCleanUp() {
    }

    public boolean requireAST(ICompilationUnit unit) throws CoreException {
        return this.isEnabled("cleanup.remove_unnecessary_casts");
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return UnusedCodeFix.createCleanUp(compilationUnit, false, false, false, false, false, false, this.isEnabled("cleanup.remove_unnecessary_casts"));
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return UnusedCodeFix.createCleanUp(compilationUnit, problems, false, false, false, false, false, false, this.isEnabled("cleanup.remove_unnecessary_casts"));
    }

    public Map getRequiredOptions() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.remove_unnecessary_casts")) {
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "warning");
        }
        return options;
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.remove_unnecessary_casts")) {
            result.add(MultiFixMessages.UnusedCodeCleanUp_RemoveUnusedCasts_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        return buf.toString();
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        IFix fix;
        return this.isEnabled("cleanup.remove_unnecessary_casts") && (fix = UnusedCodeFix.createRemoveUnusedCastFix(compilationUnit, problem)) != null;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isEnabled("cleanup.remove_unnecessary_casts")) {
            result += this.getNumberOfProblems(problems, 553648309);
        }
        return result;
    }
}

