/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javadocexport;

import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class JavadocProjectContentProvider
implements ITreeContentProvider {
    public Object[] getChildren(Object parentElement) {
        try {
            if (parentElement instanceof IJavaProject) {
                IJavaProject project = (IJavaProject)parentElement;
                return this.getPackageFragmentRoots(project);
            }
            if (parentElement instanceof IPackageFragmentRoot) {
                return this.getPackageFragments((IPackageFragmentRoot)parentElement);
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return new Object[0];
    }

    public Object[] getElements(Object inputElement) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            return JavaCore.create((IWorkspaceRoot)root).getJavaProjects();
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return new Object[0];
        }
    }

    public Object getParent(Object element) {
        IPackageFragmentRoot root;
        IJavaElement parent = ((IJavaElement)element).getParent();
        if (parent instanceof IPackageFragmentRoot && (root = (IPackageFragmentRoot)parent).getPath().equals((Object)root.getJavaProject().getProject().getFullPath())) {
            return root.getJavaProject();
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private Object[] getPackageFragmentRoots(IJavaProject project) throws JavaModelException {
        ArrayList<Object> result = new ArrayList<Object>();
        IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (root.getKind() == 1) {
                if (root.getPath().equals((Object)root.getJavaProject().getPath())) {
                    Object[] packageFragments = this.getPackageFragments(root);
                    int k = 0;
                    while (k < packageFragments.length) {
                        result.add(packageFragments[k]);
                        ++k;
                    }
                } else {
                    result.add(root);
                }
            }
            ++i;
        }
        return result.toArray();
    }

    private Object[] getPackageFragments(IPackageFragmentRoot root) throws JavaModelException {
        ArrayList<IJavaElement> packageFragments = new ArrayList<IJavaElement>();
        IJavaElement[] children = root.getChildren();
        int i = 0;
        while (i < children.length) {
            if (((IPackageFragment)children[i]).containsJavaResources()) {
                packageFragments.add(children[i]);
            }
            ++i;
        }
        return packageFragments.toArray();
    }
}

