/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;

public class JavaTextSelection
extends TextSelection {
    private IJavaElement fElement;
    private IJavaElement[] fResolvedElements;
    private boolean fEnclosingElementRequested;
    private IJavaElement fEnclosingElement;
    private boolean fPartialASTRequested;
    private CompilationUnit fPartialAST;
    private boolean fNodesRequested;
    private ASTNode[] fSelectedNodes;
    private ASTNode fCoveringNode;
    private boolean fInMethodBodyRequested;
    private boolean fInMethodBody;
    private boolean fInClassInitializerRequested;
    private boolean fInClassInitializer;
    private boolean fInVariableInitializerRequested;
    private boolean fInVariableInitializer;

    public JavaTextSelection(IJavaElement element, IDocument document, int offset, int length) {
        super(document, offset, length);
        this.fElement = element;
    }

    public IJavaElement[] resolveElementAtOffset() throws JavaModelException {
        if (this.fResolvedElements != null) {
            return this.fResolvedElements;
        }
        this.fResolvedElements = SelectionConverter.codeResolve(this.fElement, (ITextSelection)this);
        return this.fResolvedElements;
    }

    public IJavaElement resolveEnclosingElement() throws JavaModelException {
        if (this.fEnclosingElementRequested) {
            return this.fEnclosingElement;
        }
        this.fEnclosingElementRequested = true;
        this.fEnclosingElement = SelectionConverter.resolveEnclosingElement(this.fElement, (ITextSelection)this);
        return this.fEnclosingElement;
    }

    public CompilationUnit resolvePartialAstAtOffset() {
        if (this.fPartialASTRequested) {
            return this.fPartialAST;
        }
        this.fPartialASTRequested = true;
        if (!(this.fElement instanceof ICompilationUnit)) {
            return null;
        }
        this.fPartialAST = JavaPlugin.getDefault().getASTProvider().getAST(this.fElement, ASTProvider.WAIT_YES, null);
        return this.fPartialAST;
    }

    public ASTNode[] resolveSelectedNodes() {
        if (this.fNodesRequested) {
            return this.fSelectedNodes;
        }
        this.fNodesRequested = true;
        CompilationUnit root = this.resolvePartialAstAtOffset();
        if (root == null) {
            return null;
        }
        Selection ds = Selection.createFromStartLength(this.getOffset(), this.getLength());
        SelectionAnalyzer analyzer = new SelectionAnalyzer(ds, false);
        root.accept((ASTVisitor)analyzer);
        this.fSelectedNodes = analyzer.getSelectedNodes();
        this.fCoveringNode = analyzer.getLastCoveringNode();
        return this.fSelectedNodes;
    }

    public ASTNode resolveCoveringNode() {
        if (this.fNodesRequested) {
            return this.fCoveringNode;
        }
        this.resolveSelectedNodes();
        return this.fCoveringNode;
    }

    /*
     * Unable to fully structure code
     */
    public boolean resolveInMethodBody() {
        block4: {
            if (this.fInMethodBodyRequested) {
                return this.fInMethodBody;
            }
            this.fInMethodBodyRequested = true;
            this.resolveSelectedNodes();
            node = this.getStartNode();
            if (node != null) ** GOTO lbl18
            this.fInMethodBody = true;
            break block4;
lbl-1000:
            // 1 sources

            {
                nodeType = node.getNodeType();
                if (nodeType == 8 && node.getParent() instanceof BodyDeclaration) {
                    this.fInMethodBody = node.getParent().getNodeType() == 31;
                    break;
                }
                if (nodeType == 1) {
                    this.fInMethodBody = false;
                    break;
                }
                node = node.getParent();
lbl18:
                // 2 sources

                ** while (node != null)
            }
        }
        return this.fInMethodBody;
    }

    /*
     * Unable to fully structure code
     */
    public boolean resolveInClassInitializer() {
        block5: {
            if (this.fInClassInitializerRequested) {
                return this.fInClassInitializer;
            }
            this.fInClassInitializerRequested = true;
            this.resolveSelectedNodes();
            node = this.getStartNode();
            if (node != null) ** GOTO lbl21
            this.fInClassInitializer = true;
            break block5;
lbl-1000:
            // 1 sources

            {
                nodeType = node.getNodeType();
                if (node instanceof AbstractTypeDeclaration) {
                    this.fInClassInitializer = false;
                    break;
                }
                if (nodeType == 1) {
                    this.fInClassInitializer = false;
                    break;
                }
                if (nodeType == 28) {
                    this.fInClassInitializer = true;
                    break;
                }
                node = node.getParent();
lbl21:
                // 2 sources

                ** while (node != null)
            }
        }
        return this.fInClassInitializer;
    }

    public boolean resolveInVariableInitializer() {
        if (this.fInVariableInitializerRequested) {
            return this.fInVariableInitializer;
        }
        this.fInVariableInitializerRequested = true;
        this.resolveSelectedNodes();
        ASTNode node = this.getStartNode();
        ASTNode last = null;
        while (node != null) {
            int nodeType = node.getNodeType();
            if (node instanceof AbstractTypeDeclaration) {
                this.fInVariableInitializer = false;
                break;
            }
            if (nodeType == 1) {
                this.fInVariableInitializer = false;
                break;
            }
            if (nodeType == 59 && ((VariableDeclarationFragment)node).getInitializer() == last) {
                this.fInVariableInitializer = true;
                break;
            }
            if (nodeType == 44 && ((SingleVariableDeclaration)node).getInitializer() == last) {
                this.fInVariableInitializer = true;
                break;
            }
            if (nodeType == 82 && ((AnnotationTypeMemberDeclaration)node).getDefault() == last) {
                this.fInVariableInitializer = true;
                break;
            }
            last = node;
            node = node.getParent();
        }
        return this.fInVariableInitializer;
    }

    private ASTNode getStartNode() {
        if (this.fSelectedNodes != null && this.fSelectedNodes.length > 0) {
            return this.fSelectedNodes[0];
        }
        return this.fCoveringNode;
    }
}

