/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions.SelectionActionMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions.SelectionHistory;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions.StructureSelectionAction;

public class StructureSelectNextAction
extends StructureSelectionAction {
    public StructureSelectNextAction(JavaEditor editor, SelectionHistory history) {
        super(SelectionActionMessages.StructureSelectNext_label, editor, history);
        this.setToolTipText(SelectionActionMessages.StructureSelectNext_tooltip);
        this.setDescription(SelectionActionMessages.StructureSelectNext_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.structured_select_next_action");
    }

    public StructureSelectNextAction() {
    }

    ISourceRange internalGetNewSelectionRange(ISourceRange oldSourceRange, ISourceReference sr, SelectionAnalyzer selAnalyzer) throws JavaModelException {
        ASTNode previousNode;
        if (oldSourceRange.getLength() == 0 && selAnalyzer.getLastCoveringNode() != null && (previousNode = NextNodeAnalyzer.perform(oldSourceRange.getOffset(), selAnalyzer.getLastCoveringNode())) != null) {
            return StructureSelectNextAction.getSelectedNodeSourceRange(sr, previousNode);
        }
        ASTNode first = selAnalyzer.getFirstSelectedNode();
        if (first == null) {
            return StructureSelectNextAction.getLastCoveringNodeRange(oldSourceRange, sr, selAnalyzer);
        }
        ASTNode parent = first.getParent();
        if (parent == null) {
            return StructureSelectNextAction.getLastCoveringNodeRange(oldSourceRange, sr, selAnalyzer);
        }
        ASTNode lastSelectedNode = selAnalyzer.getSelectedNodes()[selAnalyzer.getSelectedNodes().length - 1];
        ASTNode nextNode = StructureSelectNextAction.getNextNode(parent, lastSelectedNode);
        if (nextNode == parent) {
            return StructureSelectNextAction.getSelectedNodeSourceRange(sr, first.getParent());
        }
        int offset = oldSourceRange.getOffset();
        int end = Math.min(sr.getSourceRange().getLength(), nextNode.getStartPosition() + nextNode.getLength() - 1);
        return StructureSelectionAction.createSourceRange(offset, end);
    }

    private static ASTNode getNextNode(ASTNode parent, ASTNode node) {
        Object[] siblingNodes = StructureSelectionAction.getSiblingNodes(node);
        if (siblingNodes == null || siblingNodes.length == 0) {
            return parent;
        }
        if (node == siblingNodes[siblingNodes.length - 1]) {
            return parent;
        }
        return siblingNodes[StructureSelectionAction.findIndex(siblingNodes, node) + 1];
    }

    private static class NextNodeAnalyzer
    extends GenericVisitor {
        private final int fOffset;
        private ASTNode fNextNode;

        private NextNodeAnalyzer(int offset) {
            super(true);
            this.fOffset = offset;
        }

        public static ASTNode perform(int offset, ASTNode lastCoveringNode) {
            NextNodeAnalyzer analyzer = new NextNodeAnalyzer(offset);
            lastCoveringNode.accept((ASTVisitor)analyzer);
            return analyzer.fNextNode;
        }

        protected boolean visitNode(ASTNode node) {
            int start = node.getStartPosition();
            int end = start + node.getLength();
            if (start == this.fOffset) {
                this.fNextNode = node;
                return true;
            }
            return start < this.fOffset && this.fOffset < end;
        }
    }
}

