/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.PackageSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackagesMessages;

class GotoPackageAction
extends Action {
    private PackageExplorerPart fPackageExplorer;

    GotoPackageAction(PackageExplorerPart part) {
        super(PackagesMessages.GotoPackage_action_label);
        this.setDescription(PackagesMessages.GotoPackage_action_description);
        this.fPackageExplorer = part;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.goto_package_action");
    }

    public void run() {
        try {
            Shell shell = JavaPlugin.getActiveWorkbenchShell();
            SelectionDialog dialog = this.createAllPackagesDialog(shell);
            dialog.setTitle(this.getDialogTitle());
            dialog.setMessage(PackagesMessages.GotoPackage_dialog_message);
            dialog.open();
            Object[] res = dialog.getResult();
            if (res != null && res.length == 1) {
                this.gotoPackage((IPackageFragment)res[0]);
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private SelectionDialog createAllPackagesDialog(Shell shell) throws JavaModelException {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        int flag = 8;
        PackageSelectionDialog dialog = new PackageSelectionDialog(shell, (IRunnableContext)progressService, flag, scope);
        dialog.setFilter("");
        dialog.setIgnoreCase(false);
        dialog.setMultipleSelection(false);
        return dialog;
    }

    private void gotoPackage(IPackageFragment p) {
        this.fPackageExplorer.selectReveal((ISelection)new StructuredSelection((Object)p));
        if (!p.equals(this.getSelectedElement())) {
            MessageDialog.openInformation((Shell)this.fPackageExplorer.getSite().getShell(), (String)this.getDialogTitle(), (String)Messages.format(PackagesMessages.PackageExplorer_element_not_present, p.getElementName()));
        }
    }

    private Object getSelectedElement() {
        return ((IStructuredSelection)this.fPackageExplorer.getSite().getSelectionProvider().getSelection()).getFirstElement();
    }

    private String getDialogTitle() {
        return PackagesMessages.GotoPackage_dialog_title;
    }
}

