/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackagesMessages;

public class GotoResourceAction
extends Action {
    private PackageExplorerPart fPackageExplorer;

    public GotoResourceAction(PackageExplorerPart explorer) {
        this.setText(PackagesMessages.GotoResource_action_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.goto_resource_action");
        this.fPackageExplorer = explorer;
    }

    public void run() {
        TreeViewer viewer = this.fPackageExplorer.getTreeViewer();
        GotoResourceDialog dialog = new GotoResourceDialog(this.fPackageExplorer.getSite().getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), (StructuredViewer)viewer);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0 || !(result[0] instanceof IResource)) {
            return;
        }
        StructuredSelection selection = null;
        IJavaElement element = JavaCore.create((IResource)((IResource)result[0]));
        selection = element != null && element.exists() ? new StructuredSelection((Object)element) : new StructuredSelection(result[0]);
        viewer.setSelection((ISelection)selection, true);
    }

    private static class GotoResourceDialog
    extends FilteredResourcesSelectionDialog {
        private IJavaModel fJavaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());

        public GotoResourceDialog(Shell parentShell, IContainer container, StructuredViewer viewer) {
            super(parentShell, false, container, 7);
            this.setTitle(PackagesMessages.GotoResource_dialog_title);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parentShell, "org.eclipse.wst.jsdt.ui.goto_resource_dialog");
        }

        protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
            return new GotoResourceFilter();
        }

        private class GotoResourceFilter
        extends FilteredResourcesSelectionDialog.ResourceFilter {
            private GotoResourceFilter() {
                super((FilteredResourcesSelectionDialog)GotoResourceDialog.this);
            }

            public boolean matchItem(Object item) {
                IResource resource = (IResource)item;
                return super.matchItem(item) && this.select(resource);
            }

            private boolean select(IResource resource) {
                IProject project = resource.getProject();
                try {
                    if (project.getNature("org.eclipse.wst.jsdt.core.jsNature") != null) {
                        return GotoResourceDialog.this.fJavaModel.contains(resource);
                    }
                }
                catch (CoreException coreException) {}
                return true;
            }

            public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
                if (!super.equalsFilter(filter)) {
                    return false;
                }
                return filter instanceof GotoResourceFilter;
            }
        }
    }
}

