/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;

public class JavaBasePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String JAVA_BASE_PREF_PAGE_ID = "org.eclipse.wst.jsdt.ui.preferences.JavaBasePreferencePage";
    private static final String OPEN_TYPE_HIERARCHY = "org.eclipse.wst.jsdt.ui.openTypeHierarchy";
    private static final String OPEN_TYPE_HIERARCHY_IN_PERSPECTIVE = "perspective";
    private static final String OPEN_TYPE_HIERARCHY_IN_VIEW_PART = "viewPart";
    private static final String DOUBLE_CLICK = "packageview.doubleclick";
    private static final String DOUBLE_CLICK_GOES_INTO = "packageview.gointo";
    private static final String DOUBLE_CLICK_EXPANDS = "packageview.doubleclick.expands";
    private ArrayList fCheckBoxes;
    private ArrayList fRadioButtons;
    private ArrayList fTextControls;

    public JavaBasePreferencePage() {
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.JavaBasePreferencePage_description);
        this.fRadioButtons = new ArrayList();
        this.fCheckBoxes = new ArrayList();
        this.fTextControls = new ArrayList();
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.java_base_preference_page_context");
    }

    private Button addRadioButton(Composite parent, String label, String key, String value) {
        GridData gd = new GridData(256);
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setData((Object)new String[]{key, value});
        button.setLayoutData((Object)gd);
        button.setSelection(value.equals(this.getPreferenceStore().getString(key)));
        this.fRadioButtons.add(button);
        return button;
    }

    private Button addCheckBox(Composite parent, String label, String key) {
        GridData gd = new GridData(256);
        Button button = new Button(parent, 32);
        button.setText(label);
        button.setData((Object)key);
        button.setLayoutData((Object)gd);
        button.setSelection(this.getPreferenceStore().getBoolean(key));
        this.fCheckBoxes.add(button);
        return button;
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        result.setLayout((Layout)layout);
        Group doubleClickGroup = new Group(result, 0);
        doubleClickGroup.setLayout((Layout)new GridLayout());
        doubleClickGroup.setLayoutData((Object)new GridData(768));
        doubleClickGroup.setText(PreferencesMessages.JavaBasePreferencePage_doubleclick_action);
        this.addRadioButton((Composite)doubleClickGroup, PreferencesMessages.JavaBasePreferencePage_doubleclick_gointo, DOUBLE_CLICK, DOUBLE_CLICK_GOES_INTO);
        this.addRadioButton((Composite)doubleClickGroup, PreferencesMessages.JavaBasePreferencePage_doubleclick_expand, DOUBLE_CLICK, DOUBLE_CLICK_EXPANDS);
        Group typeHierarchyGroup = new Group(result, 0);
        typeHierarchyGroup.setLayout((Layout)new GridLayout());
        typeHierarchyGroup.setLayoutData((Object)new GridData(768));
        typeHierarchyGroup.setText(PreferencesMessages.JavaBasePreferencePage_openTypeHierarchy);
        this.addRadioButton((Composite)typeHierarchyGroup, PreferencesMessages.JavaBasePreferencePage_inPerspective, OPEN_TYPE_HIERARCHY, OPEN_TYPE_HIERARCHY_IN_PERSPECTIVE);
        this.addRadioButton((Composite)typeHierarchyGroup, PreferencesMessages.JavaBasePreferencePage_inView, OPEN_TYPE_HIERARCHY, OPEN_TYPE_HIERARCHY_IN_VIEW_PART);
        Group group = new Group(result, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(PreferencesMessages.JavaBasePreferencePage_search);
        this.addCheckBox((Composite)group, PreferencesMessages.JavaBasePreferencePage_search_small_menu, "Search.usereducemenu");
        layout = new GridLayout();
        layout.numColumns = 2;
        Group dontAskGroup = new Group(result, 0);
        dontAskGroup.setLayout((Layout)layout);
        dontAskGroup.setLayoutData((Object)new GridData(768));
        dontAskGroup.setText(PreferencesMessages.JavaBasePreferencePage_dialogs);
        Label label = new Label((Composite)dontAskGroup, 64);
        label.setText(PreferencesMessages.JavaBasePreferencePage_do_not_hide_description);
        GridData data = new GridData(4, 2, true, false);
        data.widthHint = this.convertVerticalDLUsToPixels(50);
        label.setLayoutData((Object)data);
        Button clearButton = new Button((Composite)dontAskGroup, 8);
        clearButton.setText(PreferencesMessages.JavaBasePreferencePage_do_not_hide_button);
        clearButton.setLayoutData((Object)new GridData(4, 1, false, false));
        clearButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JavaBasePreferencePage.this.unhideAllDialogs();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                JavaBasePreferencePage.this.unhideAllDialogs();
            }
        });
        SWTUtil.setButtonDimensionHint(clearButton);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    protected final void unhideAllDialogs() {
        OptionalMessageDialog.clearAllRememberedStates();
        MessageDialog.openInformation((Shell)this.getShell(), (String)PreferencesMessages.JavaBasePreferencePage_do_not_hide_dialog_title, (String)PreferencesMessages.JavaBasePreferencePage_do_not_hide_dialog_message);
    }

    protected void performDefaults() {
        String key;
        Button button;
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fCheckBoxes.size()) {
            button = (Button)this.fCheckBoxes.get(i);
            key = (String)button.getData();
            button.setSelection(store.getDefaultBoolean(key));
            ++i;
        }
        i = 0;
        while (i < this.fRadioButtons.size()) {
            button = (Button)this.fRadioButtons.get(i);
            String[] info = (String[])button.getData();
            button.setSelection(info[1].equals(store.getDefaultString(info[0])));
            ++i;
        }
        i = 0;
        while (i < this.fTextControls.size()) {
            Text text = (Text)this.fTextControls.get(i);
            key = (String)text.getData();
            text.setText(store.getDefaultString(key));
            ++i;
        }
        super.performDefaults();
    }

    public boolean performOk() {
        String key;
        Button button;
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fCheckBoxes.size()) {
            button = (Button)this.fCheckBoxes.get(i);
            key = (String)button.getData();
            store.setValue(key, button.getSelection());
            ++i;
        }
        i = 0;
        while (i < this.fRadioButtons.size()) {
            button = (Button)this.fRadioButtons.get(i);
            if (button.getSelection()) {
                String[] info = (String[])button.getData();
                store.setValue(info[0], info[1]);
            }
            ++i;
        }
        i = 0;
        while (i < this.fTextControls.size()) {
            Text text = (Text)this.fTextControls.get(i);
            key = (String)text.getData();
            store.setValue(key, text.getText());
            ++i;
        }
        JavaPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }
}

