/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;

public class JavaBuildConfigurationBlock
extends OptionsConfigurationBlock {
    private static final String SETTINGS_SECTION_NAME = "JavaBuildConfigurationBlock";
    private static final OptionsConfigurationBlock.Key PREF_PB_MAX_PER_UNIT = JavaBuildConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.compiler.maxProblemPerUnit");
    private static final OptionsConfigurationBlock.Key PREF_RESOURCE_FILTER = JavaBuildConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.builder.resourceCopyExclusionFilter");
    private static final OptionsConfigurationBlock.Key PREF_BUILD_INVALID_CLASSPATH = JavaBuildConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.builder.invalidClasspath");
    private static final OptionsConfigurationBlock.Key PREF_BUILD_CLEAN_OUTPUT_FOLDER = JavaBuildConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.builder.cleanOutputFolder");
    private static final OptionsConfigurationBlock.Key PREF_ENABLE_EXCLUSION_PATTERNS = JavaBuildConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.classpath.exclusionPatterns");
    private static final OptionsConfigurationBlock.Key PREF_ENABLE_MULTIPLE_OUTPUT_LOCATIONS = JavaBuildConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.classpath.multipleOutputLocations");
    private static final OptionsConfigurationBlock.Key PREF_PB_INCOMPLETE_BUILDPATH = JavaBuildConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.incompleteClasspath");
    private static final OptionsConfigurationBlock.Key PREF_PB_CIRCULAR_BUILDPATH = JavaBuildConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.circularClasspath");
    private static final OptionsConfigurationBlock.Key PREF_PB_INCOMPATIBLE_JDK_LEVEL = JavaBuildConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.incompatibleJDKLevel");
    private static final OptionsConfigurationBlock.Key PREF_PB_DUPLICATE_RESOURCE = JavaBuildConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.builder.duplicateResourceTask");
    private static final OptionsConfigurationBlock.Key PREF_RECREATE_MODIFIED_CLASS_FILES = JavaBuildConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.builder.recreateModifiedClassFileInOutputFolder");
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String IGNORE = "ignore";
    private static final String ABORT = "abort";
    private static final String CLEAN = "clean";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private PixelConverter fPixelConverter;
    private IStatus fMaxNumberProblemsStatus = new StatusInfo();
    private IStatus fResourceFilterStatus = new StatusInfo();

    public JavaBuildConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, JavaBuildConfigurationBlock.getKeys(), container);
    }

    private static OptionsConfigurationBlock.Key[] getKeys() {
        OptionsConfigurationBlock.Key[] keys = new OptionsConfigurationBlock.Key[]{PREF_PB_MAX_PER_UNIT, PREF_RESOURCE_FILTER, PREF_BUILD_INVALID_CLASSPATH, PREF_PB_INCOMPLETE_BUILDPATH, PREF_PB_CIRCULAR_BUILDPATH, PREF_BUILD_CLEAN_OUTPUT_FOLDER, PREF_PB_DUPLICATE_RESOURCE, PREF_PB_INCOMPATIBLE_JDK_LEVEL, PREF_ENABLE_EXCLUSION_PATTERNS, PREF_ENABLE_MULTIPLE_OUTPUT_LOCATIONS, PREF_RECREATE_MODIFIED_CLASS_FILES};
        return keys;
    }

    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite mainComp = new Composite(parent, 0);
        mainComp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComp.setLayout((Layout)layout);
        Composite othersComposite = this.createBuildPathTabContent(mainComp);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(20);
        othersComposite.setLayoutData((Object)gridData);
        this.validateSettings(null, null, null);
        return mainComp;
    }

    private Composite createBuildPathTabContent(Composite parent) {
        String[] abortIgnoreValues = new String[]{ABORT, IGNORE};
        String[] cleanIgnoreValues = new String[]{CLEAN, IGNORE};
        String[] enableDisableValues = new String[]{ENABLED, DISABLED};
        String[] enableIgnoreValues = new String[]{ENABLED, IGNORE};
        String[] errorWarning = new String[]{ERROR, WARNING};
        String[] errorWarningLabels = new String[]{PreferencesMessages.JavaBuildConfigurationBlock_error, PreferencesMessages.JavaBuildConfigurationBlock_warning};
        String[] errorWarningIgnore = new String[]{ERROR, WARNING, IGNORE};
        String[] errorWarningIgnoreLabels = new String[]{PreferencesMessages.JavaBuildConfigurationBlock_error, PreferencesMessages.JavaBuildConfigurationBlock_warning, PreferencesMessages.JavaBuildConfigurationBlock_ignore};
        int nColumns = 3;
        ScrolledPageContent pageContent = new ScrolledPageContent(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite composite = pageContent.getBody();
        composite.setLayout((Layout)layout);
        String label = PreferencesMessages.JavaBuildConfigurationBlock_section_general;
        ExpandableComposite excomposite = this.createStyleSection(composite, label, nColumns);
        Composite othersComposite = new Composite((Composite)excomposite, 0);
        excomposite.setClient((Control)othersComposite);
        othersComposite.setLayout((Layout)new GridLayout(nColumns, false));
        label = PreferencesMessages.JavaBuildConfigurationBlock_pb_max_per_unit_label;
        Text text = this.addTextField(othersComposite, label, PREF_PB_MAX_PER_UNIT, 0, 0);
        GridData gd = (GridData)text.getLayoutData();
        gd.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(8);
        gd.horizontalAlignment = 3;
        text.setTextLimit(6);
        label = PreferencesMessages.JavaBuildConfigurationBlock_enable_exclusion_patterns_label;
        this.addCheckBox(othersComposite, label, PREF_ENABLE_EXCLUSION_PATTERNS, enableDisableValues, 0);
        label = PreferencesMessages.JavaBuildConfigurationBlock_enable_multiple_outputlocations_label;
        this.addCheckBox(othersComposite, label, PREF_ENABLE_MULTIPLE_OUTPUT_LOCATIONS, enableDisableValues, 0);
        label = PreferencesMessages.JavaBuildConfigurationBlock_section_build_path_problems;
        excomposite = this.createStyleSection(composite, label, nColumns);
        othersComposite = new Composite((Composite)excomposite, 0);
        excomposite.setClient((Control)othersComposite);
        othersComposite.setLayout((Layout)new GridLayout(nColumns, false));
        label = PreferencesMessages.JavaBuildConfigurationBlock_build_invalid_classpath_label;
        this.addCheckBox(othersComposite, label, PREF_BUILD_INVALID_CLASSPATH, abortIgnoreValues, 0);
        label = PreferencesMessages.JavaBuildConfigurationBlock_pb_incomplete_build_path_label;
        this.addComboBox(othersComposite, label, PREF_PB_INCOMPLETE_BUILDPATH, errorWarning, errorWarningLabels, 0);
        label = PreferencesMessages.JavaBuildConfigurationBlock_pb_build_path_cycles_label;
        this.addComboBox(othersComposite, label, PREF_PB_CIRCULAR_BUILDPATH, errorWarning, errorWarningLabels, 0);
        label = PreferencesMessages.JavaBuildConfigurationBlock_pb_check_prereq_binary_level_label;
        this.addComboBox(othersComposite, label, PREF_PB_INCOMPATIBLE_JDK_LEVEL, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.JavaBuildConfigurationBlock_section_output_folder;
        excomposite = this.createStyleSection(composite, label, nColumns);
        othersComposite = new Composite((Composite)excomposite, 0);
        excomposite.setClient((Control)othersComposite);
        othersComposite.setLayout((Layout)new GridLayout(nColumns, false));
        label = PreferencesMessages.JavaBuildConfigurationBlock_pb_duplicate_resources_label;
        this.addComboBox(othersComposite, label, PREF_PB_DUPLICATE_RESOURCE, errorWarning, errorWarningLabels, 0);
        label = PreferencesMessages.JavaBuildConfigurationBlock_build_clean_outputfolder_label;
        this.addCheckBox(othersComposite, label, PREF_BUILD_CLEAN_OUTPUT_FOLDER, cleanIgnoreValues, 0);
        label = PreferencesMessages.JavaBuildConfigurationBlock_build_recreate_modified;
        this.addCheckBox(othersComposite, label, PREF_RECREATE_MODIFIED_CLASS_FILES, enableIgnoreValues, 0);
        label = PreferencesMessages.JavaBuildConfigurationBlock_resource_filter_label;
        text = this.addTextField(othersComposite, label, PREF_RESOURCE_FILTER, 0, 0);
        gd = (GridData)text.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(10);
        Label description = new Label(othersComposite, 64);
        description.setText(PreferencesMessages.JavaBuildConfigurationBlock_resource_filter_description);
        gd = new GridData(256);
        gd.horizontalSpan = nColumns;
        gd.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(60);
        description.setLayoutData((Object)gd);
        IDialogSettings section = JavaPlugin.getDefault().getDialogSettings().getSection(SETTINGS_SECTION_NAME);
        this.restoreSectionExpansionStates(section);
        return pageContent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        if (!this.areSettingsEnabled()) {
            return;
        }
        if (changedKey != null) {
            if (PREF_PB_MAX_PER_UNIT.equals(changedKey)) {
                this.fMaxNumberProblemsStatus = this.validateMaxNumberProblems();
            } else {
                if (!PREF_RESOURCE_FILTER.equals(changedKey)) return;
                this.fResourceFilterStatus = this.validateResourceFilters();
            }
        } else {
            this.updateEnableStates();
            this.fMaxNumberProblemsStatus = this.validateMaxNumberProblems();
            this.fResourceFilterStatus = this.validateResourceFilters();
        }
        IStatus status = StatusUtil.getMostSevere(new IStatus[]{this.fMaxNumberProblemsStatus, this.fResourceFilterStatus});
        this.fContext.statusChanged(status);
    }

    private void updateEnableStates() {
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = PreferencesMessages.JavaBuildConfigurationBlock_needsbuild_title;
        String message = workspaceSettings ? PreferencesMessages.JavaBuildConfigurationBlock_needsfullbuild_message : PreferencesMessages.JavaBuildConfigurationBlock_needsprojectbuild_message;
        return new String[]{title, message};
    }

    private IStatus validateMaxNumberProblems() {
        String number = this.getValue(PREF_PB_MAX_PER_UNIT);
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(PreferencesMessages.JavaBuildConfigurationBlock_empty_input);
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value <= 0) {
                    status.setError(Messages.format(PreferencesMessages.JavaBuildConfigurationBlock_invalid_input, number));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(Messages.format(PreferencesMessages.JavaBuildConfigurationBlock_invalid_input, number));
            }
        }
        return status;
    }

    private IStatus validateResourceFilters() {
        String text = this.getValue(PREF_RESOURCE_FILTER);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String[] filters = this.getTokens(text, ",");
        int i = 0;
        while (i < filters.length) {
            IStatus status;
            String fileName = filters[i].replace('*', 'x');
            int resourceType = 1;
            int lastCharacter = fileName.length() - 1;
            if (lastCharacter >= 0 && fileName.charAt(lastCharacter) == '/') {
                fileName = fileName.substring(0, lastCharacter);
                resourceType = 2;
            }
            if ((status = workspace.validateName(fileName, resourceType)).matches(4)) {
                String message = Messages.format(PreferencesMessages.JavaBuildConfigurationBlock_filter_invalidsegment_error, status.getMessage());
                return new StatusInfo(4, message);
            }
            ++i;
        }
        return new StatusInfo();
    }

    public void dispose() {
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings().addNewSection(SETTINGS_SECTION_NAME);
        this.storeSectionExpansionStates(settings);
        super.dispose();
    }
}

