/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.JavaPreview;

public class SnippetPreview
extends JavaPreview {
    private ArrayList fSnippets = new ArrayList();

    public SnippetPreview(Map workingValues, Composite parent) {
        super(workingValues, parent);
    }

    protected void doFormatPreview() {
        if (this.fSnippets.isEmpty()) {
            this.fPreviewDocument.set("");
            return;
        }
        StringBuffer buffer = new StringBuffer();
        Iterator iter = this.fSnippets.iterator();
        while (iter.hasNext()) {
            String formattedSource;
            PreviewSnippet snippet = (PreviewSnippet)iter.next();
            try {
                formattedSource = CodeFormatterUtil.format(snippet.kind, snippet.source, 0, null, "\n", this.fWorkingValues);
            }
            catch (Exception e) {
                Status status = new Status(4, JavaPlugin.getPluginId(), 10001, FormatterMessages.JavaPreview_formatter_exception, (Throwable)e);
                JavaPlugin.log((IStatus)status);
                continue;
            }
            buffer.append("\n");
            buffer.append(formattedSource);
            buffer.append("\n");
            buffer.append("\n");
        }
        this.fPreviewDocument.set(buffer.toString());
    }

    public void add(PreviewSnippet snippet) {
        this.fSnippets.add(snippet);
    }

    public void remove(PreviewSnippet snippet) {
        this.fSnippets.remove(snippet);
    }

    public void addAll(Collection snippets) {
        this.fSnippets.addAll(snippets);
    }

    public void clear() {
        this.fSnippets.clear();
    }

    public static final class PreviewSnippet {
        public String header;
        public final String source;
        public final int kind;

        public PreviewSnippet(int kind, String source) {
            this.kind = kind;
            this.source = source;
        }
    }
}

