/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.PromoteTempToFieldRefactoring;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;

public class FieldNameProcessor
implements IContentAssistProcessor,
ISubjectControlContentAssistProcessor {
    private String[] fFieldNameProposals;
    private String fErrorMessage;
    private ImageDescriptorRegistry fImageRegistry = JavaPlugin.getImageDescriptorRegistry();
    private PromoteTempToFieldRefactoring fRefactoring;

    public FieldNameProcessor(String[] guessedFieldNames, PromoteTempToFieldRefactoring refactoring) {
        this.fRefactoring = refactoring;
        this.fFieldNameProposals = refactoring.guessFieldNames();
        Arrays.sort(this.fFieldNameProposals);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        Assert.isTrue((boolean)false, (String)"ITextViewer not supported");
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        Assert.isTrue((boolean)false, (String)"ITextViewer not supported");
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public IContextInformation[] computeContextInformation(IContentAssistSubjectControl contentAssistSubject, int documentOffset) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl contentAssistSubject, int documentOffset) {
        if (this.fFieldNameProposals.length == 0) {
            return null;
        }
        String input = contentAssistSubject.getDocument().get();
        ArrayList<JavaCompletionProposal> proposals = new ArrayList<JavaCompletionProposal>();
        String prefix = input.substring(0, documentOffset);
        ImageDescriptor imageDescriptor = JavaElementImageProvider.getFieldImageDescriptor(false, this.fRefactoring.getVisibility());
        Image image = this.fImageRegistry.get(imageDescriptor);
        int i = 0;
        while (i < this.fFieldNameProposals.length) {
            String tempName = this.fFieldNameProposals[i];
            if (tempName.length() != 0 && tempName.startsWith(prefix)) {
                JavaCompletionProposal proposal = new JavaCompletionProposal(tempName, 0, input.length(), image, tempName, 0);
                proposals.add(proposal);
            }
            ++i;
        }
        this.fErrorMessage = proposals.size() > 0 ? null : JavaUIMessages.JavaEditor_codeassist_noCompletions;
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }
}

