/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.ui.StandardJavaElementContentProvider;

public final class DestinationContentProvider
extends StandardJavaElementContentProvider {
    private IReorgDestinationValidator fValidator;

    public DestinationContentProvider(IReorgDestinationValidator validator) {
        super(true);
        this.fValidator = validator;
    }

    public boolean hasChildren(Object element) {
        IResource resource;
        if (element instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)element;
            if (!this.fValidator.canChildrenBeDestinations(javaElement)) {
                return false;
            }
            if (javaElement.getElementType() == 3 && ((IPackageFragmentRoot)javaElement).isArchive()) {
                return false;
            }
        } else if (element instanceof IResource && !this.fValidator.canChildrenBeDestinations(resource = (IResource)element)) {
            return false;
        }
        return super.hasChildren(element);
    }

    public Object[] getChildren(Object element) {
        try {
            if (element instanceof IJavaModel) {
                return DestinationContentProvider.concatenate(this.getJavaProjects((IJavaModel)element), DestinationContentProvider.getOpenNonJavaProjects((IJavaModel)element));
            }
            Object[] children = this.doGetChildren(element);
            ArrayList<Object> result = new ArrayList<Object>(children.length);
            int i = 0;
            while (i < children.length) {
                IResource resource;
                if (children[i] instanceof IJavaElement) {
                    IJavaElement javaElement = (IJavaElement)children[i];
                    if (this.fValidator.canElementBeDestination(javaElement) || this.fValidator.canChildrenBeDestinations(javaElement)) {
                        result.add(javaElement);
                    }
                } else if (children[i] instanceof IResource && (this.fValidator.canElementBeDestination(resource = (IResource)children[i]) || this.fValidator.canChildrenBeDestinations(resource))) {
                    result.add(resource);
                }
                ++i;
            }
            return result.toArray();
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return new Object[0];
        }
    }

    private Object[] doGetChildren(Object parentElement) {
        if (parentElement instanceof IContainer) {
            IContainer container = (IContainer)parentElement;
            return this.getResources(container);
        }
        return super.getChildren(parentElement);
    }

    private Object[] getResources(IContainer container) {
        try {
            Object[] members = container.members();
            IJavaProject javaProject = JavaCore.create((IProject)container.getProject());
            if (javaProject == null || !javaProject.exists()) {
                return members;
            }
            boolean isFolderOnClasspath = javaProject.isOnClasspath((IResource)container);
            ArrayList<Object> nonJavaResources = new ArrayList<Object>();
            int i = 0;
            while (i < members.length) {
                Object member = members[i];
                if (isFolderOnClasspath) {
                    if (javaProject.findPackageFragmentRoot(member.getFullPath()) == null) {
                        nonJavaResources.add(member);
                    }
                } else if (!javaProject.isOnClasspath((IResource)member)) {
                    nonJavaResources.add(member);
                }
                ++i;
            }
            return nonJavaResources.toArray();
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }

    private static Object[] getOpenNonJavaProjects(IJavaModel model) throws JavaModelException {
        Object[] nonJavaProjects = model.getNonJavaResources();
        ArrayList<IProject> result = new ArrayList<IProject>(nonJavaProjects.length);
        int i = 0;
        while (i < nonJavaProjects.length) {
            IProject project = (IProject)nonJavaProjects[i];
            if (project.isOpen()) {
                result.add(project);
            }
            ++i;
        }
        return result.toArray();
    }
}

