/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.actions.CopyQualifiedNameAction;
import org.eclipse.wst.jsdt.internal.ui.dnd.JdtViewerDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.dnd.ResourceTransferDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.packageview.SelectionTransferDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.search.GroupAction;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchContentProvider;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchEditorOpener;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchResult;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchTableContentProvider;
import org.eclipse.wst.jsdt.internal.ui.search.LevelTreeContentProvider;
import org.eclipse.wst.jsdt.internal.ui.search.NewSearchViewActionGroup;
import org.eclipse.wst.jsdt.internal.ui.search.PostfixLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.search.SortAction;
import org.eclipse.wst.jsdt.internal.ui.search.SortingLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredViewersManager;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProblemTableViewer;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;
import org.eclipse.wst.jsdt.ui.search.IMatchPresentation;

public class JavaSearchResultPage
extends AbstractTextSearchViewPage
implements IAdaptable {
    private static final int DEFAULT_ELEMENT_LIMIT = 1000;
    private static final String FALSE = "FALSE";
    private static final String TRUE = "TRUE";
    private static final String KEY_GROUPING = "org.eclipse.wst.jsdt.search.resultpage.grouping";
    private static final String KEY_SORTING = "org.eclipse.wst.jsdt.search.resultpage.sorting";
    private static final String KEY_LIMIT_ENABLED = "org.eclipse.wst.jsdt.search.resultpage.limit_enabled";
    private static final String KEY_LIMIT = "org.eclipse.wst.jsdt.search.resultpage.limit";
    private static final String GROUP_GROUPING = "org.eclipse.wst.jsdt.search.resultpage.grouping";
    private static final String GROUP_FILTERING = "org.eclipse.wst.jsdt.search.resultpage.filtering";
    private NewSearchViewActionGroup fActionGroup;
    private JavaSearchContentProvider fContentProvider;
    private int fCurrentSortOrder;
    private SortAction fSortByNameAction;
    private SortAction fSortByParentName;
    private SortAction fSortByPathAction;
    private GroupAction fGroupTypeAction;
    private GroupAction fGroupFileAction;
    private GroupAction fGroupPackageAction;
    private GroupAction fGroupProjectAction;
    private SelectionDispatchAction fCopyQualifiedNameAction = null;
    private SortingLabelProvider fSortingLabelProvider;
    private int fCurrentGrouping;
    private static final String[] SHOW_IN_TARGETS = new String[]{"org.eclipse.wst.jsdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
    public static final IShowInTargetList SHOW_IN_TARGET_LIST = new IShowInTargetList(){

        public String[] getShowInTargetIds() {
            return SHOW_IN_TARGETS;
        }
    };
    private JavaSearchEditorOpener fEditorOpener = new JavaSearchEditorOpener();
    static /* synthetic */ Class class$0;

    public JavaSearchResultPage() {
        this.initSortActions();
        this.initGroupingActions();
        this.setElementLimit(new Integer(1000));
    }

    private void initSortActions() {
        this.fSortByNameAction = new SortAction(SearchMessages.JavaSearchResultPage_sortByName, this, 1);
        this.fSortByPathAction = new SortAction(SearchMessages.JavaSearchResultPage_sortByPath, this, 3);
        this.fSortByParentName = new SortAction(SearchMessages.JavaSearchResultPage_sortByParentName, this, 2);
    }

    private void initGroupingActions() {
        this.fGroupProjectAction = new GroupAction(SearchMessages.JavaSearchResultPage_groupby_project, SearchMessages.JavaSearchResultPage_groupby_project_tooltip, this, 4);
        JavaPluginImages.setLocalImageDescriptors((IAction)this.fGroupProjectAction, "prj_mode.gif");
        this.fGroupFileAction = new GroupAction(SearchMessages.JavaSearchResultPage_groupby_file, SearchMessages.JavaSearchResultPage_groupby_file_tooltip, this, 2);
        JavaPluginImages.setLocalImageDescriptors((IAction)this.fGroupFileAction, "file_mode.gif");
        this.fGroupTypeAction = new GroupAction(SearchMessages.JavaSearchResultPage_groupby_type, SearchMessages.JavaSearchResultPage_groupby_type_tooltip, this, 1);
        JavaPluginImages.setLocalImageDescriptors((IAction)this.fGroupTypeAction, "type_mode.gif");
    }

    public void setViewPart(ISearchResultViewPart part) {
        super.setViewPart(part);
        this.fActionGroup = new NewSearchViewActionGroup((IViewPart)part);
    }

    public void showMatch(Match match, int offset, int length, boolean activate) throws PartInitException {
        IEditorPart editor;
        try {
            editor = this.fEditorOpener.openMatch(match);
        }
        catch (JavaModelException e) {
            throw new PartInitException(e.getStatus());
        }
        if (editor != null && activate) {
            editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
        }
        Object element = match.getElement();
        if (editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            textEditor.selectAndReveal(offset, length);
        } else if (editor != null) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                this.showWithMarker(editor, file, offset, length);
            }
        } else {
            JavaSearchResult result = (JavaSearchResult)this.getInput();
            IMatchPresentation participant = result.getSearchParticpant(element);
            if (participant != null) {
                participant.showMatch(match, offset, length, activate);
            }
        }
    }

    private void showWithMarker(IEditorPart editor, IFile file, int offset, int length) throws PartInitException {
        try {
            IMarker marker = file.createMarker("org.eclipse.search.searchmarker");
            HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
            attributes.put("charStart", new Integer(offset));
            attributes.put("charEnd", new Integer(offset + length));
            marker.setAttributes(attributes);
            IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
            marker.delete();
        }
        catch (CoreException e) {
            throw new PartInitException(SearchMessages.JavaSearchResultPage_error_marker, (Throwable)e);
        }
    }

    private SelectionDispatchAction getCopyQualifiedNameAction() {
        if (this.fCopyQualifiedNameAction == null) {
            this.fCopyQualifiedNameAction = new CopyQualifiedNameAction((IWorkbenchSite)this.getSite());
        }
        return this.fCopyQualifiedNameAction;
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        this.addSortActions(mgr);
        mgr.appendToGroup("group.edit", (IAction)this.getCopyQualifiedNameAction());
        this.fActionGroup.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
        this.fActionGroup.fillContextMenu(mgr);
    }

    private void addSortActions(IMenuManager mgr) {
        if (this.getLayout() != 1) {
            return;
        }
        MenuManager sortMenu = new MenuManager(SearchMessages.JavaSearchResultPage_sortBylabel);
        sortMenu.add((IAction)this.fSortByNameAction);
        sortMenu.add((IAction)this.fSortByPathAction);
        sortMenu.add((IAction)this.fSortByParentName);
        this.fSortByNameAction.setChecked(this.fCurrentSortOrder == this.fSortByNameAction.getSortOrder());
        this.fSortByPathAction.setChecked(this.fCurrentSortOrder == this.fSortByPathAction.getSortOrder());
        this.fSortByParentName.setChecked(this.fCurrentSortOrder == this.fSortByParentName.getSortOrder());
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)sortMenu);
    }

    protected void fillToolbar(IToolBarManager tbm) {
        super.fillToolbar(tbm);
        IActionBars actionBars = this.getSite().getActionBars();
        if (actionBars != null) {
            actionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.CopyQualifiedName", (IAction)this.getCopyQualifiedNameAction());
        }
        if (this.getLayout() != 1) {
            this.addGroupActions(tbm);
        }
    }

    private void addGroupActions(IToolBarManager mgr) {
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)new Separator("org.eclipse.wst.jsdt.search.resultpage.grouping"));
        mgr.appendToGroup("org.eclipse.wst.jsdt.search.resultpage.grouping", (IAction)this.fGroupProjectAction);
        mgr.appendToGroup("org.eclipse.wst.jsdt.search.resultpage.grouping", (IAction)this.fGroupFileAction);
        mgr.appendToGroup("org.eclipse.wst.jsdt.search.resultpage.grouping", (IAction)this.fGroupTypeAction);
        this.updateGroupingActions();
    }

    private void updateGroupingActions() {
        this.fGroupProjectAction.setChecked(this.fCurrentGrouping == 4);
        this.fGroupFileAction.setChecked(this.fCurrentGrouping == 2);
        this.fGroupTypeAction.setChecked(this.fCurrentGrouping == 1);
    }

    public void dispose() {
        this.fActionGroup.dispose();
        super.dispose();
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    private void addDragAdapters(StructuredViewer viewer) {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance()};
        int ops = 5;
        TransferDragSourceListener[] dragListeners = new TransferDragSourceListener[]{new SelectionTransferDragAdapter((ISelectionProvider)viewer), new ResourceTransferDragAdapter((ISelectionProvider)viewer)};
        viewer.addDragSupport(ops, transfers, (DragSourceListener)new JdtViewerDragAdapter(viewer, dragListeners));
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setUseHashlookup(true);
        this.fSortingLabelProvider = new SortingLabelProvider(this);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider(this.fSortingLabelProvider, false));
        this.fContentProvider = new JavaSearchTableContentProvider(this);
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
        viewer.setComparator((ViewerComparator)new DecoratorIgnoringViewerSorter(this.fSortingLabelProvider));
        this.setSortOrder(this.fCurrentSortOrder);
        this.addDragAdapters((StructuredViewer)viewer);
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        PostfixLabelProvider postfixLabelProvider = new PostfixLabelProvider(this);
        viewer.setUseHashlookup(true);
        viewer.setComparator((ViewerComparator)new DecoratorIgnoringViewerSorter(postfixLabelProvider));
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider(postfixLabelProvider, false));
        this.fContentProvider = new LevelTreeContentProvider(this, this.fCurrentGrouping);
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.addDragAdapters((StructuredViewer)viewer);
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        ProblemTreeViewer problemTreeViewer = new ProblemTreeViewer(parent, 770);
        ColoredViewersManager.install((StructuredViewer)problemTreeViewer);
        return problemTreeViewer;
    }

    protected TableViewer createTableViewer(Composite parent) {
        ProblemTableViewer problemTableViewer = new ProblemTableViewer(parent, 770);
        ColoredViewersManager.install((StructuredViewer)problemTableViewer);
        return problemTableViewer;
    }

    void setSortOrder(int order) {
        if (this.fSortingLabelProvider != null) {
            this.fCurrentSortOrder = order;
            StructuredViewer viewer = this.getViewer();
            this.fSortingLabelProvider.setOrder(order);
            viewer.refresh();
            this.getSettings().put(KEY_SORTING, this.fCurrentSortOrder);
        }
    }

    public void init(IPageSite site) {
        super.init(site);
        IMenuManager menuManager = site.getActionBars().getMenuManager();
        menuManager.insertBefore("group.properties", (IContributionItem)new Separator(GROUP_FILTERING));
        this.fActionGroup.fillActionBars(site.getActionBars());
        menuManager.appendToGroup("group.properties", (IAction)new Action(SearchMessages.JavaSearchResultPage_preferences_label){

            public void run() {
                String pageId = "org.eclipse.search.preferences.SearchPreferencePage";
                PreferencesUtil.createPreferenceDialogOn((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)pageId, null, null).open();
            }
        });
    }

    void setGrouping(int grouping) {
        this.fCurrentGrouping = grouping;
        StructuredViewer viewer = this.getViewer();
        LevelTreeContentProvider cp = (LevelTreeContentProvider)viewer.getContentProvider();
        cp.setLevel(grouping);
        this.updateGroupingActions();
        this.getSettings().put("org.eclipse.wst.jsdt.search.resultpage.grouping", this.fCurrentGrouping);
        this.getViewPart().updateLabel();
    }

    protected StructuredViewer getViewer() {
        return super.getViewer();
    }

    public void restoreState(IMemento memento) {
        super.restoreState(memento);
        int sortOrder = 1;
        int grouping = 3;
        int elementLimit = 1000;
        try {
            sortOrder = this.getSettings().getInt(KEY_SORTING);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            grouping = this.getSettings().getInt("org.eclipse.wst.jsdt.search.resultpage.grouping");
        }
        catch (NumberFormatException numberFormatException) {}
        if (FALSE.equals(this.getSettings().get(KEY_LIMIT_ENABLED))) {
            elementLimit = -1;
        } else {
            try {
                elementLimit = this.getSettings().getInt(KEY_LIMIT);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (memento != null) {
            Integer value = memento.getInteger("org.eclipse.wst.jsdt.search.resultpage.grouping");
            if (value != null) {
                grouping = value;
            }
            if ((value = memento.getInteger(KEY_SORTING)) != null) {
                sortOrder = value;
            }
            boolean limitElements = !FALSE.equals(memento.getString(KEY_LIMIT_ENABLED));
            value = memento.getInteger(KEY_LIMIT);
            if (value != null) {
                elementLimit = limitElements ? value : -1;
            }
        }
        this.fCurrentGrouping = grouping;
        this.fCurrentSortOrder = sortOrder;
        this.setElementLimit(new Integer(elementLimit));
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putInteger("org.eclipse.wst.jsdt.search.resultpage.grouping", this.fCurrentGrouping);
        memento.putInteger(KEY_SORTING, this.fCurrentSortOrder);
        int limit = this.getElementLimit();
        if (limit != -1) {
            memento.putString(KEY_LIMIT_ENABLED, TRUE);
        } else {
            memento.putString(KEY_LIMIT_ENABLED, FALSE);
        }
        memento.putInteger(KEY_LIMIT, limit);
    }

    private boolean isQueryRunning() {
        AbstractTextSearchResult result = this.getInput();
        if (result != null) {
            return NewSearchUI.isQueryRunning((ISearchQuery)result.getQuery());
        }
        return false;
    }

    public String getLabel() {
        String label = super.getLabel();
        AbstractTextSearchResult input = this.getInput();
        if (input != null && input.getActiveMatchFilters() != null && input.getActiveMatchFilters().length > 0) {
            if (this.isQueryRunning()) {
                String message = SearchMessages.JavaSearchResultPage_filtered_message;
                return Messages.format(message, new Object[]{label});
            }
            int filteredOut = input.getMatchCount() - this.getFilteredMatchCount();
            String message = SearchMessages.JavaSearchResultPage_filteredWithCount_message;
            return Messages.format(message, new Object[]{label, String.valueOf(filteredOut)});
        }
        return label;
    }

    private int getFilteredMatchCount() {
        StructuredViewer viewer = this.getViewer();
        if (viewer instanceof TreeViewer) {
            ITreeContentProvider tp = (ITreeContentProvider)viewer.getContentProvider();
            return this.getMatchCount(tp, this.getRootElements((TreeViewer)this.getViewer()));
        }
        return this.getMatchCount((TableViewer)viewer);
    }

    private Object[] getRootElements(TreeViewer viewer) {
        Tree t = viewer.getTree();
        TreeItem[] roots = t.getItems();
        Object[] elements = new Object[roots.length];
        int i = 0;
        while (i < elements.length) {
            elements[i] = roots[i].getData();
            ++i;
        }
        return elements;
    }

    private Object[] getRootElements(TableViewer viewer) {
        Table t = viewer.getTable();
        TableItem[] roots = t.getItems();
        Object[] elements = new Object[roots.length];
        int i = 0;
        while (i < elements.length) {
            elements[i] = roots[i].getData();
            ++i;
        }
        return elements;
    }

    private int getMatchCount(ITreeContentProvider cp, Object[] elements) {
        int count = 0;
        int j = 0;
        while (j < elements.length) {
            count += this.getDisplayedMatchCount(elements[j]);
            Object[] children = cp.getChildren(elements[j]);
            count += this.getMatchCount(cp, children);
            ++j;
        }
        return count;
    }

    private int getMatchCount(TableViewer viewer) {
        Object[] elements = this.getRootElements(viewer);
        int count = 0;
        int i = 0;
        while (i < elements.length) {
            count += this.getDisplayedMatchCount(elements[i]);
            ++i;
        }
        return count;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return SHOW_IN_TARGET_LIST;
        }
        return null;
    }

    protected void handleOpen(OpenEvent event) {
        Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if ((firstElement instanceof ICompilationUnit || firstElement instanceof IClassFile || firstElement instanceof IMember) && this.getDisplayedMatchCount(firstElement) == 0) {
            try {
                this.fEditorOpener.openElement(firstElement);
            }
            catch (CoreException e) {
                ExceptionHandler.handle(e, this.getSite().getShell(), SearchMessages.JavaSearchResultPage_open_editor_error_title, SearchMessages.JavaSearchResultPage_open_editor_error_message);
            }
            return;
        }
        super.handleOpen(event);
    }

    public void setElementLimit(Integer elementLimit) {
        super.setElementLimit(elementLimit);
        int limit = elementLimit;
        this.getSettings().put(KEY_LIMIT, limit);
        this.getSettings().put(KEY_LIMIT_ENABLED, limit != -1 ? TRUE : FALSE);
    }

    public static class DecoratorIgnoringViewerSorter
    extends ViewerComparator {
        private final ILabelProvider fLabelProvider;

        public DecoratorIgnoringViewerSorter(ILabelProvider labelProvider) {
            this.fLabelProvider = labelProvider;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            String name1 = this.fLabelProvider.getText(e1);
            String name2 = this.fLabelProvider.getText(e2);
            if (name1 == null) {
                name1 = "";
            }
            if (name2 == null) {
                name2 = "";
            }
            return this.getComparator().compare(name1, name2);
        }
    }
}

