/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.wst.jsdt.internal.ui.search.OccurrencesSearchResult;

public class OccurrencesSearchQuery
implements ISearchQuery {
    private final OccurrencesSearchResult fResult;
    private IOccurrencesFinder fFinder;
    private IDocument fDocument;
    private final IJavaElement fElement;
    private final String fJobLabel;
    private final String fSingularLabel;
    private final String fPluralLabel;
    private final String fName;

    public OccurrencesSearchQuery(IOccurrencesFinder finder, IDocument document, IJavaElement element) {
        this.fFinder = finder;
        this.fDocument = document;
        this.fElement = element;
        this.fJobLabel = this.fFinder.getJobLabel();
        this.fResult = new OccurrencesSearchResult(this);
        this.fSingularLabel = this.fFinder.getUnformattedSingularLabel();
        this.fPluralLabel = this.fFinder.getUnformattedPluralLabel();
        this.fName = this.fFinder.getElementName();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus run(IProgressMonitor monitor) {
        if (this.fFinder == null) {
            return new StatusInfo(4, "Query has already been running");
        }
        try {
            this.fFinder.perform();
            ArrayList resultingMatches = new ArrayList();
            this.fFinder.collectOccurrenceMatches(this.fElement, this.fDocument, resultingMatches);
            if (!resultingMatches.isEmpty()) {
                this.fResult.addMatches(resultingMatches.toArray(new Match[resultingMatches.size()]));
            }
            this.fFinder = null;
            this.fDocument = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    public String getLabel() {
        return this.fJobLabel;
    }

    public String getResultLabel(int nMatches) {
        if (nMatches == 1) {
            return Messages.format(this.fSingularLabel, new Object[]{this.fName, this.fElement.getElementName()});
        }
        return Messages.format(this.fPluralLabel, new Object[]{this.fName, new Integer(nMatches), this.fElement.getElementName()});
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.fResult;
    }
}

