/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.comment;

import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.formatter.CodeFormatter;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class CommentFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList fDocuments = new LinkedList();
    private final LinkedList fPartitions = new LinkedList();
    private int fLastDocumentHash;
    private int fLastHeaderHash;
    private int fLastMainTokenEnd = -1;
    private int fLastDocumentsHeaderEnd;

    public void format() {
        IDocument document = (IDocument)this.fDocuments.getFirst();
        TextEdit edit = this.calculateTextEdit();
        if (edit == null) {
            return;
        }
        try {
            edit.apply(document);
        }
        catch (MalformedTreeException x) {
            JavaPlugin.log(x);
        }
        catch (BadLocationException x) {
            JavaPlugin.log(x);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TextEdit calculateTextEdit() {
        boolean wasLineComment;
        boolean wasBlockComment;
        TextEdit edit;
        Map preferences;
        block16: {
            super.format();
            IDocument document = (IDocument)this.fDocuments.removeFirst();
            TypedPosition position = (TypedPosition)this.fPartitions.removeFirst();
            if (document == null) return null;
            if (position == null) {
                return null;
            }
            preferences = this.getPreferences();
            boolean isFormattingHeader = "true".equals(preferences.get("org.eclipse.wst.jsdt.core.formatter.comment.format_header"));
            int documentsHeaderEnd = this.computeHeaderEnd(document, preferences);
            edit = null;
            if (position.offset >= documentsHeaderEnd) {
                try {
                    int sourceOffset = document.getLineOffset(document.getLineOfOffset(position.getOffset()));
                    int partitionOffset = position.getOffset() - sourceOffset;
                    int sourceLength = partitionOffset + position.getLength();
                    String source = document.get(sourceOffset, sourceLength);
                    CodeFormatter commentFormatter = ToolFactory.createCodeFormatter((Map)preferences, (int)ToolFactory.M_FORMAT_EXISTING);
                    int indentationLevel = this.inferIndentationLevel(source.substring(0, partitionOffset), CommentFormattingStrategy.getTabSize(preferences), CommentFormattingStrategy.getIndentSize(preferences));
                    edit = commentFormatter.format(CommentFormattingStrategy.getKindForPartitionType(position.getType()), source, partitionOffset, position.getLength(), indentationLevel, TextUtilities.getDefaultLineDelimiter((IDocument)document));
                    if (edit == null) return edit;
                    edit.moveTree(sourceOffset);
                    return edit;
                }
                catch (BadLocationException x) {
                    JavaPlugin.log(x);
                    return edit;
                }
            }
            if (!isFormattingHeader) return edit;
            boolean wasJavaDoc = "true".equals(preferences.get("org.eclipse.wst.jsdt.core.formatter.comment.format_javadoc_comments"));
            if (!wasJavaDoc) {
                preferences.put("org.eclipse.wst.jsdt.core.formatter.comment.format_javadoc_comments", "true");
            }
            if (!(wasBlockComment = "true".equals(preferences.get("org.eclipse.wst.jsdt.core.formatter.comment.format_block_comments")))) {
                preferences.put("org.eclipse.wst.jsdt.core.formatter.comment.format_block_comments", "true");
            }
            if (!(wasLineComment = "true".equals(preferences.get("org.eclipse.wst.jsdt.core.formatter.comment.format_line_comments")))) {
                preferences.put("org.eclipse.wst.jsdt.core.formatter.comment.format_line_comments", "true");
            }
            try {
                try {
                    int sourceOffset = document.getLineOffset(document.getLineOfOffset(position.getOffset()));
                    int partitionOffset = position.getOffset() - sourceOffset;
                    int sourceLength = partitionOffset + position.getLength();
                    String source = document.get(sourceOffset, sourceLength);
                    CodeFormatter commentFormatter = ToolFactory.createCodeFormatter((Map)preferences);
                    int indentationLevel = this.inferIndentationLevel(source.substring(0, partitionOffset), CommentFormattingStrategy.getTabSize(preferences), CommentFormattingStrategy.getIndentSize(preferences));
                    edit = commentFormatter.format(CommentFormattingStrategy.getKindForPartitionType(position.getType()), source, partitionOffset, position.getLength(), indentationLevel, TextUtilities.getDefaultLineDelimiter((IDocument)document));
                    if (edit != null) {
                        edit.moveTree(sourceOffset);
                    }
                }
                catch (BadLocationException x) {
                    JavaPlugin.log(x);
                }
            }
            catch (Throwable throwable) {
                Object var16_25 = null;
                if (!wasJavaDoc) {
                    preferences.put("org.eclipse.wst.jsdt.core.formatter.comment.format_javadoc_comments", "false");
                }
                if (!wasBlockComment) {
                    preferences.put("org.eclipse.wst.jsdt.core.formatter.comment.format_block_comments", "false");
                }
                if (wasLineComment) throw throwable;
                preferences.put("org.eclipse.wst.jsdt.core.formatter.comment.format_line_comments", "false");
                throw throwable;
            }
            {
                Object var16_26 = null;
                if (wasJavaDoc) break block16;
                preferences.put("org.eclipse.wst.jsdt.core.formatter.comment.format_javadoc_comments", "false");
            }
        }
        if (!wasBlockComment) {
            preferences.put("org.eclipse.wst.jsdt.core.formatter.comment.format_block_comments", "false");
        }
        if (wasLineComment) return edit;
        preferences.put("org.eclipse.wst.jsdt.core.formatter.comment.format_line_comments", "false");
        return edit;
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        this.fPartitions.addLast(context.getProperty((Object)"formatting.context.partition"));
        this.fDocuments.addLast(context.getProperty((Object)"formatting.context.medium"));
    }

    public void formatterStops() {
        this.fPartitions.clear();
        this.fDocuments.clear();
        super.formatterStops();
    }

    private static int getKindForPartitionType(String type) {
        if ("__java_singleline_comment".equals(type)) {
            return 16;
        }
        if ("__java_multiline_comment".equals(type)) {
            return 32;
        }
        if ("__java_javadoc".equals(type)) {
            return 64;
        }
        return 0;
    }

    private int inferIndentationLevel(String reference, int tabSize, int indentSize) {
        StringBuffer expanded = CommentFormattingStrategy.expandTabs(reference, tabSize);
        int referenceWidth = expanded.length();
        if (tabSize == 0) {
            return referenceWidth;
        }
        int level = referenceWidth / indentSize;
        if (referenceWidth % indentSize > 0) {
            ++level;
        }
        return level;
    }

    private static StringBuffer expandTabs(String string, int tabSize) {
        StringBuffer expanded = new StringBuffer();
        int i = 0;
        int n = string.length();
        int chars = 0;
        while (i < n) {
            char ch = string.charAt(i);
            if (ch == '\t') {
                while (chars < tabSize) {
                    expanded.append(' ');
                    ++chars;
                }
                chars = 0;
            } else {
                expanded.append(ch);
                if (++chars >= tabSize) {
                    chars = 0;
                }
            }
            ++i;
        }
        return expanded;
    }

    private static int getTabSize(Map preferences) {
        String key = "space".equals(preferences.get("org.eclipse.wst.jsdt.core.formatter.tabulation.char")) ? "org.eclipse.wst.jsdt.core.formatter.indentation.size" : "org.eclipse.wst.jsdt.core.formatter.tabulation.size";
        if (preferences.containsKey(key)) {
            try {
                return Integer.parseInt((String)preferences.get(key));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 4;
    }

    private static int getIndentSize(Map preferences) {
        String key = "mixed".equals(preferences.get("org.eclipse.wst.jsdt.core.formatter.tabulation.char")) ? "org.eclipse.wst.jsdt.core.formatter.indentation.size" : "org.eclipse.wst.jsdt.core.formatter.tabulation.size";
        if (preferences.containsKey(key)) {
            try {
                return Integer.parseInt((String)preferences.get(key));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 4;
    }

    private int computeHeaderEnd(IDocument document, Map preferences) {
        if (document == null) {
            return -1;
        }
        try {
            if (this.fLastMainTokenEnd >= 0 && document.hashCode() == this.fLastDocumentHash && this.fLastMainTokenEnd < document.getLength() && document.get(0, this.fLastMainTokenEnd).hashCode() == this.fLastHeaderHash) {
                return this.fLastDocumentsHeaderEnd;
            }
        }
        catch (BadLocationException badLocationException) {}
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (String)((String)preferences.get("org.eclipse.wst.jsdt.core.compiler.source")), (String)((String)preferences.get("org.eclipse.wst.jsdt.core.compiler.compliance")));
        scanner.setSource(document.get().toCharArray());
        try {
            int offset = -1;
            boolean foundComment = false;
            int terminal = scanner.getNextToken();
            while (terminal == 1003 || terminal == 1000 || terminal == 1001 || terminal == 1002) {
                if (terminal == 1003) {
                    offset = scanner.getCurrentTokenStartPosition();
                }
                foundComment = terminal == 1003 || terminal == 1002;
                terminal = scanner.getNextToken();
            }
            int mainTokenEnd = scanner.getCurrentTokenEndPosition();
            if (terminal != 158) {
                ++mainTokenEnd;
                if (offset == -1 || foundComment && (terminal == 191 || terminal == 214)) {
                    offset = scanner.getCurrentTokenStartPosition();
                }
            } else {
                offset = -1;
            }
            try {
                this.fLastHeaderHash = document.get(0, mainTokenEnd).hashCode();
            }
            catch (BadLocationException badLocationException) {
                mainTokenEnd = -1;
            }
            this.fLastDocumentHash = document.hashCode();
            this.fLastMainTokenEnd = mainTokenEnd;
            this.fLastDocumentsHeaderEnd = offset;
            return offset;
        }
        catch (InvalidInputException invalidInputException) {
            return -1;
        }
    }
}

