/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;

public class CastCompletionProposal
extends LinkedCorrectionProposal {
    public static final String ADD_CAST_ID = "org.eclipse.wst.jsdt.ui.correction.addCast";
    private Expression fNodeToCast;
    private final Object fCastType;

    public CastCompletionProposal(String label, ICompilationUnit targetCU, Expression nodeToCast, String castType, int relevance) {
        super(label, targetCU, (ASTRewrite)null, relevance, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_cast.gif"));
        this.fNodeToCast = nodeToCast;
        this.fCastType = castType;
        this.setCommandId(ADD_CAST_ID);
    }

    public CastCompletionProposal(String label, ICompilationUnit targetCU, Expression nodeToCast, ITypeBinding castType, int relevance) {
        super(label, targetCU, (ASTRewrite)null, relevance, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_cast.gif"));
        this.fNodeToCast = nodeToCast;
        this.fCastType = castType;
        this.setCommandId(ADD_CAST_ID);
    }

    private Type getNewCastTypeNode(ASTRewrite rewrite, ImportRewrite importRewrite) throws CoreException {
        MethodInvocation invocation;
        AST ast = rewrite.getAST();
        if (this.fCastType != null) {
            if (this.fCastType instanceof ITypeBinding) {
                return importRewrite.addImport((ITypeBinding)this.fCastType, ast);
            }
            String string = importRewrite.addImport((String)this.fCastType);
            return ASTNodeFactory.newType(ast, string);
        }
        Expression node = this.fNodeToCast;
        ASTNode parent = node.getParent();
        if (parent instanceof CastExpression) {
            node = parent;
            parent = parent.getParent();
        }
        while (parent instanceof ParenthesizedExpression) {
            node = parent;
            parent = parent.getParent();
        }
        if (parent instanceof MethodInvocation && (invocation = (MethodInvocation)node.getParent()).getExpression() == node) {
            IBinding targetContext = ASTResolving.getParentMethodOrTypeBinding((ASTNode)node);
            ITypeBinding[] bindings = ASTResolving.getQualifierGuess(node.getRoot(), invocation.getName().getIdentifier(), invocation.arguments(), targetContext);
            if (bindings.length > 0) {
                ITypeBinding first = this.getCastFavorite(bindings, this.fNodeToCast.resolveTypeBinding());
                Type newTypeNode = importRewrite.addImport(first, ast);
                this.addLinkedPosition(rewrite.track((ASTNode)newTypeNode), true, "casttype");
                int i = 0;
                while (i < bindings.length) {
                    this.addLinkedPositionProposal("casttype", bindings[i]);
                    ++i;
                }
                return newTypeNode;
            }
        }
        SimpleType newCastType = ast.newSimpleType((Name)ast.newSimpleName("Object"));
        this.addLinkedPosition(rewrite.track((ASTNode)newCastType), true, "casttype");
        return newCastType;
    }

    private ITypeBinding getCastFavorite(ITypeBinding[] suggestedCasts, ITypeBinding nodeToCastBinding) {
        if (nodeToCastBinding == null) {
            return suggestedCasts[0];
        }
        ITypeBinding favourite = suggestedCasts[0];
        int i = 0;
        while (i < suggestedCasts.length) {
            ITypeBinding curr = suggestedCasts[i];
            if (nodeToCastBinding.isCastCompatible(curr)) {
                return curr;
            }
            if (curr.isInterface()) {
                favourite = curr;
            }
            ++i;
        }
        return favourite;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        AST ast = this.fNodeToCast.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ImportRewrite importRewrite = this.createImportRewrite((CompilationUnit)this.fNodeToCast.getRoot());
        Type newTypeNode = this.getNewCastTypeNode(rewrite, importRewrite);
        if (this.fNodeToCast.getNodeType() == 11) {
            CastExpression expression = (CastExpression)this.fNodeToCast;
            rewrite.replace((ASTNode)expression.getType(), (ASTNode)newTypeNode, null);
        } else {
            Expression expressionCopy = (Expression)rewrite.createCopyTarget((ASTNode)this.fNodeToCast);
            if (CastCompletionProposal.needsInnerParantheses((ASTNode)this.fNodeToCast)) {
                ParenthesizedExpression parenthesizedExpression = ast.newParenthesizedExpression();
                parenthesizedExpression.setExpression(expressionCopy);
                expressionCopy = parenthesizedExpression;
            }
            CastExpression castExpression = ast.newCastExpression();
            castExpression.setExpression(expressionCopy);
            castExpression.setType(newTypeNode);
            CastExpression replacingNode = castExpression;
            if (CastCompletionProposal.needsOuterParantheses((ASTNode)this.fNodeToCast)) {
                ParenthesizedExpression parenthesizedExpression = ast.newParenthesizedExpression();
                parenthesizedExpression.setExpression((Expression)castExpression);
                replacingNode = parenthesizedExpression;
            }
            rewrite.replace((ASTNode)this.fNodeToCast, (ASTNode)replacingNode, null);
        }
        return rewrite;
    }

    private static boolean needsInnerParantheses(ASTNode nodeToCast) {
        int nodeType = nodeToCast.getNodeType();
        return nodeType == 27 || nodeType == 16 || nodeType == 7 || nodeType == 62;
    }

    private static boolean needsOuterParantheses(ASTNode nodeToCast) {
        ASTNode parent = nodeToCast.getParent();
        return parent instanceof MethodInvocation ? ((MethodInvocation)parent).getExpression() == nodeToCast : (parent instanceof QualifiedName ? ((QualifiedName)parent).getQualifier() == nodeToCast : parent instanceof FieldAccess && ((FieldAccess)parent).getExpression() == nodeToCast);
    }
}

