/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageDeclaration;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CUCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class CorrectPackageDeclarationProposal
extends CUCorrectionProposal {
    private IProblemLocation fLocation;

    public CorrectPackageDeclarationProposal(ICompilationUnit cu, IProblemLocation location, int relevance) {
        super(CorrectionMessages.CorrectPackageDeclarationProposal_name, cu, relevance, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.packd_obj.gif"));
        this.fLocation = location;
    }

    protected void addEdits(IDocument doc, TextEdit root) throws CoreException {
        super.addEdits(doc, root);
        ICompilationUnit cu = this.getCompilationUnit();
        IPackageFragment parentPack = (IPackageFragment)cu.getParent();
        IPackageDeclaration[] decls = cu.getPackageDeclarations();
        if (parentPack.isDefaultPackage() && decls.length > 0) {
            int i = 0;
            while (i < decls.length) {
                ISourceRange range = decls[i].getSourceRange();
                root.addChild((TextEdit)new DeleteEdit(range.getOffset(), range.getLength()));
                ++i;
            }
            return;
        }
        if (!parentPack.isDefaultPackage() && decls.length == 0) {
            String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)cu);
            String str = "package " + parentPack.getElementName() + ';' + lineDelim + lineDelim;
            root.addChild((TextEdit)new InsertEdit(0, str));
            return;
        }
        root.addChild((TextEdit)new ReplaceEdit(this.fLocation.getOffset(), this.fLocation.getLength(), parentPack.getElementName()));
    }

    public String getDisplayString() {
        ICompilationUnit cu = this.getCompilationUnit();
        IPackageFragment parentPack = (IPackageFragment)cu.getParent();
        try {
            IPackageDeclaration[] decls = cu.getPackageDeclarations();
            if (parentPack.isDefaultPackage() && decls.length > 0) {
                return Messages.format(CorrectionMessages.CorrectPackageDeclarationProposal_remove_description, decls[0].getElementName());
            }
            if (!parentPack.isDefaultPackage() && decls.length == 0) {
                return Messages.format(CorrectionMessages.CorrectPackageDeclarationProposal_add_description, parentPack.getElementName());
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return Messages.format(CorrectionMessages.CorrectPackageDeclarationProposal_change_description, parentPack.getElementName());
    }
}

