/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Annotation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MarkerAnnotation;
import org.eclipse.wst.jsdt.core.dom.MemberValuePair;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NormalAnnotation;
import org.eclipse.wst.jsdt.core.dom.SingleMemberAnnotation;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;

public class MissingAnnotationAttributesProposal
extends LinkedCorrectionProposal {
    private Annotation fAnnotation;

    public MissingAnnotationAttributesProposal(ICompilationUnit cu, Annotation annotation, int relevance) {
        super(CorrectionMessages.MissingAnnotationAttributesProposal_add_missing_attributes_label, cu, (ASTRewrite)null, relevance, (Image)null);
        this.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif"));
        this.fAnnotation = annotation;
        Assert.isNotNull((Object)this.fAnnotation.resolveTypeBinding());
    }

    protected ASTRewrite getRewrite() throws CoreException {
        ListRewrite listRewrite;
        AST ast = this.fAnnotation.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        this.createImportRewrite((CompilationUnit)this.fAnnotation.getRoot());
        if (this.fAnnotation instanceof NormalAnnotation) {
            listRewrite = rewrite.getListRewrite((ASTNode)this.fAnnotation, NormalAnnotation.VALUES_PROPERTY);
        } else {
            NormalAnnotation newAnnotation = ast.newNormalAnnotation();
            newAnnotation.setTypeName((Name)rewrite.createMoveTarget((ASTNode)this.fAnnotation.getTypeName()));
            rewrite.replace((ASTNode)this.fAnnotation, (ASTNode)newAnnotation, null);
            listRewrite = rewrite.getListRewrite((ASTNode)newAnnotation, NormalAnnotation.VALUES_PROPERTY);
        }
        this.addMissingAtributes(this.fAnnotation.resolveTypeBinding(), listRewrite);
        return rewrite;
    }

    private void addMissingAtributes(ITypeBinding binding, ListRewrite listRewriter) {
        HashSet<String> implementedAttribs = new HashSet<String>();
        if (this.fAnnotation instanceof NormalAnnotation) {
            List list = ((NormalAnnotation)this.fAnnotation).values();
            int i = 0;
            while (i < list.size()) {
                MemberValuePair curr = (MemberValuePair)list.get(i);
                implementedAttribs.add(curr.getName().getIdentifier());
                ++i;
            }
        } else if (this.fAnnotation instanceof SingleMemberAnnotation) {
            implementedAttribs.add("value");
        }
        ASTRewrite rewriter = listRewriter.getASTRewrite();
        AST ast = rewriter.getAST();
        IMethodBinding[] declaredMethods = binding.getDeclaredMethods();
        int i = 0;
        while (i < declaredMethods.length) {
            IMethodBinding curr = declaredMethods[i];
            if (!implementedAttribs.contains(curr.getName()) && curr.getDefaultValue() == null) {
                MemberValuePair pair = ast.newMemberValuePair();
                pair.setName(ast.newSimpleName(curr.getName()));
                pair.setValue(this.newDefaultExpression(ast, curr.getReturnType()));
                listRewriter.insertLast((ASTNode)pair, null);
                this.addLinkedPosition(rewriter.track((ASTNode)pair.getName()), false, "val_name_" + i);
                this.addLinkedPosition(rewriter.track((ASTNode)pair.getValue()), false, "val_type_" + i);
            }
            ++i;
        }
    }

    private Expression newDefaultExpression(AST ast, ITypeBinding type) {
        if (type.isPrimitive()) {
            String name = type.getName();
            if ("boolean".equals(name)) {
                return ast.newBooleanLiteral(false);
            }
            return ast.newNumberLiteral("0");
        }
        if (type == ast.resolveWellKnownType("java.lang.String")) {
            return ast.newStringLiteral();
        }
        if (type.isArray()) {
            ArrayInitializer initializer = ast.newArrayInitializer();
            initializer.expressions().add(this.newDefaultExpression(ast, type.getElementType()));
            return initializer;
        }
        if (type.isAnnotation()) {
            MarkerAnnotation annotation = ast.newMarkerAnnotation();
            annotation.setTypeName(ast.newName(this.getImportRewrite().addImport(type)));
            return annotation;
        }
        return ast.newNullLiteral();
    }
}

