/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.VariableDeclarationRewrite;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;

public class ModifierChangeCompletionProposal
extends LinkedCorrectionProposal {
    private IBinding fBinding;
    private ASTNode fNode;
    private int fIncludedModifiers;
    private int fExcludedModifiers;

    public ModifierChangeCompletionProposal(String label, ICompilationUnit targetCU, IBinding binding, ASTNode node, int includedModifiers, int excludedModifiers, int relevance, Image image) {
        super(label, targetCU, (ASTRewrite)null, relevance, image);
        this.fBinding = binding;
        this.fNode = node;
        this.fIncludedModifiers = includedModifiers;
        this.fExcludedModifiers = excludedModifiers;
    }

    protected ASTRewrite getRewrite() {
        CompilationUnit astRoot = ASTResolving.findParentCompilationUnit(this.fNode);
        ASTNode boundNode = astRoot.findDeclaringNode(this.fBinding);
        ASTNode declNode = null;
        TextEditGroup selectionDescription = null;
        if (boundNode != null) {
            declNode = boundNode;
        } else {
            selectionDescription = new TextEditGroup("selection");
            CompilationUnit newRoot = ASTResolving.createQuickFixAST(this.getCompilationUnit(), null);
            declNode = newRoot.findDeclaringNode(this.fBinding.getKey());
        }
        if (declNode != null) {
            AST ast = declNode.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            if (declNode.getNodeType() == 59) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)declNode;
                ASTNode parent = declNode.getParent();
                if (parent instanceof FieldDeclaration) {
                    FieldDeclaration fieldDecl = (FieldDeclaration)parent;
                    if (fieldDecl.fragments().size() > 1 && fieldDecl.getParent() instanceof AbstractTypeDeclaration) {
                        VariableDeclarationRewrite.rewriteModifiers(fieldDecl, new VariableDeclarationFragment[]{fragment}, this.fIncludedModifiers, this.fExcludedModifiers, rewrite, selectionDescription);
                        return rewrite;
                    }
                } else if (parent instanceof VariableDeclarationStatement) {
                    VariableDeclarationStatement varDecl = (VariableDeclarationStatement)parent;
                    if (varDecl.fragments().size() > 1 && varDecl.getParent() instanceof Block) {
                        VariableDeclarationRewrite.rewriteModifiers(varDecl, new VariableDeclarationFragment[]{fragment}, this.fIncludedModifiers, this.fExcludedModifiers, rewrite, selectionDescription);
                        return rewrite;
                    }
                } else {
                    boolean cfr_ignored_0 = parent instanceof VariableDeclarationExpression;
                }
                declNode = parent;
            }
            ModifierRewrite listRewrite = ModifierRewrite.create(rewrite, declNode);
            listRewrite.setModifiers(this.fIncludedModifiers, this.fExcludedModifiers, selectionDescription);
            return rewrite;
        }
        return null;
    }
}

