/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.wst.jsdt.internal.ui.text.java.MemberProposalInfo;

public final class MethodProposalInfo
extends MemberProposalInfo {
    private IMethod fFallbackMatch;

    public MethodProposalInfo(IJavaProject project, CompletionProposal proposal) {
        super(project, proposal);
    }

    protected IMember resolveMember() throws JavaModelException {
        char[] declarationSignature = this.fProposal.getDeclarationSignature();
        if (declarationSignature != null) {
            String typeName = SignatureUtil.stripSignatureToFQN(String.valueOf(declarationSignature));
            String name = String.valueOf(this.fProposal.getName());
            String[] parameters = Signature.getParameterTypes((String)String.valueOf(SignatureUtil.fix83600(this.fProposal.getSignature())));
            int i = 0;
            while (i < parameters.length) {
                parameters[i] = SignatureUtil.getLowerBound(parameters[i]);
                ++i;
            }
            IType type = this.fJavaProject.findType(typeName);
            if (type != null) {
                boolean isConstructor = this.fProposal.isConstructor();
                return this.findMethod(name, parameters, isConstructor, type);
            }
            ITypeRoot typeRoot = this.fJavaProject.findTypeRoot(typeName);
            return typeRoot.getMethod(name, parameters);
        }
        return null;
    }

    private IMethod findMethod(String name, String[] paramTypes, boolean isConstructor, IType type) throws JavaModelException {
        Map typeVariables = this.computeTypeVariables(type);
        return this.findMethod(name, paramTypes, isConstructor, type.getMethods(), typeVariables);
    }

    private Map computeTypeVariables(IType type) throws JavaModelException {
        HashMap<String, char[]> map = new HashMap<String, char[]>();
        char[] declarationSignature = this.fProposal.getDeclarationSignature();
        if (declarationSignature == null) {
            return map;
        }
        char[][] concreteParameters = Signature.getTypeArguments((char[])declarationSignature);
        ITypeParameter[] typeParameters = type.getTypeParameters();
        int i = 0;
        while (i < typeParameters.length) {
            String variable = typeParameters[i].getElementName();
            if (concreteParameters.length > i) {
                map.put(variable, SignatureUtil.getLowerBound(concreteParameters[i]));
            } else {
                map.put(variable, "Ljava.lang.Object;".toCharArray());
            }
            ++i;
        }
        return map;
    }

    private IMethod findMethod(String name, String[] paramTypes, boolean isConstructor, IMethod[] methods, Map typeVariables) throws JavaModelException {
        int i = methods.length - 1;
        while (i >= 0) {
            if (this.isSameMethodSignature(name, paramTypes, isConstructor, methods[i], typeVariables)) {
                return methods[i];
            }
            --i;
        }
        return this.fFallbackMatch;
    }

    private boolean isSameMethodSignature(String name, String[] paramTypes, boolean isConstructor, IMethod method, Map typeVariables) throws JavaModelException {
        String[] otherParams;
        if ((isConstructor || name.equals(method.getElementName())) && isConstructor == method.isConstructor() && paramTypes.length == (otherParams = method.getParameterTypes()).length) {
            this.fFallbackMatch = method;
            String signature = method.getSignature();
            String[] otherParamsFromSignature = Signature.getParameterTypes((String)signature);
            int i = 0;
            while (i < paramTypes.length) {
                String ourParamName = this.computeSimpleTypeName(paramTypes[i], typeVariables);
                String otherParamName1 = this.computeSimpleTypeName(otherParams[i], typeVariables);
                String otherParamName2 = this.computeSimpleTypeName(otherParamsFromSignature[i], typeVariables);
                if (!ourParamName.equals(otherParamName1) && !ourParamName.equals(otherParamName2)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private String computeSimpleTypeName(String signature, Map typeVariables) {
        String erasure = Signature.getTypeErasure((String)signature);
        String simpleName = Signature.getSimpleName((String)Signature.toString((String)(erasure = erasure.replaceAll("/", "."))));
        char[] typeVar = (char[])typeVariables.get(simpleName);
        if (typeVar != null) {
            simpleName = String.valueOf(Signature.getSignatureSimpleName((char[])typeVar));
        }
        return simpleName;
    }
}

