/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.PositionBasedCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.util.StringMatcher;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.ui.JavaElementImageDescriptor;

public class ParameterGuesser {
    private static final char[] NO_TRIGGERS = new char[0];
    private static final char[] VOID = "void".toCharArray();
    private static final char[] HASHCODE = "hashCode()".toCharArray();
    private static final char[] TOSTRING = "toString()".toCharArray();
    private static final char[] CLONE = "clone()".toCharArray();
    private static final Map PRIMITIVE_ASSIGNMENTS;
    private static final Map AUTOUNBOX;
    private final ICompilationUnit fCompilationUnit;
    private final int fCodeAssistOffset;
    private List fVariables;
    private ImageDescriptorRegistry fRegistry = JavaPlugin.getImageDescriptorRegistry();
    private boolean fAllowAutoBoxing;

    static {
        HashMap<String, Set<String>> primitiveAssignments = new HashMap<String, Set<String>>();
        primitiveAssignments.put("boolean", Collections.singleton("boolean"));
        primitiveAssignments.put("byte", Collections.singleton("byte"));
        primitiveAssignments.put("short", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("short", "byte"))));
        primitiveAssignments.put("char", Collections.singleton("char"));
        primitiveAssignments.put("int", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("int", "short", "char", "byte"))));
        primitiveAssignments.put("long", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("long", "int", "short", "char", "byte"))));
        primitiveAssignments.put("float", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("float", "long", "int", "short", "char", "byte"))));
        primitiveAssignments.put("double", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("double", "float", "long", "int", "short", "char", "byte"))));
        primitiveAssignments.put("primitive number", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("double", "float", "long", "int", "short", "byte"))));
        PRIMITIVE_ASSIGNMENTS = Collections.unmodifiableMap(primitiveAssignments);
        HashMap<String, String> autounbox = new HashMap<String, String>();
        autounbox.put("java.lang.Boolean", "boolean");
        autounbox.put("java.lang.Byte", "byte");
        autounbox.put("java.lang.Short", "short");
        autounbox.put("java.lang.Character", "char");
        autounbox.put("java.lang.Integer", "int");
        autounbox.put("java.lang.Long", "long");
        autounbox.put("java.lang.Float", "float");
        autounbox.put("java.lang.Double", "double");
        autounbox.put("java.lang.Number", "primitive number");
        AUTOUNBOX = Collections.unmodifiableMap(autounbox);
    }

    private static final boolean isPrimitiveAssignable(String lhs, String rhs) {
        Set targets = (Set)PRIMITIVE_ASSIGNMENTS.get(lhs);
        return targets != null && targets.contains(rhs);
    }

    private static final String getAutoUnboxedType(String type) {
        String primitive = (String)AUTOUNBOX.get(type);
        return primitive;
    }

    public ParameterGuesser(int codeAssistOffset, ICompilationUnit compilationUnit) {
        Assert.isTrue((codeAssistOffset >= 0 ? 1 : 0) != 0);
        Assert.isNotNull((Object)compilationUnit);
        this.fCodeAssistOffset = codeAssistOffset;
        this.fCompilationUnit = compilationUnit;
        IJavaProject project = this.fCompilationUnit.getJavaProject();
        String sourceVersion = project == null ? JavaCore.getOption((String)"org.eclipse.wst.jsdt.core.compiler.source") : project.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
        this.fAllowAutoBoxing = "1.5".compareTo(sourceVersion) <= 0;
    }

    public int getCodeAssistOffset() {
        return this.fCodeAssistOffset;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public ICompletionProposal[] parameterProposals(String paramPackage, String paramType, String paramName, Position pos, IDocument document) throws JavaModelException {
        if (this.fVariables == null) {
            VariableCollector variableCollector = new VariableCollector();
            this.fVariables = variableCollector.collect(this.fCodeAssistOffset, this.fCompilationUnit);
        }
        Variable parameter = new Variable(paramPackage, paramType, paramName, 0, 0, null, null);
        List typeMatches = this.findProposalsMatchingType(this.fVariables, parameter);
        ParameterGuesser.orderMatches(typeMatches, paramName);
        ICompletionProposal[] ret = new ICompletionProposal[typeMatches.size()];
        int i = 0;
        int replacementLength = 0;
        Iterator it = typeMatches.iterator();
        while (it.hasNext()) {
            Variable v = (Variable)it.next();
            if (i == 0) {
                v.alreadyMatched = true;
                replacementLength = v.name.length();
            }
            final char[] triggers = new char[v.triggerChars.length + 1];
            System.arraycopy(v.triggerChars, 0, triggers, 0, v.triggerChars.length);
            String displayString = v.isAutoboxingMatch ? v.name : v.name;
            triggers[triggers.length - 1] = 59;
            PositionBasedCompletionProposal proposal = new PositionBasedCompletionProposal(v.name, pos, replacementLength, this.getImage(v.descriptor), displayString, null, null){

                public char[] getTriggerCharacters() {
                    return triggers;
                }
            };
            ret[i++] = proposal;
        }
        return ret;
    }

    private static void orderMatches(List typeMatches, String paramName) {
        if (typeMatches != null) {
            Collections.sort(typeMatches, new MatchComparator(paramName));
        }
    }

    private List findProposalsMatchingType(List proposals, Variable parameter) throws JavaModelException {
        if (parameter.getFQN().length() == 0) {
            return null;
        }
        ArrayList<Variable> matches = new ArrayList<Variable>();
        ListIterator iterator = proposals.listIterator(proposals.size());
        while (iterator.hasPrevious()) {
            Variable variable = (Variable)iterator.previous();
            variable.isAutoboxingMatch = false;
            if (!parameter.isAssignable(variable)) continue;
            matches.add(variable);
        }
        return matches;
    }

    private static String getLongestCommonSubstring(String first, String second) {
        String shorter = first.length() <= second.length() ? first : second;
        String longer = shorter == first ? second : first;
        int minLength = shorter.length();
        StringBuffer pattern = new StringBuffer(shorter.length() + 2);
        String longestCommonSubstring = "";
        int i = 0;
        while (i < minLength) {
            int j = i + 1;
            while (j <= minLength) {
                if (j - i >= longestCommonSubstring.length()) {
                    String substring = shorter.substring(i, j);
                    pattern.setLength(0);
                    pattern.append('*');
                    pattern.append(substring);
                    pattern.append('*');
                    StringMatcher matcher = new StringMatcher(pattern.toString(), true, false);
                    if (matcher.match(longer)) {
                        longestCommonSubstring = substring;
                    }
                }
                ++j;
            }
            ++i;
        }
        return longestCommonSubstring;
    }

    private Image getImage(ImageDescriptor descriptor) {
        return descriptor == null ? null : this.fRegistry.get(descriptor);
    }

    private static int getCompletionOffset(String source, int start) {
        char c;
        int index = start;
        while (index > 0 && (c = source.charAt(index - 1)) != '{' && c != ';') {
            --index;
        }
        return Math.min(index + 1, source.length());
    }

    private static class MatchComparator
    implements Comparator {
        private String fParamName;

        MatchComparator(String paramName) {
            this.fParamName = paramName;
        }

        public int compare(Object o1, Object o2) {
            Variable one = (Variable)o1;
            Variable two = (Variable)o2;
            return this.score(two) - this.score(one);
        }

        private int score(Variable v) {
            int shorter;
            int variableScore = 100 - v.variableType;
            int subStringScore = ParameterGuesser.getLongestCommonSubstring(v.name, this.fParamName).length();
            if ((double)subStringScore < 0.6 * (double)(shorter = Math.min(v.name.length(), this.fParamName.length()))) {
                subStringScore = 0;
            }
            int positionScore = v.positionScore;
            int matchedScore = v.alreadyMatched ? 0 : 1;
            int autoboxingScore = v.isAutoboxingMatch ? 0 : 1;
            int score = autoboxingScore << 30 | variableScore << 21 | subStringScore << 11 | matchedScore << 10 | positionScore;
            return score;
        }
    }

    final class Variable {
        public static final int LOCAL = 0;
        public static final int FIELD = 1;
        public static final int METHOD = 1;
        public static final int INHERITED_FIELD = 3;
        public static final int INHERITED_METHOD = 3;
        public final String typePackage;
        public final String typeName;
        public final String name;
        public final int variableType;
        public final int positionScore;
        public boolean alreadyMatched;
        public char[] triggerChars;
        public ImageDescriptor descriptor;
        public boolean isAutoboxingMatch;
        private String fFQN;
        private boolean fFQNResolved = false;
        private IType fType;
        private boolean fTypeResolved = false;

        public Variable(String typePackage, String typeName, String name, int variableType, int positionScore, char[] triggers, ImageDescriptor descriptor) {
            if (typePackage == null) {
                typePackage = "";
            }
            if (typeName == null) {
                typeName = "";
            }
            this.typePackage = typePackage;
            this.typeName = typeName;
            this.name = name;
            this.variableType = variableType;
            this.positionScore = positionScore;
            this.triggerChars = triggers;
            this.descriptor = descriptor;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            if (this.typePackage.length() != 0) {
                buffer.append(this.typePackage);
                buffer.append('.');
            }
            buffer.append(this.typeName);
            buffer.append(' ');
            buffer.append(this.name);
            buffer.append(" (");
            buffer.append(this.variableType);
            buffer.append(')');
            return buffer.toString();
        }

        String getFQN() {
            if (!this.fFQNResolved) {
                this.fFQNResolved = true;
                this.fFQN = this.computeFQN(this.typePackage, this.typeName);
            }
            return this.fFQN;
        }

        private String computeFQN(String pkg, String type) {
            if (pkg.length() != 0) {
                return String.valueOf(pkg) + '.' + type;
            }
            return type;
        }

        IType getType(IJavaProject project) throws JavaModelException {
            if (!this.fTypeResolved) {
                this.fTypeResolved = true;
                if (this.typePackage.length() > 0) {
                    this.fType = project.findType(this.getFQN());
                }
            }
            return this.fType;
        }

        boolean isPrimitive() {
            return PRIMITIVE_ASSIGNMENTS.containsKey(this.getFQN());
        }

        boolean isArrayType() {
            return this.getFQN().endsWith("[]");
        }

        boolean isHierarchyAssignable(Variable rhs) throws JavaModelException {
            IJavaProject project = ParameterGuesser.this.fCompilationUnit.getJavaProject();
            IType paramType = this.getType(project);
            IType varType = rhs.getType(project);
            if (varType == null || paramType == null) {
                return false;
            }
            ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy(varType);
            return hierarchy.contains(paramType);
        }

        boolean isAutoBoxingAssignable(Variable rhs) {
            if (this.isPrimitive()) {
                String unboxedVariable = ParameterGuesser.getAutoUnboxedType(rhs.getFQN());
                return ParameterGuesser.isPrimitiveAssignable(this.typeName, unboxedVariable);
            }
            if (rhs.isPrimitive()) {
                String unboxedType = ParameterGuesser.getAutoUnboxedType(this.getFQN());
                return ParameterGuesser.isPrimitiveAssignable(unboxedType, rhs.typeName);
            }
            return false;
        }

        boolean isAssignable(Variable rhs) throws JavaModelException {
            if (this.typePackage.length() == 0 || rhs.typePackage.length() == 0) {
                if (rhs.typeName.equals(this.typeName)) {
                    return true;
                }
                if (ParameterGuesser.isPrimitiveAssignable(this.typeName, rhs.typeName)) {
                    return true;
                }
                if (ParameterGuesser.this.fAllowAutoBoxing && this.isAutoBoxingAssignable(rhs)) {
                    rhs.isAutoboxingMatch = true;
                    return true;
                }
                return false;
            }
            if (rhs.getFQN().equals(this.getFQN())) {
                return true;
            }
            return this.isHierarchyAssignable(rhs);
        }
    }

    private final class VariableCollector
    extends CompletionRequestor {
        private String fEnclosingTypeName;
        private List fVars;

        VariableCollector() {
            this.setIgnored(1, true);
            this.setIgnored(2, false);
            this.setIgnored(3, true);
            this.setIgnored(4, true);
            this.setIgnored(7, true);
            this.setIgnored(12, true);
            this.setIgnored(6, false);
            this.setIgnored(8, true);
            this.setIgnored(11, true);
            this.setIgnored(10, true);
            this.setIgnored(9, true);
            this.setIgnored(13, false);
            this.setIgnored(5, false);
        }

        public List collect(int codeAssistOffset, ICompilationUnit compilationUnit) throws JavaModelException {
            String thisPkg;
            String thisType;
            Assert.isTrue((codeAssistOffset >= 0 ? 1 : 0) != 0);
            Assert.isNotNull((Object)compilationUnit);
            this.fVars = new ArrayList();
            String source = compilationUnit.getSource();
            if (source == null) {
                return this.fVars;
            }
            this.fEnclosingTypeName = this.getEnclosingTypeName(codeAssistOffset, compilationUnit);
            int completionOffset = ParameterGuesser.getCompletionOffset(source, codeAssistOffset);
            compilationUnit.codeComplete(completionOffset, (CompletionRequestor)this);
            int dotPos = this.fEnclosingTypeName.lastIndexOf(46);
            if (dotPos != -1) {
                thisType = this.fEnclosingTypeName.substring(dotPos + 1);
                thisPkg = this.fEnclosingTypeName.substring(0, dotPos);
            } else {
                thisPkg = new String();
                thisType = this.fEnclosingTypeName;
            }
            this.addVariable(1, thisPkg.toCharArray(), thisType.toCharArray(), "this".toCharArray(), new char[]{'.'}, this.getFieldDescriptor(17));
            this.addVariable(1, NO_TRIGGERS, "boolean".toCharArray(), "true".toCharArray(), NO_TRIGGERS, null);
            this.addVariable(1, NO_TRIGGERS, "boolean".toCharArray(), "false".toCharArray(), NO_TRIGGERS, null);
            return this.fVars;
        }

        private String getEnclosingTypeName(int codeAssistOffset, ICompilationUnit compilationUnit) throws JavaModelException {
            IJavaElement element = compilationUnit.getElementAt(codeAssistOffset);
            if (element == null) {
                return null;
            }
            if ((element = element.getAncestor(7)) == null) {
                return null;
            }
            return element.getElementName();
        }

        private final boolean isInherited(String declaringTypeName) {
            return !declaringTypeName.equals(this.fEnclosingTypeName);
        }

        private void addVariable(int varType, char[] typePackageName, char[] typeName, char[] name, char[] triggers, ImageDescriptor descriptor) {
            this.fVars.add(new Variable(new String(typePackageName), new String(typeName), new String(name), varType, this.fVars.size(), triggers, descriptor));
        }

        private void acceptField(char[] declaringTypeName, char[] name, char[] typePackageName, char[] typeName, int modifiers) {
            if (!this.isInherited(new String(declaringTypeName))) {
                this.addVariable(1, typePackageName, typeName, name, NO_TRIGGERS, this.getFieldDescriptor(modifiers));
            } else {
                this.addVariable(3, typePackageName, typeName, name, NO_TRIGGERS, this.getFieldDescriptor(modifiers));
            }
        }

        private void acceptLocalVariable(char[] name, char[] typePackageName, char[] typeName, int modifiers) {
            this.addVariable(0, typePackageName, typeName, name, NO_TRIGGERS, this.decorate(JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE, modifiers, false));
        }

        private void acceptMethod(char[] declaringTypeName, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers) {
            if (!this.filter(returnTypeName, completionName)) {
                this.addVariable(this.isInherited(new String(declaringTypeName)) ? 3 : 1, returnTypePackageName, returnTypeName, completionName, NO_TRIGGERS, this.getMemberDescriptor(modifiers));
            }
        }

        private boolean filter(char[] returnTypeName, char[] completionName) {
            return Arrays.equals(VOID, returnTypeName) || Arrays.equals(HASHCODE, completionName) || Arrays.equals(TOSTRING, completionName) || Arrays.equals(CLONE, completionName);
        }

        protected ImageDescriptor getMemberDescriptor(int modifiers) {
            ImageDescriptor desc = JavaElementImageProvider.getMethodImageDescriptor(false, modifiers);
            return this.decorate(desc, modifiers, false);
        }

        protected ImageDescriptor getFieldDescriptor(int modifiers) {
            ImageDescriptor desc = JavaElementImageProvider.getFieldImageDescriptor(false, modifiers);
            return this.decorate(desc, modifiers, true);
        }

        private ImageDescriptor decorate(ImageDescriptor descriptor, int modifiers, boolean isField) {
            int flags = 0;
            if (Flags.isDeprecated((int)modifiers)) {
                flags |= 0x400;
            }
            if (Flags.isStatic((int)modifiers)) {
                flags |= 8;
            }
            if (Flags.isFinal((int)modifiers)) {
                flags |= 2;
            }
            if (Flags.isSynchronized((int)modifiers)) {
                flags |= 4;
            }
            if (Flags.isAbstract((int)modifiers)) {
                flags |= 1;
            }
            if (isField) {
                if (Flags.isVolatile((int)modifiers)) {
                    flags |= 0x800;
                }
                if (Flags.isTransient((int)modifiers)) {
                    flags |= 0x1000;
                }
            }
            return new JavaElementImageDescriptor(descriptor, flags, JavaElementImageProvider.SMALL_SIZE);
        }

        public void accept(CompletionProposal proposal) {
            if (this.isIgnored(proposal.getKind())) {
                return;
            }
            switch (proposal.getKind()) {
                case 2: {
                    this.acceptField(Signature.getSignatureSimpleName((char[])proposal.getDeclarationSignature()), proposal.getName(), Signature.getSignatureQualifier((char[])proposal.getSignature()), Signature.getSignatureSimpleName((char[])proposal.getSignature()), proposal.getFlags());
                    return;
                }
                case 5: {
                    this.acceptLocalVariable(proposal.getCompletion(), Signature.getSignatureQualifier((char[])proposal.getSignature()), Signature.getSignatureSimpleName((char[])proposal.getSignature()), proposal.getFlags());
                    return;
                }
                case 6: {
                    if (Signature.getParameterCount((char[])proposal.getSignature()) != 0) break;
                    this.acceptMethod(Signature.getSignatureSimpleName((char[])proposal.getDeclarationSignature()), Signature.getSignatureQualifier((char[])Signature.getReturnType((char[])proposal.getSignature())), Signature.getSignatureSimpleName((char[])Signature.getReturnType((char[])proposal.getSignature())), proposal.getCompletion(), proposal.getFlags());
                }
            }
        }
    }
}

