/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.wst.jsdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.ParameterGuesser;
import org.eclipse.wst.jsdt.ui.text.java.JavaContentAssistInvocationContext;

public final class ParameterGuessingProposal
extends JavaMethodCompletionProposal {
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.jsdt.ui/debug/ResultCollector"));
    private ICompletionProposal[][] fChoices;
    private Position[] fPositions;
    private IRegion fSelectedRegion;
    private IPositionUpdater fUpdater;

    public ParameterGuessingProposal(CompletionProposal proposal, JavaContentAssistInvocationContext context) {
        super(proposal, context);
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            super.apply(document, trigger, offset);
            int baseOffset = this.getReplacementOffset();
            String replacement = this.getReplacementString();
            if (this.fPositions != null && this.getTextViewer() != null) {
                LinkedModeModel model = new LinkedModeModel();
                int i = 0;
                while (i < this.fPositions.length) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    int positionOffset = this.fPositions[i].getOffset();
                    int positionLength = this.fPositions[i].getLength();
                    if (this.fChoices[i].length < 2) {
                        group.addPosition(new LinkedPosition(document, positionOffset, positionLength, -1));
                    } else {
                        this.ensurePositionCategoryInstalled(document, model);
                        document.addPosition(this.getCategory(), this.fPositions[i]);
                        group.addPosition((LinkedPosition)new ProposalPosition(document, positionOffset, positionLength, -1, this.fChoices[i]));
                    }
                    model.addGroup(group);
                    ++i;
                }
                model.forceInstall();
                JavaEditor editor = this.getJavaEditor();
                if (editor != null) {
                    model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(editor));
                }
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.getTextViewer());
                ui.setExitPosition(this.getTextViewer(), baseOffset + replacement.length(), 0, Integer.MAX_VALUE);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new AbstractJavaCompletionProposal.ExitPolicy(')', document));
                ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
                ui.setDoContextInfo(true);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            } else {
                this.fSelectedRegion = new Region(baseOffset + replacement.length(), 0);
            }
        }
        catch (BadLocationException e) {
            this.ensurePositionCategoryRemoved(document);
            JavaPlugin.log(e);
            this.openErrorDialog((Exception)((Object)e));
        }
        catch (BadPositionCategoryException e) {
            this.ensurePositionCategoryRemoved(document);
            JavaPlugin.log(e);
            this.openErrorDialog((Exception)((Object)e));
        }
    }

    protected boolean needsLinkedMode() {
        return false;
    }

    protected String computeReplacementString() {
        String replacement;
        if (!this.hasParameters() || !this.hasArgumentList()) {
            return super.computeReplacementString();
        }
        long millis = DEBUG ? System.currentTimeMillis() : 0L;
        try {
            replacement = this.computeGuessingCompletion();
        }
        catch (JavaModelException x) {
            this.fPositions = null;
            this.fChoices = null;
            JavaPlugin.log(x);
            this.openErrorDialog((Exception)((Object)x));
            return super.computeReplacementString();
        }
        if (DEBUG) {
            System.err.println("Parameter Guessing: " + (System.currentTimeMillis() - millis));
        }
        return replacement;
    }

    private String computeGuessingCompletion() throws JavaModelException {
        StringBuffer buffer = new StringBuffer(String.valueOf(this.fProposal.getName()));
        LazyJavaCompletionProposal.FormatterPrefs prefs = this.getFormatterPrefs();
        if (prefs.beforeOpeningParen) {
            buffer.append(" ");
        }
        buffer.append("(");
        this.setCursorPosition(buffer.length());
        if (prefs.afterOpeningParen) {
            buffer.append(" ");
        }
        this.fChoices = this.guessParameters();
        int count = this.fChoices.length;
        int replacementOffset = this.getReplacementOffset();
        int i = 0;
        while (i < count) {
            if (i != 0) {
                if (prefs.beforeComma) {
                    buffer.append(" ");
                }
                buffer.append(",");
                if (prefs.afterComma) {
                    buffer.append(" ");
                }
            }
            ICompletionProposal proposal = this.fChoices[i][0];
            String argument = proposal.getDisplayString();
            Position position = this.fPositions[i];
            position.setOffset(replacementOffset + buffer.length());
            position.setLength(argument.length());
            if (proposal instanceof JavaCompletionProposal) {
                ((JavaCompletionProposal)proposal).setReplacementOffset(replacementOffset + buffer.length());
            }
            buffer.append(argument);
            ++i;
        }
        if (prefs.beforeClosingParen) {
            buffer.append(" ");
        }
        buffer.append(")");
        return buffer.toString();
    }

    private JavaEditor getJavaEditor() {
        IEditorPart part = JavaPlugin.getActivePage().getActiveEditor();
        if (part instanceof JavaEditor) {
            return (JavaEditor)part;
        }
        return null;
    }

    private ICompletionProposal[][] guessParameters() throws JavaModelException {
        char[][] parameterNames = this.fProposal.findParameterNames(null);
        int count = parameterNames.length;
        this.fPositions = new Position[count];
        this.fChoices = new ICompletionProposal[count][];
        IDocument document = this.fInvocationContext.getDocument();
        ICompilationUnit cu = this.fInvocationContext.getCompilationUnit();
        JavaModelUtil.reconcile(cu);
        String[][] parameterTypes = this.getParameterSignatures();
        ParameterGuesser guesser = new ParameterGuesser(this.fProposal.getCompletionLocation() + 1, cu);
        int i = count - 1;
        while (i >= 0) {
            String paramName = new String(parameterNames[i]);
            Position position = new Position(0, 0);
            ICompletionProposal[] argumentProposals = guesser.parameterProposals(parameterTypes[i][0], parameterTypes[i][1], paramName, position, document);
            if (argumentProposals.length == 0) {
                argumentProposals = new ICompletionProposal[]{new JavaCompletionProposal(paramName, 0, paramName.length(), null, paramName, 0)};
            }
            this.fPositions[i] = position;
            this.fChoices[i] = argumentProposals;
            --i;
        }
        return this.fChoices;
    }

    private String[][] getParameterSignatures() {
        char[] signature = SignatureUtil.fix83600(this.fProposal.getSignature());
        char[][] types = Signature.getParameterTypes((char[])signature);
        String[][] ret = new String[types.length][2];
        int i = 0;
        while (i < types.length) {
            char[] type = SignatureUtil.getLowerBound(types[i]);
            ret[i][0] = String.valueOf(Signature.getSignatureQualifier((char[])type));
            ret[i][1] = String.valueOf(Signature.getSignatureSimpleName((char[])type));
            ++i;
        }
        return ret;
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    private void openErrorDialog(Exception e) {
        Shell shell = this.getTextViewer().getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)JavaTextMessages.ParameterGuessingProposal_error_msg, (String)e.getMessage());
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        if (!document.containsPositionCategory(this.getCategory())) {
            document.addPositionCategory(this.getCategory());
            this.fUpdater = new InclusivePositionUpdater(this.getCategory());
            document.addPositionUpdater(this.fUpdater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    ParameterGuessingProposal.this.ensurePositionCategoryRemoved(document);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.getCategory())) {
            try {
                document.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            document.removePositionUpdater(this.fUpdater);
        }
    }

    private String getCategory() {
        return "ParameterGuessingProposal_" + this.toString();
    }
}

